/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import pl.akmf.ksef.sdk.api.HttpStatus;
import pl.akmf.ksef.sdk.api.HttpUtils;
import pl.akmf.ksef.sdk.api.KsefApiProperties;
import pl.akmf.ksef.sdk.api.SimpleHttpClient;
import pl.akmf.ksef.sdk.api.Url;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.ApiResponse;
import pl.akmf.ksef.sdk.client.model.ExceptionResponse;
import pl.akmf.ksef.sdk.client.model.UpoVersion;
import pl.akmf.ksef.sdk.client.model.auth.AuthKsefTokenRequest;
import pl.akmf.ksef.sdk.client.model.auth.AuthOperationStatusResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthStatus;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationChallengeResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationToken;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationTokenRefreshResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationTokenStatus;
import pl.akmf.ksef.sdk.client.model.auth.AuthorTokenIdentifier;
import pl.akmf.ksef.sdk.client.model.auth.GenerateTokenResponse;
import pl.akmf.ksef.sdk.client.model.auth.KsefTokenRequest;
import pl.akmf.ksef.sdk.client.model.auth.QueryTokensResponse;
import pl.akmf.ksef.sdk.client.model.auth.SignatureResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentStatusResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentsInfoResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateLimitsResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateListRequest;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateListResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateMetadataListResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateRevokeRequest;
import pl.akmf.ksef.sdk.client.model.certificate.QueryCertificatesRequest;
import pl.akmf.ksef.sdk.client.model.certificate.SendCertificateEnrollmentRequest;
import pl.akmf.ksef.sdk.client.model.certificate.publickey.PublicKeyCertificate;
import pl.akmf.ksef.sdk.client.model.invoice.InitAsyncInvoicesQueryResponse;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportRequest;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportStatus;
import pl.akmf.ksef.sdk.client.model.invoice.InvoicePackagePart;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQueryFilters;
import pl.akmf.ksef.sdk.client.model.invoice.QueryInvoiceMetadataResponse;
import pl.akmf.ksef.sdk.client.model.limit.ChangeContextLimitRequest;
import pl.akmf.ksef.sdk.client.model.limit.ChangeSubjectCertificateLimitRequest;
import pl.akmf.ksef.sdk.client.model.limit.GetContextLimitResponse;
import pl.akmf.ksef.sdk.client.model.limit.GetRateLimitResponse;
import pl.akmf.ksef.sdk.client.model.limit.GetSubjectLimitResponse;
import pl.akmf.ksef.sdk.client.model.permission.OperationResponse;
import pl.akmf.ksef.sdk.client.model.permission.PermissionAttachmentStatusResponse;
import pl.akmf.ksef.sdk.client.model.permission.PermissionStatusInfo;
import pl.akmf.ksef.sdk.client.model.permission.entity.GrantEntityPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.euentity.EuEntityPermissionsGrantRequest;
import pl.akmf.ksef.sdk.client.model.permission.euentity.GrantEUEntityRepresentativePermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.indirect.GrantIndirectEntityPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.person.GrantPersonPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.proxy.GrantAuthorizationPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.EntityAuthorizationPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.EuEntityPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityAuthorizationPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityRolesResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEuEntityPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QuerySubunitPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.SubunitPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.subunit.SubunitPermissionsGrantRequest;
import pl.akmf.ksef.sdk.client.model.session.AuthenticationListResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoiceStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoicesResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.session.SessionsQueryResponse;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartStreamSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.batch.PackagePartSignatureInitResponseType;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceResponse;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataAttachmentRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataAttachmentRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPermissionRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPermissionRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPersonCreateRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPersonRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataSubjectCreateRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataSubjectRemoveRequest;
import pl.akmf.ksef.sdk.client.model.util.SortOrder;
import pl.akmf.ksef.sdk.client.peppol.PeppolProvidersListResponse;
import pl.akmf.ksef.sdk.system.SystemKSeFSDKException;

public class DefaultKsefClient
implements KSeFClient {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private final ObjectMapper objectMapper;
    private final String baseURl;
    private final String suffixURl;
    private final Duration timeout;
    private final Map<String, String> defaultHeaders;

    public DefaultKsefClient(Object apiClient, KsefApiProperties ksefApiProperties, ObjectMapper objectMapper) {
        this.defaultHeaders = ksefApiProperties.getDefaultHeaders();
        this.timeout = ksefApiProperties.getRequestTimeout();
        this.baseURl = ksefApiProperties.getBaseUri();
        this.suffixURl = ksefApiProperties.getSuffixUri();
        this.objectMapper = objectMapper;
    }

    @Override
    public OperationResponse grantsPermissionsProxyEntity(GrantAuthorizationPermissionsRequest entityAuthorizationPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_AUTHORIZED_SUBJECT_PERMISSION.getUrl(), entityAuthorizationPermissionsGrantRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_AUTHORIZED_SUBJECT_PERMISSION, OperationResponse.class);
    }

    @Override
    public OperationResponse grantsPermissionIndirectEntity(GrantIndirectEntityPermissionsRequest grantIndirectEntityPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_INDIRECT_PERMISSION.getUrl(), grantIndirectEntityPermissionsRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_INDIRECT_PERMISSION, OperationResponse.class);
    }

    @Override
    public OpenBatchSessionResponse openBatchSession(OpenBatchSessionRequest openBatchSessionRequest, UpoVersion upoVersion, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("X-KSeF-Feature", upoVersion.value());
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.BATCH_SESSION_OPEN.getUrl(), openBatchSessionRequest, headers);
        return this.getResponse(response, HttpStatus.CREATED, Url.BATCH_SESSION_OPEN, OpenBatchSessionResponse.class);
    }

    @Override
    public void closeBatchSession(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling closeBatchSession");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.BATCH_SESSION_CLOSE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, null, headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.BATCH_SESSION_OPEN);
    }

    @Override
    public void sendBatchParts(OpenBatchSessionResponse openBatchSessionResponse, List<BatchPartSendingInfo> parts) throws ApiException {
        if (CollectionUtils.isEmpty(parts)) {
            throw new IllegalArgumentException("No files to send.");
        }
        List<PackagePartSignatureInitResponseType> responsePartUploadRequests = openBatchSessionResponse.getPartUploadRequests();
        if (CollectionUtils.isEmpty(responsePartUploadRequests)) {
            throw new IllegalStateException("No information about parts to send.");
        }
        ArrayList errors = new ArrayList();
        for (PackagePartSignatureInitResponseType responsePart : responsePartUploadRequests) {
            parts.stream().filter(p -> responsePart.getOrdinalNumber() == p.getOrdinalNumber()).forEach(singlePart -> this.singleBatchPartSendingProcess((BatchPartSendingInfo)singlePart, responsePart, errors));
        }
        if (!errors.isEmpty()) {
            throw new ApiException("Errors when sending parts:\n" + String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public void sendBatchPartsWithStream(OpenBatchSessionResponse openBatchSessionResponse, List<BatchPartStreamSendingInfo> parts) throws ApiException {
        if (CollectionUtils.isEmpty(parts)) {
            throw new IllegalArgumentException("No files to send.");
        }
        List<PackagePartSignatureInitResponseType> responsePartUploadRequests = openBatchSessionResponse.getPartUploadRequests();
        if (CollectionUtils.isEmpty(responsePartUploadRequests)) {
            throw new IllegalStateException("No information about parts to send.");
        }
        ArrayList errors = new ArrayList();
        for (PackagePartSignatureInitResponseType responsePart : responsePartUploadRequests) {
            parts.stream().filter(p -> responsePart.getOrdinalNumber() == p.getOrdinalNumber()).forEach(singlePart -> this.singleBatchPartSendingProcessByStream((BatchPartStreamSendingInfo)singlePart, responsePart, errors));
        }
        if (!errors.isEmpty()) {
            throw new ApiException("Errors when sending parts:\n" + String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public OpenOnlineSessionResponse openOnlineSession(OpenOnlineSessionRequest openOnlineSessionRequest, UpoVersion upoVersion, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("X-KSeF-Feature", upoVersion.value());
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.SESSION_OPEN.getUrl(), openOnlineSessionRequest, headers);
        return this.getResponse(response, HttpStatus.CREATED, Url.SESSION_OPEN, OpenOnlineSessionResponse.class);
    }

    @Override
    public void closeOnlineSession(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling apiV2SessionsOnlineReferenceNumberClosePost");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_CLOSE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, null, headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.SESSION_CLOSE);
    }

    @Override
    public SendInvoiceResponse onlineSessionSendInvoice(String referenceNumber, SendInvoiceOnlineSessionRequest sendInvoiceOnlineSessionRequest, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling apiV2SessionsOnlineReferenceNumberClosePost");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_SEND.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, sendInvoiceOnlineSessionRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.SESSION_INVOICE_SEND, SendInvoiceResponse.class);
    }

    @Override
    public CertificateLimitsResponse getCertificateLimits(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.CERTIFICATE_LIMIT.getUrl(), headers);
        return this.getResponse(response, HttpStatus.OK, Url.CERTIFICATE_LIMIT, CertificateLimitsResponse.class);
    }

    @Override
    public CertificateEnrollmentsInfoResponse getCertificateEnrollmentInfo(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.CERTIFICATE_ENROLLMENT_DATA.getUrl(), headers);
        return this.getResponse(response, HttpStatus.OK, Url.CERTIFICATE_ENROLLMENT_DATA, CertificateEnrollmentsInfoResponse.class);
    }

    @Override
    public CertificateEnrollmentResponse sendCertificateEnrollment(SendCertificateEnrollmentRequest enrollCertificateRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.CERTIFICATE_ENROLLMENT.getUrl(), enrollCertificateRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.CERTIFICATE_ENROLLMENT, CertificateEnrollmentResponse.class);
    }

    @Override
    public CertificateEnrollmentStatusResponse getCertificateEnrollmentStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.CERTIFICATE_STATUS, CertificateEnrollmentStatusResponse.class);
    }

    @Override
    public CertificateListResponse getCertificateList(CertificateListRequest certificateListRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.CERTIFICATE_RETRIEVE.getUrl(), certificateListRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.CERTIFICATE_RETRIEVE, CertificateListResponse.class);
    }

    @Override
    public void revokeCertificate(CertificateRevokeRequest certificateRevokeRequest, String certificateSerialNumber, String accessToken) throws ApiException {
        if (certificateSerialNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'certificateSerialNumber' when calling revokeCertificate");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_REVOKE.getUrl(), new HashMap<String, String>()).replace("{certificateSerialNumber}", certificateSerialNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, certificateRevokeRequest, headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.CERTIFICATE_REVOKE);
    }

    @Override
    public CertificateMetadataListResponse getCertificateMetadataList(QueryCertificatesRequest queryCertificatesRequest, int pageSize, int pageOffset, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_METADATA.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, queryCertificatesRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.CERTIFICATE_METADATA, CertificateMetadataListResponse.class);
    }

    @Override
    public AuthenticationChallengeResponse getAuthChallenge() throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_CHALLENGE.getUrl(), null, headers);
        return this.getResponse(response, HttpStatus.OK, Url.AUTH_CHALLENGE, AuthenticationChallengeResponse.class);
    }

    @Override
    public SignatureResponse submitAuthTokenRequest(String signedXml, boolean verifyCertificateChain) throws ApiException {
        if (signedXml == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'body' when calling apiV2AuthTokenSignaturePost");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("verifyCertificateChain", String.valueOf(verifyCertificateChain));
        String uri = HttpUtils.buildUrlWithParams(Url.AUTH_TOKEN_SIGNATURE.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, signedXml, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.AUTH_TOKEN_SIGNATURE, SignatureResponse.class);
    }

    @Override
    public SignatureResponse authenticateByKSeFToken(AuthKsefTokenRequest body) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_KSEF_TOKEN.getUrl(), body, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.AUTH_KSEF_TOKEN, SignatureResponse.class);
    }

    @Override
    public AuthStatus getAuthStatus(String referenceNumber, String authenticationToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenReferenceNumber' when calling apiV2AuthTokenTokenReferenceNumberGet");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.AUTH_TOKEN_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + authenticationToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.AUTH_TOKEN_STATUS, AuthStatus.class);
    }

    @Override
    public AuthOperationStatusResponse redeemToken(String authenticationToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + authenticationToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_TOKEN_REEDEM.getUrl(), null, headers);
        return this.getResponse(response, HttpStatus.OK, Url.AUTH_TOKEN_REEDEM, AuthOperationStatusResponse.class);
    }

    @Override
    public AuthenticationTokenRefreshResponse refreshAccessToken(String refreshToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + refreshToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.JWT_TOKEN_REFRESH.getUrl(), null, headers);
        return this.getResponse(response, HttpStatus.OK, Url.JWT_TOKEN_REFRESH, AuthenticationTokenRefreshResponse.class);
    }

    @Override
    public void revokeAccessToken(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.JWT_TOKEN_REVOKE.getUrl(), null, headers);
        this.validResponse(response, HttpStatus.OK, Url.JWT_TOKEN_REVOKE);
    }

    @Override
    public PermissionStatusInfo permissionOperationStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_STATUS, PermissionStatusInfo.class);
    }

    @Override
    public QueryPersonPermissionsResponse searchGrantedPersonPermissions(PersonPermissionsQueryRequest personPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_PERSON_PERMISSION.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, personPermissionsQueryRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_PERSON_PERMISSION, QueryPersonPermissionsResponse.class);
    }

    @Override
    public QuerySubunitPermissionsResponse searchSubunitAdminPermissions(SubunitPermissionsQueryRequest subunitPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_SUBUNIT_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, subunitPermissionsQueryRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_SUBUNIT_GRANT, QuerySubunitPermissionsResponse.class);
    }

    @Override
    public QueryPersonalGrantResponse searchPersonalGrantPermission(QueryPersonalGrantRequest request, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_PERSONAL_GRANTS.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, request, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_PERSONAL_GRANTS, QueryPersonalGrantResponse.class);
    }

    @Override
    public QueryEntityRolesResponse searchEntityInvoiceRoles(int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_ENTITY_ROLES.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_ENTITY_ROLES, QueryEntityRolesResponse.class);
    }

    @Override
    public SubordinateEntityRolesQueryResponse searchSubordinateEntityInvoiceRoles(SubordinateEntityRolesQueryRequest subordinateEntityRolesQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_SUBORDINATE_PERMISSION.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, subordinateEntityRolesQueryRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_SUBORDINATE_PERMISSION, SubordinateEntityRolesQueryResponse.class);
    }

    @Override
    public QueryEntityAuthorizationPermissionsResponse searchEntityAuthorizationGrants(EntityAuthorizationPermissionsQueryRequest entityAuthorizationPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_AUTHORIZATIONS_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, entityAuthorizationPermissionsQueryRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_AUTHORIZATIONS_GRANT, QueryEntityAuthorizationPermissionsResponse.class);
    }

    @Override
    public QueryEuEntityPermissionsResponse searchGrantedEuEntityPermissions(EuEntityPermissionsQueryRequest euEntityPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_EU_ENTITY_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, euEntityPermissionsQueryRequest, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_SEARCH_EU_ENTITY_GRANT, QueryEuEntityPermissionsResponse.class);
    }

    @Override
    public OperationResponse grantsPermissionEUEntity(EuEntityPermissionsGrantRequest euEntityPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_EU_ADMINISTRATOR_PERMISSION.getUrl(), euEntityPermissionsGrantRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_EU_ADMINISTRATOR_PERMISSION, OperationResponse.class);
    }

    @Override
    public OperationResponse grantsPermissionEUEntityRepresentative(GrantEUEntityRepresentativePermissionsRequest grantEUEntityRepresentativePermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_EU_REPRESENTATIVE.getUrl(), grantEUEntityRepresentativePermissionsRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_EU_REPRESENTATIVE, OperationResponse.class);
    }

    @Override
    public byte[] getInvoice(String ksefReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_DOWNLOAD_BY_KSEF.getUrl(), new HashMap<String, String>()).replace("{ksefReferenceNumber}", ksefReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.INVOICE_DOWNLOAD_BY_KSEF);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public QueryInvoiceMetadataResponse queryInvoiceMetadata(Integer pageOffset, Integer pageSize, SortOrder sortOrder, InvoiceQueryFilters invoiceQueryFilters, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        params.put("sortOrder", sortOrder.getValue());
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_QUERY_METADATA.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, invoiceQueryFilters, headers);
        return this.getResponse(response, HttpStatus.OK, Url.INVOICE_QUERY_METADATA, QueryInvoiceMetadataResponse.class);
    }

    @Override
    public InitAsyncInvoicesQueryResponse initAsyncQueryInvoice(InvoiceExportRequest invoiceExportRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.INVOICE_EXPORT_INIT.getUrl(), invoiceExportRequest, headers);
        return this.getResponse(response, HttpStatus.CREATED, Url.INVOICE_EXPORT_INIT, InitAsyncInvoicesQueryResponse.class);
    }

    @Override
    public InvoiceExportStatus checkStatusAsyncQueryInvoice(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'operationReferenceNumber' when calling checkStatusAsyncQueryInvoice");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_EXPORT_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.INVOICE_EXPORT_STATUS, InvoiceExportStatus.class);
    }

    @Override
    public OperationResponse grantsPermissionEntity(GrantEntityPermissionsRequest grantEntityPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_INVOICE_SUBJECT_PERMISSION.getUrl(), grantEntityPermissionsRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_INVOICE_SUBJECT_PERMISSION, OperationResponse.class);
    }

    @Override
    public SessionStatusResponse getSessionStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_STATUS, SessionStatusResponse.class);
    }

    @Override
    public SessionInvoiceStatusResponse getSessionInvoiceStatus(String referenceNumber, String invoiceReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_GET_BY_REFERENCE_NUMBER.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{invoiceReferenceNumber}", invoiceReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_INVOICE_GET_BY_REFERENCE_NUMBER, SessionInvoiceStatusResponse.class);
    }

    @Override
    public byte[] getSessionInvoiceUpoByReferenceNumber(String referenceNumber, String invoiceReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_UPO_BY_INVOICE_REFERENCE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{invoiceReferenceNumber}", invoiceReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.SESSION_INVOICE_UPO_BY_INVOICE_REFERENCE);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public byte[] getSessionInvoiceUpoByKsefNumber(String referenceNumber, String ksefNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_UPO_BY_KSEF.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{ksefNumber}", ksefNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.SESSION_INVOICE_UPO_BY_KSEF);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public byte[] getSessionUpo(String referenceNumber, String upoReferenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling getSessionUpo");
        }
        if (upoReferenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'upoReferenceNumber' when calling getSessionUpo");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_UPO.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{upoReferenceNumber}", upoReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.SESSION_UPO);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public SessionInvoicesResponse getSessionInvoices(String referenceNumber, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE.getUrl(), params).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_INVOICE, SessionInvoicesResponse.class);
    }

    @Override
    public SessionInvoicesResponse getSessionFailedInvoices(String referenceNumber, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_FAILED.getUrl(), params).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_INVOICE_FAILED, SessionInvoicesResponse.class);
    }

    @Override
    public SessionsQueryResponse getSessions(SessionsQueryRequest request, Integer pageSize, String continuationToken, String accessToken) throws ApiException {
        ArrayList<HttpUtils.KeyValue> keyValues = new ArrayList<HttpUtils.KeyValue>();
        keyValues.add(new HttpUtils.KeyValue("pageSize", String.valueOf(pageSize)));
        if (Objects.nonNull((Object)request.getSessionType())) {
            keyValues.add(new HttpUtils.KeyValue("sessionType", request.getSessionType().getValue()));
        }
        if (Objects.nonNull(request.getReferenceNumber())) {
            keyValues.add(new HttpUtils.KeyValue("referenceNumber", request.getReferenceNumber()));
        }
        if (Objects.nonNull(request.getDateCreatedFrom())) {
            keyValues.add(new HttpUtils.KeyValue("dateCreatedFrom", request.getDateCreatedFrom().toString()));
        }
        if (Objects.nonNull(request.getDateCreatedTo())) {
            keyValues.add(new HttpUtils.KeyValue("dateCreatedTo", request.getDateCreatedTo().toString()));
        }
        if (Objects.nonNull(request.getDateClosedFrom())) {
            keyValues.add(new HttpUtils.KeyValue("dateClosedFrom", request.getDateClosedFrom().toString()));
        }
        if (Objects.nonNull(request.getDateClosedTo())) {
            keyValues.add(new HttpUtils.KeyValue("dateClosedTo", request.getDateClosedTo().toString()));
        }
        if (Objects.nonNull(request.getDateModifiedFrom())) {
            keyValues.add(new HttpUtils.KeyValue("dateModifiedFrom", request.getDateModifiedFrom().toString()));
        }
        if (Objects.nonNull(request.getDateModifiedFrom())) {
            keyValues.add(new HttpUtils.KeyValue("dateModifiedTo", request.getDateModifiedTo().toString()));
        }
        if (Objects.nonNull(request.getStatuses())) {
            request.getStatuses().forEach(status -> keyValues.add(new HttpUtils.KeyValue("statuses", status.getValue())));
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_LIST.getUrl(), keyValues);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_LIST, SessionsQueryResponse.class);
    }

    @Override
    public AuthenticationListResponse getActiveSessions(Integer pageSize, String continuationToken, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_ACTIVE_SESSIONS.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.SESSION_ACTIVE_SESSIONS, AuthenticationListResponse.class);
    }

    @Override
    public void revokeCurrentSession(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(Url.SESSION_REVOKE_CURRENT_SESSION.getUrl(), headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.SESSION_REVOKE_CURRENT_SESSION);
    }

    @Override
    public void revokeSession(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_REVOKE_SESSION.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.SESSION_REVOKE_SESSION);
    }

    @Override
    public PeppolProvidersListResponse getPeppolProvidersList(int pageOffset, int pageSize) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PEPPOL_QUERY.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.PEPPOL_QUERY, PeppolProvidersListResponse.class);
    }

    @Override
    public GetContextLimitResponse getContextSessionLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_CONTEXT.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.LIMIT_CONTEXT, GetContextLimitResponse.class);
    }

    @Override
    public GetSubjectLimitResponse getSubjectCertificateLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_SUBJECT_CERTIFICATE.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.LIMIT_SUBJECT_CERTIFICATE, GetSubjectLimitResponse.class);
    }

    @Override
    public void changeContextLimitTest(ChangeContextLimitRequest changeContextLimitRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        String url = Url.LIMIT_CONTEXT_CHANGE_TEST.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, changeContextLimitRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.LIMIT_CONTEXT_CHANGE_TEST);
    }

    @Override
    public void restoreProductionRateLimitsAsync(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        String url = Url.LIMIT_CONTEXT_SET_PRODUCTION.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, null, headers);
        this.validResponse(response, HttpStatus.OK, Url.LIMIT_CONTEXT_SET_PRODUCTION);
    }

    @Override
    public void changeSubjectLimitTest(ChangeSubjectCertificateLimitRequest changeSubjectCertificateLimitRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        String url = Url.LIMIT_SUBJECT_CERTIFICATE_CHANGE_TEST.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, changeSubjectCertificateLimitRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.LIMIT_SUBJECT_CERTIFICATE_CHANGE_TEST);
    }

    @Override
    public void resetContextLimitTest(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_CONTEXT_RESET_TEST.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.LIMIT_CONTEXT_RESET_TEST);
    }

    @Override
    public void resetSubjectCertificateLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_SUBJECT_CERTIFICATE_RESET_TEST.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        this.validResponse(response, HttpStatus.OK, Url.LIMIT_SUBJECT_CERTIFICATE_RESET_TEST);
    }

    @Override
    public void createTestSubject(TestDataSubjectCreateRequest testDataSubjectCreateRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_SUBJECT_CREATE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataSubjectCreateRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_SUBJECT_CREATE);
    }

    @Override
    public void removeTestSubject(TestDataSubjectRemoveRequest testDataSubjectRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_SUBJECT_DELETE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataSubjectRemoveRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_SUBJECT_DELETE);
    }

    @Override
    public void createTestPerson(TestDataPersonCreateRequest testDataPersonCreateRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERSON_CREATE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPersonCreateRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_PERSON_CREATE);
    }

    @Override
    public void removeTestPerson(TestDataPersonRemoveRequest testDataPersonRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERSON_DELETE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPersonRemoveRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_PERSON_DELETE);
    }

    @Override
    public GetRateLimitResponse getRateLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.GET_RATE_LIMIT.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.GET_RATE_LIMIT, GetRateLimitResponse.class);
    }

    @Override
    public void addTestPermission(TestDataPermissionRequest testDataPermissionRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERMISSION.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPermissionRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_PERMISSION);
    }

    @Override
    public void removeTestPermission(TestDataPermissionRemoveRequest testDataPermissionRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERMISSION_REVOKE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPermissionRemoveRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_PERMISSION_REVOKE);
    }

    @Override
    public void addAttachmentPermissionTest(TestDataAttachmentRequest testDataAttachmentRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_ATTACHMENT.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataAttachmentRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_ATTACHMENT);
    }

    @Override
    public void removeAttachmentPermissionTest(TestDataAttachmentRemoveRequest testDataAttachmentRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_ATTACHMENT_REVOKE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataAttachmentRemoveRequest, headers);
        this.validResponse(response, HttpStatus.OK, Url.TEST_ATTACHMENT_REVOKE);
    }

    @Override
    public OperationResponse grantsPermissionPerson(GrantPersonPermissionsRequest grantPersonPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_PERSON_PERMISSION.getUrl(), grantPersonPermissionsRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_PERSON_PERMISSION, OperationResponse.class);
    }

    @Override
    public OperationResponse grantsPermissionSubUnit(SubunitPermissionsGrantRequest subunitPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_SUBUNIT_PERMISSION.getUrl(), subunitPermissionsGrantRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.GRANT_SUBUNIT_PERMISSION, OperationResponse.class);
    }

    @Override
    public OperationResponse revokeCommonPermission(String permissionId, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_REVOKE_COMMON.getUrl(), new HashMap<String, String>()).replace("{permissionId}", permissionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.PERMISSION_REVOKE_COMMON, OperationResponse.class);
    }

    @Override
    public OperationResponse revokeAuthorizationsPermission(String permissionId, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_REVOKE_AUTHORIZATION.getUrl(), new HashMap<String, String>()).replace("{permissionId}", permissionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.PERMISSION_REVOKE_AUTHORIZATION, OperationResponse.class);
    }

    @Override
    public PermissionAttachmentStatusResponse checkPermissionAttachmentInvoiceStatus(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.PERMISSION_ATTACHMENT_STATUS.getUrl(), headers);
        return this.getResponse(response, HttpStatus.OK, Url.PERMISSION_ATTACHMENT_STATUS, PermissionAttachmentStatusResponse.class);
    }

    @Override
    public GenerateTokenResponse generateKsefToken(KsefTokenRequest ksefTokenRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.TOKEN_GENERATE.getUrl(), ksefTokenRequest, headers);
        return this.getResponse(response, HttpStatus.ACCEPTED, Url.TOKEN_GENERATE, GenerateTokenResponse.class);
    }

    @Override
    public QueryTokensResponse queryKsefTokens(List<AuthenticationTokenStatus> statuses, String description, String authorIdentifier, AuthorTokenIdentifier.IdentifierType authorIdentifierType, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        statuses.forEach(stat -> params.put("status", stat.toString()));
        if (pageSize != null) {
            params.put("pageSize", String.valueOf(pageSize));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            params.put("description", description);
        }
        if (StringUtils.isNotBlank((CharSequence)authorIdentifier)) {
            params.put("authorIdentifier", authorIdentifier);
        }
        if (Objects.nonNull((Object)authorIdentifierType)) {
            params.put("authorIdentifierType", authorIdentifierType.getValue());
        }
        String uri = HttpUtils.buildUrlWithParams(Url.TOKEN_LIST.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.TOKEN_LIST, QueryTokensResponse.class);
    }

    @Override
    public AuthenticationToken getKsefToken(String referenceNumber, String accessToken) throws ApiException {
        String uri = Url.TOKEN_STATUS.getUrl().replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        return this.getResponse(response, HttpStatus.OK, Url.TOKEN_STATUS, AuthenticationToken.class);
    }

    @Override
    public void revokeKsefToken(String referenceNumber, String accessToken) throws ApiException {
        String uri = Url.TOKEN_REVOKE.getUrl().replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        this.validResponse(response, HttpStatus.NO_CONTENT, Url.TOKEN_REVOKE);
    }

    @Override
    public List<PublicKeyCertificate> retrievePublicKeyCertificate() throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.SECURITY_PUBLIC_KEY_CERTIFICATE.getUrl(), headers);
        this.validResponse(response, HttpStatus.OK, Url.SECURITY_PUBLIC_KEY_CERTIFICATE);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (List)this.objectMapper.readValue(response.body(), (TypeReference)new TypeReference<List<PublicKeyCertificate>>(){}))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse get(String uri, Map<String, String> headers) {
        try {
            String fullUrl = this.buildUri(this.baseURl, this.suffixURl, uri).toString();
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            return SimpleHttpClient.sendRequest(fullUrl, GET, null, allHeaders, this.timeout);
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse post(String uri, Object body, Map<String, String> headers) throws SystemKSeFSDKException {
        try {
            String fullUrl = this.buildUri(this.baseURl, this.suffixURl, uri).toString();
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            byte[] bodyBytes = null;
            if (body != null) {
                bodyBytes = body instanceof String ? ((String)body).getBytes(StandardCharsets.UTF_8) : this.objectMapper.writeValueAsBytes(body);
            }
            return SimpleHttpClient.sendRequest(fullUrl, POST, bodyBytes, allHeaders, this.timeout);
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse delete(String uri, Map<String, String> headers) throws SystemKSeFSDKException {
        try {
            String fullUrl = this.buildUri(this.baseURl, this.suffixURl, uri).toString();
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            return SimpleHttpClient.sendRequest(fullUrl, DELETE, null, allHeaders, this.timeout);
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    @Override
    public void singleBatchPartSendingProcessByStream(BatchPartStreamSendingInfo part, PackagePartSignatureInitResponseType responsePart, List<String> errors) {
        InputStream dataStream = part.getDataStream();
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultHeaders);
        headers.put("Content-Type", "application/octet-stream");
        if (responsePart.getHeaders() != null) {
            headers.putAll(responsePart.getHeaders());
        }
        String url = responsePart.getUrl().toString();
        try {
            SimpleHttpClient.SimpleHttpResponse responseResult = SimpleHttpClient.sendRequestWithStream(url, PUT, dataStream, part.getMetadata().getFileSize(), headers, this.timeout);
            if (HttpStatus.CREATED.getCode() != responseResult.statusCode()) {
                errors.add("Error sends part " + responsePart.getOrdinalNumber() + ": " + responseResult.statusCode());
            }
        }
        catch (IOException e) {
            errors.add("Error sends part " + responsePart.getOrdinalNumber() + ": " + e.getMessage());
        }
    }

    @Override
    public void singleBatchPartSendingProcess(BatchPartSendingInfo part, PackagePartSignatureInitResponseType responsePart, List<String> errors) {
        byte[] fileBytes = part.getData();
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultHeaders);
        headers.put("Content-Type", "application/octet-stream");
        if (responsePart.getHeaders() != null) {
            headers.putAll(responsePart.getHeaders());
        }
        String url = responsePart.getUrl().toString();
        try {
            SimpleHttpClient.SimpleHttpResponse responseResult = SimpleHttpClient.sendRequest(url, PUT, fileBytes, headers, this.timeout);
            if (HttpStatus.CREATED.getCode() != responseResult.statusCode()) {
                errors.add("Error sends part " + responsePart.getOrdinalNumber() + ": " + responseResult.statusCode());
            }
        }
        catch (IOException e) {
            errors.add("Error sends part " + responsePart.getOrdinalNumber() + ": " + e.getMessage());
        }
    }

    @Override
    public byte[] downloadPackagePart(InvoicePackagePart part) {
        String url = part.getUrl().toString();
        try {
            SimpleHttpClient.SimpleHttpResponse response = SimpleHttpClient.sendRequest(url, GET, null, this.defaultHeaders, this.timeout);
            return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    private <T> T getResponse(SimpleHttpClient.SimpleHttpResponse response, HttpStatus expectedStatus, Url operation, Class<T> classType) throws ApiException {
        try {
            this.validResponse(response, expectedStatus, operation);
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : this.objectMapper.readValue(response.body(), classType))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private void validResponse(SimpleHttpClient.SimpleHttpResponse response, HttpStatus expectedStatus, Url operation) throws ApiException {
        try {
            if (!HttpUtils.isValidResponse(response, expectedStatus)) {
                ExceptionResponse exception = null;
                String contentType = "";
                if (response.headers() != null && response.headers().containsKey("Content-Type")) {
                    contentType = response.headers().get("Content-Type").toLowerCase();
                }
                if (contentType.contains("application/json")) {
                    exception = response.body() == null ? null : (ExceptionResponse)this.objectMapper.readValue(response.body(), ExceptionResponse.class);
                }
                String message = HttpUtils.formatExceptionMessage(operation.getOperationId(), response.statusCode(), response.body());
                throw new ApiException(response.statusCode(), message, response.headers(), exception);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private URI buildUri(String baseUrl, String suffix, String url) {
        URI urlWithSuffix = URI.create(baseUrl + "/").resolve(suffix);
        return URI.create(urlWithSuffix + "/").resolve(url);
    }
}

