/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.service.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.ImportUPOFromKSeFSummary;
import com.suncode.plugin.plusksef.scheduledtask.ImportUPOFromKSeFTaskParams;
import com.suncode.plugin.plusksef.scheduledtask.ScheduledTaskUtils;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;

@ScheduledTask
public class ImportUPOFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportUPOFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.ImportUPOFromKSeF";
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumberVariableId").name(ID.concat(".param.ksefReferenceNumberVariableId.name")).description(ID.concat(".param.ksefReferenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).create()).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("forceSessionClose").name(ID.concat(".param.forceSessionClose.name")).description(ID.concat(".param.forceSessionClose.desc")).type((Type)Types.BOOLEAN).create();
    }

    public String execute(@Param String configId, @Param String processDefId, @Param String activityDefId, @Param String ksefReferenceNumberVariableId, @Param String actionId, @Param String documentClassName, @Param Boolean forceSessionClose, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            ImportUPOFromKSeFSummary importUPOFromKSeFSummary = new ImportUPOFromKSeFSummary();
            importUPOFromKSeFSummary.setNumberOfDocumentsFound(activities.size());
            HashSet<String> processedActivityIds = new HashSet<String>();
            ArrayList<String> configIds = new ArrayList<String>();
            Arrays.stream(configId.split(",")).map(String::trim).filter(configIdPart -> !configIdPart.isEmpty()).distinct().forEach(singleConfigId -> {
                configIds.add((String)singleConfigId);
                ImportUPOFromKSeFTaskParams params = ImportUPOFromKSeFTaskParams.builder().configId((String)singleConfigId).processDefId(processDefId).activityDefId(activityDefId).ksefReferenceNumberVariableId(ksefReferenceNumberVariableId).actionId(actionId).documentClassName(documentClassName).forceSessionClose(forceSessionClose).logger(logger).activities(activities).summary(importUPOFromKSeFSummary).processedActivityIds(processedActivityIds).build();
                this.processTask(params);
            });
            ScheduledTaskUtils.logUnlinkedActivities(activities, processedActivityIds, configIds, logger);
            return importUPOFromKSeFSummary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void processTask(ImportUPOFromKSeFTaskParams params) {
        try {
            params.getLogger().debug((Object)("Processing configuration: " + params.getConfigId()));
            KsefImportConfig ksefConfig = this.configService.readConfigurationFromPCM(params.getConfigId());
            List<Activity> filteredActivities = this.filterActivitiesByConfig(params.getActivities(), params.getConfigId(), params.getKsefReferenceNumberVariableId(), params.getLogger());
            params.getLogger().debug((Object)("Found " + filteredActivities.size() + " activities for configuration " + params.getConfigId()));
            if (filteredActivities.isEmpty()) {
                params.getLogger().debug((Object)("No activities found for configuration: " + params.getConfigId()));
                return;
            }
            filteredActivities.forEach(activity -> params.getProcessedActivityIds().add(activity.getActivityId()));
            LinkedHashMap<String, byte[]> importedUPO = new LinkedHashMap<String, byte[]>();
            String accessToken = null;
            DefaultKsefClient ksefClient = null;
            for (Activity activity2 : filteredActivities) {
                try {
                    if (ksefConfig.getApiVersion() == KsefApiVersion.V2) {
                        if (accessToken == null) {
                            ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefConfig.getKsefUrl(), ksefConfig.getKsefSuffixUri(), ksefConfig.getKsefQrUri());
                            accessToken = this.kSeFServiceApiV2.getAuthTokens(ksefClient, ksefConfig).getAccessToken();
                        }
                        this.loadUPOAndUpdateActivityV2(ksefClient, accessToken, params, importedUPO, activity2);
                        continue;
                    }
                    this.loadUPOAndUpdateActivityV1(ksefConfig, params, importedUPO, activity2);
                }
                catch (Exception e) {
                    params.getSummary().increaseOmitted();
                    params.getLogger().error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error processing configuration " + params.getConfigId() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void loadUPOAndUpdateActivityV1(KsefImportConfig ksefImportConfig, ImportUPOFromKSeFTaskParams params, Map<String, byte[]> importedUPO, Activity activity) throws Exception {
        params.getLogger().debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
        params.getSummary().increaseProcessedDocuments();
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String ksefReferenceNumber = activityContext.get(params.getKsefReferenceNumberVariableId()).toString();
        ExportedDocumentTableEntity rowByReferenceNumber = this.exportedDocumentTableService.getRowByKsefReferenceNumber(ksefReferenceNumber);
        String referenceNumber = rowByReferenceNumber.getExportReferenceNumber();
        params.getLogger().debug((Object)String.format("Load UPO for referenceNumber: %s", referenceNumber));
        if (params.getForceSessionClose().booleanValue() && !importedUPO.containsKey(referenceNumber)) {
            this.closeSessionV1(params.getLogger(), ksefImportConfig.getKsefUrl(), rowByReferenceNumber.getSessionToken(), referenceNumber);
            params.getLogger().debug((Object)String.format("Close session: %s", referenceNumber));
        }
        if (!importedUPO.containsKey(referenceNumber)) {
            Optional<byte[]> upo = this.kSeFServiceApiV1.getUPO(ksefImportConfig.getKsefUrl(), referenceNumber);
            if (!upo.isPresent()) {
                params.getLogger().warn((Object)String.format("No UPO for: %s", referenceNumber));
                params.getSummary().increaseOmitted();
                return;
            }
            importedUPO.put(referenceNumber, upo.get());
        }
        this.addUPOAndAcceptActivity(params.getLogger(), params.getActionId(), activity, activityContext, params.getDocumentClassName(), importedUPO.get(referenceNumber), rowByReferenceNumber.getExportReferenceNumber());
        params.getSummary().increaseAcceptInvoiceProcess();
    }

    private void loadUPOAndUpdateActivityV2(KSeFClient ksefClient, String accessToken, ImportUPOFromKSeFTaskParams params, Map<String, byte[]> importedUPO, Activity activity) throws Exception {
        params.getLogger().debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
        params.getSummary().increaseProcessedDocuments();
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String ksefReferenceNumber = activityContext.get(params.getKsefReferenceNumberVariableId()).toString();
        ExportedDocumentTableEntity exportedDocument = this.exportedDocumentTableService.getRowByKsefReferenceNumber(ksefReferenceNumber);
        String sessionReferenceNumber = exportedDocument.getSessionReferenceNumber();
        params.getLogger().debug((Object)String.format("Load UPO for session referenceNumber: %s", sessionReferenceNumber));
        if (params.getForceSessionClose().booleanValue() && !importedUPO.containsKey(sessionReferenceNumber)) {
            this.closeSessionAndWaitingForUPOV2(params.getLogger(), ksefClient, sessionReferenceNumber, accessToken);
            params.getLogger().debug((Object)String.format("Close session: %s", sessionReferenceNumber));
        }
        byte[] upo = this.kSeFServiceApiV2.getUPO(ksefClient, sessionReferenceNumber, ksefReferenceNumber, accessToken);
        this.addUPOAndAcceptActivity(params.getLogger(), params.getActionId(), activity, activityContext, params.getDocumentClassName(), upo, exportedDocument.getExportReferenceNumber());
        params.getSummary().increaseAcceptInvoiceProcess();
    }

    private void addUPOAndAcceptActivity(org.apache.log4j.Logger logger, String actionId, Activity activity, Map<String, Object> activityContext, String documentClassName, byte[] upo, String referenceNumber) throws Exception {
        logger.debug((Object)String.format("UPO found. Accept activity: %s", activity.getActivityId()));
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, referenceNumber + ".xml", upo, null, true, true, activity.getActivityId(), activity.getProcessId(), null);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
    }

    private void closeSessionV1(org.apache.log4j.Logger logger, String ksefUrl, String sessionToken, String referenceNumber) {
        try {
            this.kSeFServiceApiV1.terminateSession(ksefUrl, sessionToken);
            this.kSeFServiceApiV1.waitingForUPOGenerated(ksefUrl, referenceNumber, 30);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void closeSessionAndWaitingForUPOV2(org.apache.log4j.Logger logger, KSeFClient ksefClient, String sessionReferenceNumber, String accessToken) {
        try {
            this.kSeFServiceApiV2.terminateSession(ksefClient, sessionReferenceNumber, accessToken);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.kSeFServiceApiV2.isUpoGenerated(ksefClient, sessionReferenceNumber, accessToken));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private List<Activity> filterActivitiesByConfig(List<Activity> activities, String configId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger) {
        return activities.stream().filter(activity -> {
            try {
                Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                Object ksefReferenceNumberObj = activityContext.get(ksefReferenceNumberVariableId);
                if (ksefReferenceNumberObj == null) {
                    logger.debug((Object)String.format("Activity %s does not have ksefReferenceNumber variable %s", activity.getActivityId(), ksefReferenceNumberVariableId));
                    return false;
                }
                String ksefReferenceNumber = ksefReferenceNumberObj.toString();
                return this.exportedDocumentTableService.isDocumentExportedByConfigByKsefNumber(ksefReferenceNumber, configId);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Error checking if activity %s was exported by config %s: %s", activity.getActivityId(), configId, e.getMessage()));
                return false;
            }
        }).collect(Collectors.toList());
    }
}

