/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.service;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.plusksef.document.dto.KSeFQrInformation;
import com.suncode.plugin.plusksef.document.dto.PdfGenerationResult;
import com.suncode.plugin.plusksef.document.enums.Language;
import com.suncode.plugin.plusksef.document.service.KSeFQrURLGenerator;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.plugin.plusksef.document.service.KsefPdfGeneratorService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.translation.Translators;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class KsefDocumentServiceImpl
implements KsefDocumentService {
    private static final Logger log = LoggerFactory.getLogger(KsefDocumentServiceImpl.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private FileService fileService;
    @Autowired
    private KsefPdfGeneratorService ksefPdfGeneratorService;
    @Autowired
    private KSeFQrURLGenerator kSeFQrURLGenerator;
    private static final Pattern KSEF_DOCUMENT_MARKER_PATTERN = Pattern.compile("<[^:>]*:?KodFormularza[^>]*kodSystemowy=[\"']FA", 2);
    private static final Pattern UPO_MARKER_PATTERN = Pattern.compile("<[^:>]*:?Potwierdzenie");
    private static final Pattern UPO_SHORT_MARKER_PATTERN = Pattern.compile("<[^:>]*:?UPO");

    @Override
    public PdfGenerationResult generatePdfFromKsefInvoiceXml(byte[] xmlDocumentBytes, WfFile wfFile, String pcmConfigurationId, boolean addQRCode, Language language) throws Exception {
        String nrKSeF = "";
        String verificationUrl = "";
        if (addQRCode) {
            try {
                KSeFQrInformation kSeFQrInformation = this.kSeFQrURLGenerator.buildInvoiceVerificationUrl(wfFile, xmlDocumentBytes, pcmConfigurationId);
                nrKSeF = StringUtils.isBlank((CharSequence)kSeFQrInformation.getKsefNumber()) ? Translators.get((String)this.plugin.getKey()).getMessage("plusksef.invoiceNumber.missing", Locale.forLanguageTag(language.getCode())) : kSeFQrInformation.getKsefNumber();
                verificationUrl = kSeFQrInformation.getUrl();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        ByteArrayOutputStream pdfOutputStream = this.ksefPdfGeneratorService.generatePdfFromXml(xmlDocumentBytes, nrKSeF, verificationUrl, "", language);
        return new PdfGenerationResult(pdfOutputStream, nrKSeF, verificationUrl, "");
    }

    @Override
    public PdfGenerationResult generatePdfFromOfflineInvoiceXml(byte[] xmlDocumentBytes, WfFile wfFile, String pcmConfigurationId, Language language) throws Exception {
        KSeFQrInformation kSeFQrInformation = this.kSeFQrURLGenerator.buildInvoiceVerificationUrl(wfFile, xmlDocumentBytes, pcmConfigurationId);
        String nrKSeF = Translators.get((String)this.plugin.getKey()).getMessage("plusksef.invoiceMode.offline", Locale.forLanguageTag(language.getCode()));
        String verificationUrl = kSeFQrInformation.getUrl();
        String certificateUrl = this.kSeFQrURLGenerator.buildCertificateVerificationUrl(wfFile, xmlDocumentBytes, pcmConfigurationId).getUrl();
        ByteArrayOutputStream pdfOutputStream = this.ksefPdfGeneratorService.generatePdfFromXml(xmlDocumentBytes, nrKSeF, verificationUrl, certificateUrl, language);
        return new PdfGenerationResult(pdfOutputStream, nrKSeF, verificationUrl, certificateUrl);
    }

    @Override
    public ByteArrayOutputStream generatePdfFromKsefUPOXml(byte[] xmlDocumentBytes) throws IOException, InterruptedException {
        return this.ksefPdfGeneratorService.generatePdfFromXml(xmlDocumentBytes);
    }

    @Override
    public short getSchemaVersion(byte[] xmlDocumentBytes) throws Exception {
        String xmlString = new String(xmlDocumentBytes, StandardCharsets.UTF_8);
        Document xmlDocument = this.secureParseXml(xmlString);
        return this.extractSchemaVersion(xmlDocument);
    }

    @Override
    public boolean isKsefInvoiceDocument(byte[] xmlDocumentBytes) {
        String documentString = new String(xmlDocumentBytes, StandardCharsets.UTF_8);
        return KSEF_DOCUMENT_MARKER_PATTERN.matcher(documentString).find();
    }

    @Override
    public boolean isKsefUpoDocument(byte[] xmlDocumentBytes) {
        String documentString = new String(xmlDocumentBytes, StandardCharsets.UTF_8);
        return UPO_MARKER_PATTERN.matcher(documentString).find() || UPO_SHORT_MARKER_PATTERN.matcher(documentString).find();
    }

    @Override
    public byte[] getDocumentBytes(long fileId) throws IOException {
        WfFile wfFile = this.fileService.getFile(Long.valueOf(fileId), new String[0]);
        return Files.readAllBytes(Paths.get(wfFile.getFullPath(), new String[0]));
    }

    private Document secureParseXml(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        xml = xml.trim();
        xml = this.removeBom(xml);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(new StringReader(xml)));
    }

    private String removeBom(String text) {
        if (text != null && text.startsWith("\ufeff")) {
            return text.substring(1);
        }
        return text;
    }

    private short extractSchemaVersion(Document document) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression expression = xpath.compile("//WariantFormularza/text()");
        String wariantStr = (String)expression.evaluate(document, XPathConstants.STRING);
        if (wariantStr != null && !wariantStr.trim().isEmpty()) {
            try {
                return Short.parseShort(wariantStr.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }
}

