/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.db.service;

import com.suncode.plugin.plusksef.db.dao.LastInvoiceQueryTimeTableDao;
import com.suncode.plugin.plusksef.db.entity.LastInvoiceQueryTimeTableEntity;
import com.suncode.plugin.plusksef.db.service.LastInvoiceQueryTimeService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LastInvoiceQueryTimeServiceImpl
extends EditableServiceImpl<LastInvoiceQueryTimeTableEntity, Long, LastInvoiceQueryTimeTableDao>
implements LastInvoiceQueryTimeService {
    private static final Logger log = LoggerFactory.getLogger(LastInvoiceQueryTimeServiceImpl.class);

    @Autowired
    public void setDao(LastInvoiceQueryTimeTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void addInfo(String nip, String configId, Timestamp queryTime, Timestamp lastInvoiceDate) {
        ((LastInvoiceQueryTimeTableDao)this.dao).save(this.createEntity(nip, configId, queryTime, lastInvoiceDate));
    }

    private LastInvoiceQueryTimeTableEntity createEntity(String nip, String systemType, Timestamp queryTime, Timestamp lastInvoiceDate) {
        return LastInvoiceQueryTimeTableEntity.builder().nip(nip).systemType(systemType).queryTime(queryTime).lastInvoiceDate(lastInvoiceDate).build();
    }

    @Override
    public Date getLastInvoiceDate(String nip, String systemType) {
        HibernateCriteria lastInvoiceQueryTimeCriteria = HibernateCriteria.forClass(LastInvoiceQueryTimeTableEntity.class).add(Restrictions.eq((String)"nip", (Object)nip)).add(Restrictions.eq((String)"systemType", (Object)systemType)).addOrder(Order.desc((String)"queryTime"));
        LastInvoiceQueryTimeTableEntity lastCallTime = (LastInvoiceQueryTimeTableEntity)((LastInvoiceQueryTimeTableDao)this.dao).findOne(lastInvoiceQueryTimeCriteria);
        if (lastCallTime == null) {
            return null;
        }
        Timestamp dateToReturn = lastCallTime.getLastInvoiceDate() != null ? lastCallTime.getLastInvoiceDate() : lastCallTime.getQueryTime();
        return new Date(dateToReturn.getTime());
    }
}

