/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaResourceResolver
implements LSResourceResolver {
    private static final Logger log = LoggerFactory.getLogger(SchemaResourceResolver.class);
    private final String fullSchemaPath;

    public SchemaResourceResolver(String fullSchemaPath) {
        this.fullSchemaPath = fullSchemaPath;
    }

    @Override
    public synchronized LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            Path schemaPath = Paths.get(this.fullSchemaPath, new String[0]);
            Path basePath = schemaPath.getParent();
            String resourcePath = basePath.resolve(systemId).toString();
            resourcePath = resourcePath.replace("\\", "/");
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            if (inputStream == null) {
                log.warn("Could not resolve schema resource: {} (tried path: {})", (Object)systemId, (Object)resourcePath);
                return null;
            }
            log.debug("Successfully resolved schema resource: {} -> {}", (Object)systemId, (Object)resourcePath);
            LSInputImpl input = new LSInputImpl();
            input.setByteStream(inputStream);
            input.setSystemId(systemId);
            input.setPublicId(publicId);
            input.setBaseURI(baseURI);
            return input;
        }
        catch (Exception e) {
            log.error("Error resolving schema resource: {}", (Object)systemId, (Object)e);
            return null;
        }
    }

    private static class LSInputImpl
    implements LSInput,
    AutoCloseable {
        private InputStream byteStream;
        private Reader characterStream;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String stringData;
        private String encoding;
        private boolean certifiedText;

        private LSInputImpl() {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void close() throws Exception {
            if (this.byteStream != null) {
                this.byteStream.close();
            }
            if (this.characterStream != null) {
                this.characterStream.close();
            }
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }
    }
}

