/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api.builders.certificate;

import java.time.OffsetDateTime;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateListItemStatus;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateType;
import pl.akmf.ksef.sdk.client.model.certificate.QueryCertificatesRequest;

public class CertificateMetadataListRequestBuilder {
    private String certificateSerialNumber;
    private String name;
    private CertificateType type;
    private CertificateListItemStatus status;
    private OffsetDateTime expiresAfter;

    public CertificateMetadataListRequestBuilder withCertificateSerialNumber(String certificateSerialNumber) {
        this.certificateSerialNumber = certificateSerialNumber;
        return this;
    }

    public CertificateMetadataListRequestBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public CertificateMetadataListRequestBuilder withType(CertificateType type) {
        this.type = type;
        return this;
    }

    public CertificateMetadataListRequestBuilder withStatus(CertificateListItemStatus status) {
        this.status = status;
        return this;
    }

    public CertificateMetadataListRequestBuilder withExpiresAfter(OffsetDateTime expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public QueryCertificatesRequest build() {
        QueryCertificatesRequest request = new QueryCertificatesRequest();
        request.setCertificateSerialNumber(this.certificateSerialNumber);
        request.setName(this.name);
        request.setType(this.type);
        request.setStatus(this.status);
        request.setExpiresAfter(this.expiresAfter);
        return request;
    }
}

