/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.service.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.scheduledtask.ScheduledTaskUtils;
import com.suncode.plugin.plusksef.scheduledtask.SendInvoicesToKSeFBatchSessionSummary;
import com.suncode.plugin.plusksef.scheduledtask.SendInvoicesToKSeFBatchSessionTaskParams;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.api.builders.batch.OpenBatchSessionRequestBuilder;
import pl.akmf.ksef.sdk.api.services.DefaultCryptographyService;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.session.EncryptionData;
import pl.akmf.ksef.sdk.client.model.session.FileMetadata;
import pl.akmf.ksef.sdk.client.model.session.SchemaVersion;
import pl.akmf.ksef.sdk.client.model.session.SessionValue;
import pl.akmf.ksef.sdk.client.model.session.SystemCode;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionResponse;
import pl.akmf.ksef.sdk.system.FilesUtil;

@ScheduledTask
public class SendInvoicesToKSeFBatchSession
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(SendInvoicesToKSeFBatchSession.class);
    private static final String ID = "plusksef.scheduledTask.SendInvoicesToKSeFBatchSession";
    private static final int MAX_INVOICES_PER_BATCH = 9000;
    private static final long MAX_PART_SIZE_BYTES = 100000000L;
    private static final int MAX_PART_COUNT = 50;
    private static final String WAITING_FOR_BATCH_STATUS = "Waiting for batch status";
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;
    @Autowired
    private FileService fileService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configIds").name(ID.concat(".param.configIds.name")).description(ID.concat(".param.configIds.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("referenceNumberVariableId").name(ID.concat(".param.referenceNumberVariableId.name")).description(ID.concat(".param.referenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("invoiceStatusVariableId").name(ID.concat(".param.invoiceStatusVariable.name")).description(ID.concat(".param.invoiceStatusVariable.desc")).type((Type)Types.STRING).optional().create()).parameter().id("attemptCount").name(ID.concat(".param.attemptCount.name")).description(ID.concat(".param.attemptCount.desc")).type((Type)Types.INTEGER).defaultValue((Object)1).create();
    }

    public String execute(@Param String configIds, @Param String processDefId, @Param String activityDefId, @Param String actionId, @Param String referenceNumberVariableId, @Param String invoiceStatusVariableId, @Param Integer attemptCount, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " open tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            SendInvoicesToKSeFBatchSessionSummary summary = new SendInvoicesToKSeFBatchSessionSummary();
            HashSet<String> processedActivityIds = new HashSet<String>();
            ArrayList<String> configIdList = new ArrayList<String>();
            Arrays.stream(configIds.split(",")).map(String::trim).filter(configId -> !configId.isEmpty()).distinct().forEach(singleConfigId -> {
                configIdList.add((String)singleConfigId);
                SendInvoicesToKSeFBatchSessionTaskParams params = SendInvoicesToKSeFBatchSessionTaskParams.builder().configId((String)singleConfigId).processDefId(processDefId).activityDefId(activityDefId).actionId(actionId).referenceNumberVariableId(referenceNumberVariableId).invoiceStatusVariableId(invoiceStatusVariableId).attemptCount(attemptCount != null ? attemptCount : 1).logger(logger).summary(summary).build();
                this.processTask(params, activities, processedActivityIds);
            });
            ScheduledTaskUtils.logUnlinkedActivities(activities, processedActivityIds, configIdList, logger);
            return summary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void processTask(SendInvoicesToKSeFBatchSessionTaskParams params, List<Activity> allActivities, Set<String> processedActivityIds) {
        try {
            params.getLogger().debug((Object)("Processing configuration: " + params.getConfigId()));
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(params.getConfigId());
            if (ksefImportConfig.getApiVersion() != KsefApiVersion.V2) {
                params.getLogger().warn((Object)("Batch session is only supported for KSeF API v2. Configuration: " + params.getConfigId()));
                return;
            }
            List<Activity> filteredActivities = this.filterActivitiesForBatchSubmission(allActivities, params.getConfigId(), params.getLogger());
            params.getLogger().debug((Object)("Found " + filteredActivities.size() + " activities ready for batch submission for configuration " + params.getConfigId()));
            if (filteredActivities.isEmpty()) {
                params.getLogger().debug((Object)("No activities ready for batch submission for configuration: " + params.getConfigId()));
                return;
            }
            filteredActivities.forEach(activity -> processedActivityIds.add(activity.getActivityId()));
            List<ExportedDocumentTableEntity> invoices = this.exportedDocumentTableService.findInvoicesReadyForBatchSubmission(params.getConfigId(), 9000);
            params.getLogger().debug((Object)("Found " + invoices.size() + " invoices ready for batch submission"));
            if (invoices.isEmpty()) {
                params.getLogger().debug((Object)("No invoices ready for batch submission for configuration: " + params.getConfigId()));
                return;
            }
            params.getSummary().increaseConfigsProcessed();
            this.processBatch(invoices, ksefImportConfig, params, processedActivityIds, filteredActivities);
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error processing configuration " + params.getConfigId() + ": " + e.getMessage()), (Throwable)e);
            params.getSummary().increaseErrors(1);
        }
    }

    private List<Activity> filterActivitiesForBatchSubmission(List<Activity> activities, String configId, org.apache.log4j.Logger logger) {
        return activities.stream().filter(activity -> {
            try {
                boolean found = this.exportedDocumentTableService.getLatestReadyForBatchSubmissionByProcessId(activity.getProcessId(), configId).isPresent();
                if (!found) {
                    logger.debug((Object)("No exported documents found for activity: " + activity.getActivityId()));
                }
                return found;
            }
            catch (Exception e) {
                logger.warn((Object)("Error filtering activity " + activity.getActivityId() + ": " + e.getMessage()));
                return false;
            }
        }).collect(Collectors.toList());
    }

    private void processBatch(List<ExportedDocumentTableEntity> invoices, KsefImportConfig ksefImportConfig, SendInvoicesToKSeFBatchSessionTaskParams params, Set<String> processedActivityIds, List<Activity> activitiesToProcessed) {
        try {
            params.getLogger().debug((Object)("Processing batch with " + invoices.size() + " invoices"));
            Map<String, byte[]> invoiceFiles = this.loadInvoiceFiles(invoices, params);
            byte[] zipBytes = FilesUtil.createZip(invoiceFiles);
            DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefImportConfig.getKsefUrl(), ksefImportConfig.getKsefSuffixUri(), ksefImportConfig.getKsefQrUri());
            DefaultCryptographyService cryptographyService = new DefaultCryptographyService(ksefClient);
            EncryptionData encryptionData = cryptographyService.getEncryptionData();
            List<BatchPartSendingInfo> encryptedParts = this.prepareEncryptedParts(zipBytes, cryptographyService, encryptionData, params);
            if (encryptedParts == null) {
                this.incrementSendAttemptCountForInvoices(invoices, params, activitiesToProcessed, "Error preparing encrypted parts");
                return;
            }
            FileMetadata zipMetadata = cryptographyService.getMetaData(zipBytes);
            OpenBatchSessionRequest batchRequest = this.buildBatchSessionRequest(encryptedParts, zipMetadata, encryptionData);
            String accessToken = this.getAccessToken(ksefClient, ksefImportConfig, params);
            if (accessToken == null) {
                this.incrementSendAttemptCountForInvoices(invoices, params, activitiesToProcessed, "Error getting access token");
                return;
            }
            String sessionReferenceNumber = this.openAndSendBatchSession(batchRequest, encryptedParts, ksefClient, accessToken, ksefImportConfig, params);
            Set<String> currentProcessedActivityIds = this.updateInvoicesOnSuccess(invoices, sessionReferenceNumber, accessToken, params, activitiesToProcessed);
            processedActivityIds.addAll(currentProcessedActivityIds);
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error processing batch: " + e.getMessage()), (Throwable)e);
            this.incrementSendAttemptCountForInvoices(invoices, params, activitiesToProcessed, "Error processing batch: " + e.getMessage());
            params.getSummary().increaseErrors(invoices.size());
        }
    }

    private Map<String, byte[]> loadInvoiceFiles(List<ExportedDocumentTableEntity> invoices, SendInvoicesToKSeFBatchSessionTaskParams params) throws IOException {
        HashMap<String, byte[]> invoiceFiles = new HashMap<String, byte[]>();
        for (ExportedDocumentTableEntity invoice : invoices) {
            String filePath = this.fileService.getFile(Long.valueOf(invoice.getFileId()), new String[0]).getFullPath();
            byte[] invoiceContent = Files.readAllBytes(Paths.get(filePath, new String[0]));
            String fileName = "fileId_" + invoice.getFileId() + ".xml";
            this.exportedDocumentTableService.updateExportedFileNameForEntity(invoice, fileName);
            invoiceFiles.put(fileName, invoiceContent);
        }
        params.getLogger().debug((Object)("Loaded " + invoices.size() + " invoice files"));
        return invoiceFiles;
    }

    private List<BatchPartSendingInfo> prepareEncryptedParts(byte[] zipBytes, DefaultCryptographyService cryptographyService, EncryptionData encryptionData, SendInvoicesToKSeFBatchSessionTaskParams params) {
        try {
            int partsCount = this.calculatePartsCount(zipBytes.length);
            List<byte[]> zipParts = FilesUtil.splitZip(partsCount, zipBytes);
            params.getLogger().debug((Object)("Split ZIP into " + zipParts.size() + " parts"));
            ArrayList<BatchPartSendingInfo> encryptedParts = new ArrayList<BatchPartSendingInfo>();
            for (int i = 0; i < zipParts.size(); ++i) {
                byte[] encryptedPart = cryptographyService.encryptBytesWithAES256(zipParts.get(i), encryptionData.cipherKey(), encryptionData.cipherIv());
                FileMetadata partMetadata = cryptographyService.getMetaData(encryptedPart);
                encryptedParts.add(new BatchPartSendingInfo(encryptedPart, partMetadata, i + 1));
            }
            return encryptedParts;
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error preparing encrypted parts: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private OpenBatchSessionRequest buildBatchSessionRequest(List<BatchPartSendingInfo> encryptedParts, FileMetadata zipMetadata, EncryptionData encryptionData) {
        OpenBatchSessionRequestBuilder requestBuilder = OpenBatchSessionRequestBuilder.create().withFormCode(SystemCode.FA_3, SchemaVersion.VERSION_1_0E, SessionValue.FA).withOfflineMode(false).withBatchFile(zipMetadata.getFileSize(), zipMetadata.getHashSHA());
        for (BatchPartSendingInfo part : encryptedParts) {
            requestBuilder = requestBuilder.addBatchFilePart(part.getOrdinalNumber(), part.getMetadata().getFileSize(), part.getMetadata().getHashSHA());
        }
        return requestBuilder.endBatchFile().withEncryption(encryptionData.encryptionInfo().getEncryptedSymmetricKey(), encryptionData.encryptionInfo().getInitializationVector()).build();
    }

    private String openAndSendBatchSession(OpenBatchSessionRequest batchRequest, List<BatchPartSendingInfo> encryptedParts, KSeFClient ksefClient, String accessToken, KsefImportConfig ksefImportConfig, SendInvoicesToKSeFBatchSessionTaskParams params) {
        OpenBatchSessionResponse batchResponse = this.openBatchSession(ksefClient, ksefImportConfig, batchRequest, params);
        Assert.notNull((Object)batchResponse, (String)"OpenBatchSessionResponse is NULL");
        String sessionReferenceNumber = batchResponse.getReferenceNumber();
        params.getLogger().debug((Object)("Opened batch session: " + sessionReferenceNumber));
        this.sendBatchParts(ksefClient, batchResponse, encryptedParts, params);
        this.closeBatchSession(ksefClient, sessionReferenceNumber, accessToken, params);
        return sessionReferenceNumber;
    }

    private String getAccessToken(KSeFClient ksefClient, KsefImportConfig ksefImportConfig, SendInvoicesToKSeFBatchSessionTaskParams params) {
        try {
            return this.kSeFServiceApiV2.getAuthTokens(ksefClient, ksefImportConfig).getAccessToken();
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error getting access token: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private OpenBatchSessionResponse openBatchSession(KSeFClient ksefClient, KsefImportConfig ksefImportConfig, OpenBatchSessionRequest batchRequest, SendInvoicesToKSeFBatchSessionTaskParams params) {
        try {
            return this.kSeFServiceApiV2.openBatchSession(ksefClient, ksefImportConfig, batchRequest);
        }
        catch (ApiException e) {
            params.getLogger().error((Object)("Error opening batch session: " + e.getMessage()), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Unexpected error opening batch session: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void sendBatchParts(KSeFClient ksefClient, OpenBatchSessionResponse batchResponse, List<BatchPartSendingInfo> encryptedParts, SendInvoicesToKSeFBatchSessionTaskParams params) {
        try {
            this.kSeFServiceApiV2.sendBatchParts(ksefClient, batchResponse, encryptedParts);
            params.getLogger().debug((Object)"Successfully sent batch parts");
        }
        catch (ApiException e) {
            params.getLogger().error((Object)("Error sending batch parts: " + e.getMessage()), (Throwable)e);
        }
    }

    private void closeBatchSession(KSeFClient ksefClient, String sessionReferenceNumber, String accessToken, SendInvoicesToKSeFBatchSessionTaskParams params) {
        try {
            this.kSeFServiceApiV2.closeBatchSession(ksefClient, sessionReferenceNumber, accessToken);
            params.getLogger().debug((Object)"Successfully closed batch session");
        }
        catch (ApiException e) {
            params.getLogger().error((Object)("Error closing batch session: " + e.getMessage()), (Throwable)e);
        }
    }

    private Set<String> updateInvoicesOnSuccess(List<ExportedDocumentTableEntity> invoices, String sessionReferenceNumber, String accessToken, SendInvoicesToKSeFBatchSessionTaskParams params, List<Activity> activitiesToProcessed) {
        HashSet<String> processedActivityIds = new HashSet<String>();
        for (ExportedDocumentTableEntity invoice : invoices) {
            this.exportedDocumentTableService.updateBatchSessionInfoForEntity(invoice, sessionReferenceNumber, accessToken, WAITING_FOR_BATCH_STATUS, null);
        }
        Map<String, Activity> activityMap = this.createActivityMap(activitiesToProcessed);
        for (ExportedDocumentTableEntity invoice : invoices) {
            try {
                Activity activity = activityMap.get(invoice.getProcessId());
                if (activity == null) continue;
                Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                activityContext.put(params.getReferenceNumberVariableId(), sessionReferenceNumber);
                if (StringUtils.isNotBlank((CharSequence)params.getInvoiceStatusVariableId())) {
                    activityContext.put(params.getInvoiceStatusVariableId(), "OK");
                }
                processedActivityIds.add(activity.getActivityId());
                if (StringUtils.isNotBlank((CharSequence)params.getActionId())) {
                    this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, params.getActionId());
                    params.getSummary().increaseInvoicesAccepted(1);
                    continue;
                }
                this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), activityContext);
            }
            catch (Exception e) {
                params.getLogger().error((Object)("Error updating activity for invoice: " + e.getMessage()), (Throwable)e);
            }
        }
        params.getSummary().increaseBatchesSent();
        params.getSummary().increaseInvoicesProcessed(invoices.size());
        return processedActivityIds;
    }

    private void incrementSendAttemptCountForInvoices(List<ExportedDocumentTableEntity> invoices, SendInvoicesToKSeFBatchSessionTaskParams params, List<Activity> activitiesToProcessed, String errorMessage) {
        Map<String, Activity> activityMap = this.createActivityMap(activitiesToProcessed);
        for (ExportedDocumentTableEntity invoice : invoices) {
            this.exportedDocumentTableService.incrementSendAttemptCountForEntity(invoice, errorMessage);
            int currentAttemptCount = this.exportedDocumentTableService.getSendAttemptCountForEntity(invoice);
            if (currentAttemptCount <= params.getAttemptCount()) continue;
            try {
                Activity activity = activityMap.get(invoice.getProcessId());
                if (activity == null || !StringUtils.isNotBlank((CharSequence)params.getInvoiceStatusVariableId())) continue;
                Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                activityContext.put(params.getInvoiceStatusVariableId(), errorMessage);
                if (StringUtils.isNotBlank((CharSequence)params.getActionId())) {
                    this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, params.getActionId());
                    params.getSummary().increaseInvoicesAccepted(1);
                } else {
                    this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), activityContext);
                }
                params.getLogger().warn((Object)("Maximum number of send attempts exceeded for invoice with processId: " + invoice.getProcessId() + ". Attempt count: " + currentAttemptCount + ". Error: " + errorMessage));
            }
            catch (Exception e) {
                params.getLogger().error((Object)("Error accepting activity after exceeding attempt limit for invoice: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private int calculatePartsCount(long zipSize) {
        int partsCount = (int)Math.ceil((double)zipSize / 1.0E8);
        return Math.min(partsCount, 50);
    }

    private Map<String, Activity> createActivityMap(List<Activity> activities) {
        return activities.stream().collect(Collectors.toMap(Activity::getProcessId, activity -> activity, (existing, replacement) -> existing));
    }
}

