/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.suncode.pwfl.workflow.activity.Activity;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public final class ScheduledTaskUtils {
    public static final String CONFIG_ID_SEPARATOR = ",";

    public static void logUnlinkedActivities(List<Activity> allActivities, Set<String> processedActivityIds, List<String> configIds, Logger logger) {
        List unlinkedActivities = allActivities.stream().filter(activity -> !processedActivityIds.contains(activity.getActivityId())).collect(Collectors.toList());
        if (!unlinkedActivities.isEmpty()) {
            logger.warn((Object)String.format("Found %d activity/activities not linked to any pcm_config_id. Checked configurations: %s", unlinkedActivities.size(), configIds));
            for (Activity unlinkedActivity : unlinkedActivities) {
                logger.warn((Object)String.format("Activity ID: %s, Process ID: %s was not exported by any of the provided configurations", unlinkedActivity.getActivityId(), unlinkedActivity.getProcessId()));
            }
        }
    }

    private ScheduledTaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

