/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.enums;

import com.suncode.plugin.plusksef.document.dto.KSeFQrInformation;
import com.suncode.plugin.plusksef.document.service.KSeFQrURLGenerator;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeys;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3;
import com.suncode.plugin.plusksef.invoice.util.converter.TypeConverter;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.stream.Stream;

public enum KsefCustomKeysV3 implements KsefKeys
{
    FA_P_14("Fa.P_14", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV3 faktura, Long fileId, KSeFQrURLGenerator kSeFQrURLGenerator) {
            BigDecimal sum = Stream.of(faktura.getFa().getP141(), faktura.getFa().getP142(), faktura.getFa().getP143(), faktura.getFa().getP144(), faktura.getFa().getP145()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            return TypeConverter.toFloat(sum);
        }
    }
    ,
    FA_P_13("Fa.P_13", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV3 faktura, Long fileId, KSeFQrURLGenerator kSeFQrURLGenerator) {
            BigDecimal sum = Stream.of(faktura.getFa().getP131(), faktura.getFa().getP132(), faktura.getFa().getP133(), faktura.getFa().getP134(), faktura.getFa().getP135(), faktura.getFa().getP1361(), faktura.getFa().getP1362(), faktura.getFa().getP1363(), faktura.getFa().getP137(), faktura.getFa().getP138(), faktura.getFa().getP139(), faktura.getFa().getP1310(), faktura.getFa().getP1311()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            return TypeConverter.toFloat(sum);
        }
    }
    ,
    QR_CODE_1("KodQR_1", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV3 faktura, Long fileId, KSeFQrURLGenerator kSeFQrURLGenerator) throws Exception {
            KSeFQrInformation kSeFQrInformation = kSeFQrURLGenerator.buildInvoiceVerificationUrl(fileId);
            return kSeFQrInformation.getUrl();
        }
    };

    private final String key;
    private final Type<?> type;
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-ksef");

    private KsefCustomKeysV3(String key, Type<?> type) {
        this.key = key;
        this.type = type;
    }

    public static Stream<KsefCustomKeysV3> stream() {
        return Stream.of(KsefCustomKeysV3.values());
    }

    public abstract Object getValue(FakturaV3 var1, Long var2, KSeFQrURLGenerator var3) throws Exception;

    @Override
    public boolean isPossibleToSet() {
        return false;
    }

    @Override
    public String getDesc() {
        return this.t.getMessage("plusksef.v3.autotask.CustomKeys.desc." + this.key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }
}

