/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.db.service;

import com.suncode.plugin.plusksef.api.enums.InvoiceSendMethod;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.db.dao.ExportedDocumentTableDao;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.service.ExportedDocumentTableService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ExportedDocumentTableServiceImpl
extends EditableServiceImpl<ExportedDocumentTableEntity, Long, ExportedDocumentTableDao>
implements ExportedDocumentTableService {
    private static final Logger log = LoggerFactory.getLogger(ExportedDocumentTableServiceImpl.class);

    @Autowired
    public void setDao(ExportedDocumentTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void addInfo(KsefImportConfig ksefImportConfig, long fileId, String exportReferenceNumber, String sessionReferenceNumber, String activityId, String processId, String sessionToken, String status, Timestamp exportTime, InvoiceSendMethod sendMethod, Timestamp batchPlannedSendDate) {
        ((ExportedDocumentTableDao)this.dao).save(this.createEntity(fileId, ksefImportConfig.getNip(), ksefImportConfig.getConfigId(), ksefImportConfig.getKsefSystemType(), exportReferenceNumber, sessionReferenceNumber, activityId, processId, sessionToken, status, exportTime, sendMethod, batchPlannedSendDate));
    }

    @Override
    public ExportedDocumentTableEntity getRowByExportReferenceNumber(String exportReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"exportReferenceNumber", (Object)exportReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect exportReferenceNumber. Record not found in DB: " + exportReferenceNumber);
    }

    @Override
    public ExportedDocumentTableEntity getRowBySessionReferenceNumberAndProcessId(String sessionReferenceNumber, String processId) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"sessionReferenceNumber", (Object)sessionReferenceNumber)).add(Restrictions.eq((String)"processId", (Object)processId));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect sessionReferenceNumber or processId. Record not found in DB: " + sessionReferenceNumber + ", " + processId);
    }

    @Override
    public ExportedDocumentTableEntity getRowByKsefReferenceNumber(String ksefReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"ksefReferenceNumber", (Object)ksefReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect ksefReferenceNumber. Record not found in DB: " + ksefReferenceNumber);
    }

    @Override
    public Optional<ExportedDocumentTableEntity> getEntity(Long fileId) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"fileId", (Object)fileId));
        return ((ExportedDocumentTableDao)this.dao).findByCriteria(exportedDocument).stream().findFirst();
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status) {
        this.updateRecord(exportReferenceNumber, status, null, null);
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status, String ksefReferenceNumber) {
        this.updateRecord(exportReferenceNumber, status, ksefReferenceNumber, null);
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status, String ksefReferenceNumber, Integer attemptCount) {
        ExportedDocumentTableEntity entity = this.getRowByExportReferenceNumber(exportReferenceNumber);
        entity.setStatus(status);
        if (ksefReferenceNumber != null) {
            entity.setKsefReferenceNumber(ksefReferenceNumber);
        }
        if (attemptCount != null) {
            entity.setStatusAttemptCount(attemptCount);
        }
    }

    @Override
    public void updateRecordForEntity(ExportedDocumentTableEntity entity, String status) {
        this.updateRecordForEntity(entity, status, null, null, null, null, null, null, null);
    }

    @Override
    public void updateRecordForEntity(ExportedDocumentTableEntity entity, String status, String referenceNumber, String ksefReferenceNumber, String invoicingHash, Timestamp invoicingDate, String upoDownloadUrl, String invoicingMode, Integer attemptCount) {
        this.getManagedEntityById(entity.getId()).ifPresent(managedEntity -> {
            managedEntity.setStatus(status);
            if (referenceNumber != null) {
                managedEntity.setExportReferenceNumber(referenceNumber);
            }
            if (ksefReferenceNumber != null) {
                managedEntity.setKsefReferenceNumber(ksefReferenceNumber);
            }
            if (invoicingHash != null) {
                managedEntity.setInvoicingHash(invoicingHash);
            }
            if (invoicingDate != null) {
                managedEntity.setInvoicingDate(invoicingDate);
            }
            if (upoDownloadUrl != null) {
                managedEntity.setUpoDownloadUrl(upoDownloadUrl);
            }
            if (invoicingMode != null) {
                managedEntity.setInvoicingMode(invoicingMode);
            }
            if (attemptCount != null) {
                managedEntity.setStatusAttemptCount(attemptCount);
            }
        });
    }

    @Override
    public List<ExportedDocumentTableEntity> findInvoicesReadyForBatchSubmission(String configId, int limit) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"configId", (Object)configId)).add(Restrictions.eq((String)"sendMethod", (Object)((Object)InvoiceSendMethod.BATCH_SESSION))).add(Restrictions.eq((String)"status", (Object)"Pending KSeF Batch Submission.")).addOrder(Order.asc((String)"exportTime"));
        List allResults = ((ExportedDocumentTableDao)this.dao).findByCriteria(criteria);
        return allResults.stream().filter(entity -> entity.getBatchPlannedSendDate() == null || entity.getBatchPlannedSendDate().getTime() <= now.getTime()).limit(limit).collect(Collectors.toList());
    }

    @Override
    public Optional<ExportedDocumentTableEntity> getLatestReadyForBatchSubmissionByProcessId(String processId, String configId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"processId", (Object)processId)).add(Restrictions.eq((String)"configId", (Object)configId)).add(Restrictions.eq((String)"sendMethod", (Object)((Object)InvoiceSendMethod.BATCH_SESSION))).add(Restrictions.eq((String)"status", (Object)"Pending KSeF Batch Submission.")).addOrder(Order.desc((String)"id"));
        List results = ((ExportedDocumentTableDao)this.dao).findByCriteria(criteria);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return results.stream().filter(entity -> entity.getBatchPlannedSendDate() == null || entity.getBatchPlannedSendDate().getTime() <= now.getTime()).findFirst();
    }

    @Override
    public void updateBatchSessionInfoForEntity(ExportedDocumentTableEntity entity, String sessionReferenceNumber, String accessToken, String status, String errorMessage) {
        this.getManagedEntityById(entity.getId()).ifPresent(managedEntity -> {
            managedEntity.setSessionReferenceNumber(sessionReferenceNumber);
            managedEntity.setSessionToken(accessToken);
            managedEntity.setStatus(status);
            managedEntity.setSendAttemptCount(managedEntity.getSendAttemptCount() + 1);
            managedEntity.setErrorMessage(errorMessage);
        });
    }

    @Override
    public void incrementSendAttemptCountForEntity(ExportedDocumentTableEntity entity, String errorMessage) {
        this.getManagedEntityById(entity.getId()).ifPresent(managedEntity -> {
            managedEntity.setSendAttemptCount(managedEntity.getSendAttemptCount() + 1);
            managedEntity.setErrorMessage(errorMessage);
        });
    }

    @Override
    public int incrementStatusAttemptCountForEntity(ExportedDocumentTableEntity entity, String errorMessage) {
        return this.getManagedEntityById(entity.getId()).map(managedEntity -> {
            int newAttemptCount = managedEntity.getStatusAttemptCount() + 1;
            managedEntity.setStatusAttemptCount(newAttemptCount);
            managedEntity.setErrorMessage(errorMessage);
            return newAttemptCount;
        }).orElse(0);
    }

    @Override
    public int getSendAttemptCountForEntity(ExportedDocumentTableEntity entity) {
        return this.getManagedEntityById(entity.getId()).map(ExportedDocumentTableEntity::getSendAttemptCount).orElse(0);
    }

    @Override
    public boolean isDocumentExportedByConfigByKsefNumber(String ksefReferenceNumber, String configId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"ksefReferenceNumber", (Object)ksefReferenceNumber)).add(Restrictions.eq((String)"configId", (Object)configId));
        List results = ((ExportedDocumentTableDao)this.dao).findByCriteria(criteria);
        return !results.isEmpty();
    }

    @Override
    public void updateExportedFileNameForEntity(ExportedDocumentTableEntity entity, String exportedFileName) {
        this.getManagedEntityById(entity.getId()).ifPresent(managedEntity -> managedEntity.setExportedFileName(exportedFileName));
    }

    private ExportedDocumentTableEntity createEntity(long fileId, String nip, String configId, String ksefSystemType, String exportReferenceNumber, String sessionReferenceNumber, String activityId, String processId, String sessionToken, String status, Timestamp exportTime, InvoiceSendMethod sendMethod, Timestamp batchPlannedSendDate) {
        return ExportedDocumentTableEntity.builder().exportTime(exportTime).fileId(fileId).nip(nip).configId(configId).systemType(ksefSystemType).exportReferenceNumber(exportReferenceNumber).sessionReferenceNumber(sessionReferenceNumber).status(status).activityId(activityId).processId(processId).sessionToken(sessionToken).sendMethod(sendMethod).batchPlannedSendDate(batchPlannedSendDate).build();
    }

    private ExportedDocumentTableEntity getFirstRowByCriteria(HibernateCriteria<ExportedDocumentTableEntity> detachedCriteria, String exceptionMessage) {
        List byCriteria = ((ExportedDocumentTableDao)this.dao).findByCriteria(detachedCriteria);
        return (ExportedDocumentTableEntity)byCriteria.stream().findFirst().orElseThrow(() -> new IllegalArgumentException(exceptionMessage));
    }

    private Optional<ExportedDocumentTableEntity> getManagedEntityById(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"id", (Object)id));
        return ((ExportedDocumentTableDao)this.dao).findByCriteria(criteria).stream().findFirst();
    }
}

