/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.v1.model.payment.GetPaymentIdentifiersByKSeFNumberResponse;
import com.suncode.plugin.plusksef.api.v1.model.payment.PaymentIdentifierType;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.PaymentService;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GetPaymentIdentifiersForInvoice/pwe_dynamic_form.js")
public class GetPaymentIdentifiersForInvoice {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentIdentifiersForInvoice.class);
    private static final String ID = "plusksef.autotask.getPaymentIdentifiersForInvoice";
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KSeFServiceApiV1 ksEFService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.MONEY)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumber").name(ID.concat(".param.ksefReferenceNumber.name")).description(ID.concat(".param.ksefReferenceNumber.desc")).type((Type)Types.STRING).create()).parameter().id("pageSize").name(ID.concat(".param.pageSize.name")).description(ID.concat(".param.pageSize.desc")).type((Type)Types.INTEGER).optional().defaultValue((Object)100).create()).parameter().id("pageOffset").name(ID.concat(".param.pageOffset.name")).description(ID.concat(".param.pageOffset.desc")).type((Type)Types.INTEGER).optional().defaultValue((Object)0).create()).parameter().id("paymentIdentifiersList").name(ID.concat(".param.paymentIdentifiersList.name")).description(ID.concat(".param.paymentIdentifiersList.desc")).type((Type)Types.VARIABLE).create()).parameter().id("paymentIdentifiersDates").name(ID.concat(".param.paymentIdentifiersDates.name")).description(ID.concat(".param.paymentIdentifiersDates.desc")).type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param String configId, @Param String ksefReferenceNumber, @Param Integer pageSize, @Param Integer pageOffset, @Param Variable paymentIdentifiersList, @Param Variable paymentIdentifiersDates) throws AcceptanceException {
        try {
            log.info("Getting payment identifiers for invoice: {} from config: {}", (Object)ksefReferenceNumber, (Object)configId);
            Assert.isTrue((configId != null && !configId.trim().isEmpty() ? 1 : 0) != 0, (String)"Configuration ID is required");
            Assert.isTrue((ksefReferenceNumber != null && !ksefReferenceNumber.trim().isEmpty() ? 1 : 0) != 0, (String)"KSeF reference number is required");
            Assert.isTrue((paymentIdentifiersList != null ? 1 : 0) != 0, (String)"Payment identifiers list variable is required");
            Assert.isTrue((paymentIdentifiersDates != null ? 1 : 0) != 0, (String)"Payment identifiers dates variable is required");
            int pageSizeValue = pageSize != null ? pageSize : 100;
            int pageOffsetValue = pageOffset != null ? pageOffset : 0;
            Assert.isTrue((pageSizeValue >= 10 && pageSizeValue <= 100 ? 1 : 0) != 0, (String)"Page size must be between 10 and 100");
            log.info("Retrieving payment identifiers for invoice: {} with page size: {}, offset: {}", new Object[]{ksefReferenceNumber, pageSizeValue, pageOffsetValue});
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            SessionInfo sessionInfo = this.ksEFService.getSession(ksefImportConfig);
            GetPaymentIdentifiersByKSeFNumberResponse response = this.paymentService.getPaymentIdentifiersForInvoice(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), ksefReferenceNumber, pageSizeValue, pageOffsetValue);
            List<PaymentIdentifierType> paymentIdentifiers = response.getPaymentIdentifiersList();
            long totalElementsCount = response.getNumberOfElements();
            log.info("Retrieved {} payment identifiers for invoice: {} (total: {})", new Object[]{paymentIdentifiers.size(), ksefReferenceNumber, totalElementsCount});
            String[] paymentIdentifiersArray = (String[])paymentIdentifiers.stream().map(PaymentIdentifierType::getPaymentIdentifier).toArray(String[]::new);
            log.info("Payment identifiers array: {}", (Object)paymentIdentifiersArray);
            paymentIdentifiersList.setValue((Object)paymentIdentifiersArray);
            String[] paymentIdentifiersDatesArray = (String[])paymentIdentifiers.stream().map(PaymentIdentifierType::getCreatedAt).toArray(String[]::new);
            log.info("Payment identifiers dates array: {}", (Object)paymentIdentifiersDatesArray);
            paymentIdentifiersDates.setValue((Object)paymentIdentifiersDatesArray);
        }
        catch (Exception e) {
            log.error("Error getting payment identifiers for invoice: {} from config: {}", new Object[]{ksefReferenceNumber, configId, e});
            throw new AcceptanceException("Error retrieving payment identifiers: " + e.getMessage());
        }
    }
}

