/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.document.dto.PdfGenerationResult;
import com.suncode.plugin.plusksef.document.enums.Language;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.variable.Variable;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GenerateKsefDocumentPreview/pwe_dynamic_form.js")
public class GenerateKsefDocumentPreview {
    private static final String ID = "plusksef.autotask.GenerateKsefDocumentPreview";
    private static final String ONLINE = "ONLINE";
    @Autowired
    private FileService fileService;
    @Autowired
    private KsefDocumentService ksefDocumentService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.SETTINGS)).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("targetFormat").name(ID.concat(".param.targetFormat.name")).description(ID.concat(".param.targetFormat.desc")).type((Type)Types.STRING).defaultValue((Object)"PDF").create()).parameter().id("addQrCode").name(ID.concat(".param.addQrCode.name")).description(ID.concat(".param.addQrCode.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("addDocumentToProcess").name(ID.concat(".param.addDocumentToProcess.name")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("saveAsNewVersion").name(ID.concat(".param.saveAsNewVersion.name")).description(ID.concat(".param.saveAsNewVersion.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("executeDocumentAction").name(ID.concat(".param.executeDocumentAction.name")).description(ID.concat(".param.executeDocumentAction.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("variableToSaveFileId").name(ID.concat(".param.variableToSaveFileId.name")).description(ID.concat(".param.variableToSaveFileId.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("invoiceMode").name(ID.concat(".param.invoiceMode.name")).description(ID.concat(".param.invoiceMode.desc")).type((Type)Types.STRING).defaultValue((Object)ONLINE).create()).parameter().id("pcmConfigId").name(ID.concat(".param.pcmConfigId.name")).description(ID.concat(".param.pcmConfigId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("language").name(ID.concat(".param.language.name")).description(ID.concat(".param.language.desc")).type((Type)Types.STRING).defaultValue((Object)"PL").create()).parameter().id("variableToSaveKsefNumber").name(ID.concat(".param.variableToSaveKsefNumber.name")).description(ID.concat(".param.variableToSaveKsefNumber.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("variableToSaveVerificationUrl").name(ID.concat(".param.variableToSaveVerificationUrl.name")).description(ID.concat(".param.variableToSaveVerificationUrl.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("variableToSaveCertificateUrl").name(ID.concat(".param.variableToSaveCertificateUrl.name")).description(ID.concat(".param.variableToSaveCertificateUrl.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("fileName").name(ID.concat(".param.fileName.name")).description(ID.concat(".param.fileName.desc")).type((Type)Types.STRING).optional().create();
    }

    public void execute(@Param Integer fileId, @Param String documentClassName, @Param Boolean addQrCode, @Param Boolean addDocumentToProcess, @Param Boolean saveAsNewVersion, @Param Variable variableToSaveFileId, @Param Boolean executeDocumentAction, @Param String invoiceMode, @Param String pcmConfigId, @Param String language, @Param Variable variableToSaveKsefNumber, @Param Variable variableToSaveVerificationUrl, @Param Variable variableToSaveCertificateUrl, @Param String fileName, WorkflowContext context) throws Exception {
        WfFile wfFile = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]);
        byte[] xmlDocumentBytes = Files.readAllBytes(Paths.get(wfFile.getFullPath(), new String[0]));
        Assert.isTrue((boolean)this.ksefDocumentService.isKsefInvoiceDocument(xmlDocumentBytes), (String)"The indicated xml file is not a ksef invoice.");
        Language languageEnum = this.validateAndGetLanguage(language);
        PdfGenerationResult pdfGenerationResult = invoiceMode.equals(ONLINE) || !Boolean.TRUE.equals(addQrCode) ? this.ksefDocumentService.generatePdfFromKsefInvoiceXml(xmlDocumentBytes, wfFile, addQrCode, languageEnum) : this.ksefDocumentService.generatePdfFromOfflineInvoiceXml(xmlDocumentBytes, wfFile, pcmConfigId, languageEnum);
        String newFileName = this.createFileName(fileName, wfFile);
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, newFileName, pdfGenerationResult.getPdfOutputStream().toByteArray(), null, (boolean)saveAsNewVersion, (boolean)addDocumentToProcess, context.getActivityId(), context.getProcessId(), null);
        if (Boolean.TRUE.equals(executeDocumentAction)) {
            this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS);
        }
        GenerateKsefDocumentPreview.setOutputVariables(variableToSaveFileId, variableToSaveKsefNumber, variableToSaveVerificationUrl, variableToSaveCertificateUrl, wfDocument, pdfGenerationResult);
    }

    private static void setOutputVariables(Variable variableToSaveFileId, Variable variableToSaveKsefNumber, Variable variableToSaveVerificationUrl, Variable variableToSaveCertificateUrl, WfDocument wfDocument, PdfGenerationResult pdfGenerationResult) {
        if (variableToSaveFileId != null) {
            variableToSaveFileId.setValue((Object)wfDocument.getFile().getId());
        }
        if (variableToSaveKsefNumber != null) {
            variableToSaveKsefNumber.setValue((Object)pdfGenerationResult.getKsefNumber());
        }
        if (variableToSaveVerificationUrl != null) {
            variableToSaveVerificationUrl.setValue((Object)pdfGenerationResult.getVerificationUrl());
        }
        if (variableToSaveCertificateUrl != null) {
            variableToSaveCertificateUrl.setValue((Object)pdfGenerationResult.getCertificateUrl());
        }
    }

    private Language validateAndGetLanguage(String language) {
        if (language == null || language.isEmpty()) {
            return Language.PL;
        }
        String languageLower = language.toLowerCase();
        for (Language lang : Language.values()) {
            if (!lang.getCode().equals(languageLower)) continue;
            return lang;
        }
        return Language.PL;
    }

    private String createFileName(String fileName, WfFile wfFile) {
        if (fileName != null && !fileName.trim().isEmpty()) {
            String newFileName = fileName.trim();
            if (!newFileName.toLowerCase().endsWith(".pdf")) {
                newFileName = newFileName + '.' + "pdf";
            }
            return newFileName;
        }
        return FilenameUtils.removeExtension((String)wfFile.getFileName()) + '.' + "pdf";
    }
}

