/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import pl.akmf.ksef.sdk.api.HttpStatus;
import pl.akmf.ksef.sdk.api.HttpUtils;
import pl.akmf.ksef.sdk.api.KsefApiProperties;
import pl.akmf.ksef.sdk.api.SimpleHttpClient;
import pl.akmf.ksef.sdk.api.Url;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.ApiResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthKsefTokenRequest;
import pl.akmf.ksef.sdk.client.model.auth.AuthOperationStatusResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthStatus;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationChallengeResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationToken;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationTokenRefreshResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationTokenStatus;
import pl.akmf.ksef.sdk.client.model.auth.AuthorTokenIdentifier;
import pl.akmf.ksef.sdk.client.model.auth.GenerateTokenResponse;
import pl.akmf.ksef.sdk.client.model.auth.KsefTokenRequest;
import pl.akmf.ksef.sdk.client.model.auth.QueryTokensResponse;
import pl.akmf.ksef.sdk.client.model.auth.SignatureResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentStatusResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateEnrollmentsInfoResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateLimitsResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateListRequest;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateListResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateMetadataListResponse;
import pl.akmf.ksef.sdk.client.model.certificate.CertificateRevokeRequest;
import pl.akmf.ksef.sdk.client.model.certificate.QueryCertificatesRequest;
import pl.akmf.ksef.sdk.client.model.certificate.SendCertificateEnrollmentRequest;
import pl.akmf.ksef.sdk.client.model.certificate.publickey.PublicKeyCertificate;
import pl.akmf.ksef.sdk.client.model.invoice.DownloadInvoiceRequest;
import pl.akmf.ksef.sdk.client.model.invoice.InitAsyncInvoicesQueryResponse;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportRequest;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportStatus;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQueryFilters;
import pl.akmf.ksef.sdk.client.model.invoice.QueryInvoiceMetadataResponse;
import pl.akmf.ksef.sdk.client.model.limit.ChangeContextLimitRequest;
import pl.akmf.ksef.sdk.client.model.limit.ChangeSubjectCertificateLimitRequest;
import pl.akmf.ksef.sdk.client.model.limit.GetContextLimitResponse;
import pl.akmf.ksef.sdk.client.model.limit.GetSubjectLimitResponse;
import pl.akmf.ksef.sdk.client.model.permission.OperationResponse;
import pl.akmf.ksef.sdk.client.model.permission.PermissionAttachmentStatusResponse;
import pl.akmf.ksef.sdk.client.model.permission.PermissionStatusInfo;
import pl.akmf.ksef.sdk.client.model.permission.entity.GrantEntityPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.euentity.EuEntityPermissionsGrantRequest;
import pl.akmf.ksef.sdk.client.model.permission.euentity.GrantEUEntityRepresentativePermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.indirect.GrantIndirectEntityPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.person.GrantPersonPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.proxy.GrantAuthorizationPermissionsRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.EntityAuthorizationPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.EuEntityPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityAuthorizationPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityRolesResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEuEntityPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QuerySubunitPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.SubunitPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.subunit.SubunitPermissionsGrantRequest;
import pl.akmf.ksef.sdk.client.model.session.AuthenticationListResponse;
import pl.akmf.ksef.sdk.client.model.session.CommonSessionStatus;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoiceStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoicesResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.session.SessionsQueryResponse;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartStreamSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.batch.PackagePartSignatureInitResponseType;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceResponse;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataAttachmentRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataAttachmentRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPermissionRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPermissionRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPersonCreateRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataPersonRemoveRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataSubjectCreateRequest;
import pl.akmf.ksef.sdk.client.model.testdata.TestDataSubjectRemoveRequest;
import pl.akmf.ksef.sdk.client.peppol.PeppolProvidersListResponse;
import pl.akmf.ksef.sdk.system.SystemKSeFSDKException;

public class DefaultKsefClient
implements KSeFClient {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private final ObjectMapper objectMapper;
    private final Object apiClient;
    private final String baseURl;
    private final Duration timeout;
    private final Map<String, String> defaultHeaders;

    public DefaultKsefClient(Object apiClient, KsefApiProperties ksefApiProperties, ObjectMapper objectMapper) {
        this.apiClient = apiClient;
        this.defaultHeaders = ksefApiProperties.getDefaultHeaders();
        this.timeout = ksefApiProperties.getRequestTimeout();
        this.baseURl = ksefApiProperties.getBaseUri();
        this.objectMapper = objectMapper;
    }

    @Override
    public OperationResponse grantsPermissionsProxyEntity(GrantAuthorizationPermissionsRequest entityAuthorizationPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_AUTHORIZED_SUBJECT_PERMISSION.getUrl(), entityAuthorizationPermissionsGrantRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_AUTHORIZED_SUBJECT_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse grantsPermissionIndirectEntity(GrantIndirectEntityPermissionsRequest grantIndirectEntityPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_INDIRECT_PERMISSION.getUrl(), grantIndirectEntityPermissionsRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_INDIRECT_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OpenBatchSessionResponse openBatchSession(OpenBatchSessionRequest openBatchSessionRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.BATCH_SESSION_OPEN.getUrl(), openBatchSessionRequest, headers);
        HttpUtils.validateResponseStatus(Url.BATCH_SESSION_OPEN.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OpenBatchSessionResponse)this.objectMapper.readValue(response.body(), OpenBatchSessionResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void closeBatchSession(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling closeBatchSession");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.BATCH_SESSION_CLOSE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, null, headers);
        HttpUtils.validateResponseStatus(Url.BATCH_SESSION_CLOSE.getOperationId(), response);
    }

    @Override
    public void sendBatchParts(OpenBatchSessionResponse openBatchSessionResponse, List<BatchPartSendingInfo> parts) throws ApiException {
        if (CollectionUtils.isEmpty(parts)) {
            throw new IllegalArgumentException("No files to send.");
        }
        List<PackagePartSignatureInitResponseType> responsePartUploadRequests = openBatchSessionResponse.getPartUploadRequests();
        if (CollectionUtils.isEmpty(responsePartUploadRequests)) {
            throw new IllegalStateException("No information about parts to send.");
        }
        ArrayList errors = new ArrayList();
        for (PackagePartSignatureInitResponseType responsePart : responsePartUploadRequests) {
            parts.stream().filter(p -> responsePart.getOrdinalNumber() == p.getOrdinalNumber()).forEach(singlePart -> this.singleBatchPartSendingProcess((BatchPartSendingInfo)singlePart, responsePart, errors));
        }
        if (!errors.isEmpty()) {
            throw new ApiException("Errors when sending parts:\n" + String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public void sendBatchPartsWithStream(OpenBatchSessionResponse openBatchSessionResponse, List<BatchPartStreamSendingInfo> parts) throws ApiException {
        if (CollectionUtils.isEmpty(parts)) {
            throw new IllegalArgumentException("No files to send.");
        }
        List<PackagePartSignatureInitResponseType> responsePartUploadRequests = openBatchSessionResponse.getPartUploadRequests();
        if (CollectionUtils.isEmpty(responsePartUploadRequests)) {
            throw new IllegalStateException("No information about parts to send.");
        }
        ArrayList errors = new ArrayList();
        for (PackagePartSignatureInitResponseType responsePart : responsePartUploadRequests) {
            parts.stream().filter(p -> responsePart.getOrdinalNumber() == p.getOrdinalNumber()).forEach(singlePart -> this.singleBatchPartSendingProcessByStream((BatchPartStreamSendingInfo)singlePart, responsePart, errors));
        }
        if (!errors.isEmpty()) {
            throw new ApiException("Errors when sending parts:\n" + String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public OpenOnlineSessionResponse openOnlineSession(OpenOnlineSessionRequest openOnlineSessionRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.SESSION_OPEN.getUrl(), openOnlineSessionRequest, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_OPEN.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OpenOnlineSessionResponse)this.objectMapper.readValue(response.body(), OpenOnlineSessionResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void closeOnlineSession(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling apiV2SessionsOnlineReferenceNumberClosePost");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_CLOSE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, null, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_CLOSE.getOperationId(), response);
    }

    @Override
    public SendInvoiceResponse onlineSessionSendInvoice(String referenceNumber, SendInvoiceOnlineSessionRequest sendInvoiceOnlineSessionRequest, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling apiV2SessionsOnlineReferenceNumberClosePost");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_SEND.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, sendInvoiceOnlineSessionRequest, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE_SEND.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SendInvoiceResponse)this.objectMapper.readValue(response.body(), SendInvoiceResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public CertificateLimitsResponse getCertificateLimits(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.CERTIFICATE_LIMIT.getUrl(), headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_LIMIT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateLimitsResponse)this.objectMapper.readValue(response.body(), CertificateLimitsResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public CertificateEnrollmentsInfoResponse getCertificateEnrollmentInfo(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.CERTIFICATE_ENROLLMENT_DATA.getUrl(), headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_ENROLLMENT_DATA.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateEnrollmentsInfoResponse)this.objectMapper.readValue(response.body(), CertificateEnrollmentsInfoResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public CertificateEnrollmentResponse sendCertificateEnrollment(SendCertificateEnrollmentRequest enrollCertificateRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.CERTIFICATE_ENROLLMENT.getUrl(), enrollCertificateRequest, headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_ENROLLMENT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateEnrollmentResponse)this.objectMapper.readValue(response.body(), CertificateEnrollmentResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public CertificateEnrollmentStatusResponse getCertificateEnrollmentStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateEnrollmentStatusResponse)this.objectMapper.readValue(response.body(), CertificateEnrollmentStatusResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public CertificateListResponse getCertificateList(CertificateListRequest certificateListRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.CERTIFICATE_RETRIEVE.getUrl(), certificateListRequest, headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_RETRIEVE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateListResponse)this.objectMapper.readValue(response.body(), CertificateListResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void revokeCertificate(CertificateRevokeRequest certificateRevokeRequest, String certificateSerialNumber, String accessToken) throws ApiException {
        if (certificateSerialNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'certificateSerialNumber' when calling revokeCertificate");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_REVOKE.getUrl(), new HashMap<String, String>()).replace("{certificateSerialNumber}", certificateSerialNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, certificateRevokeRequest, headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_REVOKE.getOperationId(), response);
    }

    @Override
    public CertificateMetadataListResponse getCertificateMetadataList(QueryCertificatesRequest queryCertificatesRequest, int pageSize, int pageOffset, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.CERTIFICATE_METADATA.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, queryCertificatesRequest, headers);
        HttpUtils.validateResponseStatus(Url.CERTIFICATE_METADATA.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (CertificateMetadataListResponse)this.objectMapper.readValue(response.body(), CertificateMetadataListResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthenticationChallengeResponse getAuthChallenge() throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_CHALLENGE.getUrl(), null, headers);
        HttpUtils.validateResponseStatus(Url.AUTH_CHALLENGE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthenticationChallengeResponse)this.objectMapper.readValue(response.body(), AuthenticationChallengeResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SignatureResponse submitAuthTokenRequest(String signedXml, boolean verifyCertificateChain) throws ApiException {
        if (signedXml == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'body' when calling apiV2AuthTokenSignaturePost");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("verifyCertificateChain", String.valueOf(verifyCertificateChain));
        String uri = HttpUtils.buildUrlWithParams(Url.AUTH_TOKEN_SIGNATURE.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, signedXml, headers);
        HttpUtils.validateResponseStatus(Url.AUTH_TOKEN_SIGNATURE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SignatureResponse)this.objectMapper.readValue(response.body(), SignatureResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SignatureResponse authenticateByKSeFToken(AuthKsefTokenRequest body) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_KSEF_TOKEN.getUrl(), body, headers);
        HttpUtils.validateResponseStatus(Url.AUTH_KSEF_TOKEN.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SignatureResponse)this.objectMapper.readValue(response.body(), SignatureResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthStatus getAuthStatus(String referenceNumber, String authenticationToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenReferenceNumber' when calling apiV2AuthTokenTokenReferenceNumberGet");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.AUTH_TOKEN_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + authenticationToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.AUTH_TOKEN_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthStatus)this.objectMapper.readValue(response.body(), AuthStatus.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthOperationStatusResponse redeemToken(String authenticationToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + authenticationToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.AUTH_TOKEN_REEDEM.getUrl(), null, headers);
        HttpUtils.validateResponseStatus(Url.AUTH_TOKEN_REEDEM.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthOperationStatusResponse)this.objectMapper.readValue(response.body(), AuthOperationStatusResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthenticationTokenRefreshResponse refreshAccessToken(String refreshToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + refreshToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.JWT_TOKEN_REFRESH.getUrl(), null, headers);
        HttpUtils.validateResponseStatus(Url.JWT_TOKEN_REFRESH.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthenticationTokenRefreshResponse)this.objectMapper.readValue(response.body(), AuthenticationTokenRefreshResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void revokeAccessToken(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.JWT_TOKEN_REVOKE.getUrl(), null, headers);
        HttpUtils.validateResponseStatus(Url.JWT_TOKEN_REVOKE.getOperationId(), response);
    }

    @Override
    public PermissionStatusInfo permissionOperationStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (PermissionStatusInfo)this.objectMapper.readValue(response.body(), PermissionStatusInfo.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryPersonPermissionsResponse searchGrantedPersonPermissions(PersonPermissionsQueryRequest personPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_PERSON_PERMISSION.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, personPermissionsQueryRequest, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_PERSON_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryPersonPermissionsResponse)this.objectMapper.readValue(response.body(), QueryPersonPermissionsResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QuerySubunitPermissionsResponse searchSubunitAdminPermissions(SubunitPermissionsQueryRequest subunitPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_SUBUNIT_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, subunitPermissionsQueryRequest, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_SUBUNIT_GRANT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QuerySubunitPermissionsResponse)this.objectMapper.readValue(response.body(), QuerySubunitPermissionsResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryPersonalGrantResponse searchPersonalGrantPermission(QueryPersonalGrantRequest request, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_PERSONAL_GRANTS.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, request, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_PERSONAL_GRANTS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryPersonalGrantResponse)this.objectMapper.readValue(response.body(), QueryPersonalGrantResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryEntityRolesResponse searchEntityInvoiceRoles(int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_ENTITY_ROLES.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_ENTITY_ROLES.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryEntityRolesResponse)this.objectMapper.readValue(response.body(), QueryEntityRolesResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SubordinateEntityRolesQueryResponse searchSubordinateEntityInvoiceRoles(SubordinateEntityRolesQueryRequest subordinateEntityRolesQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_SUBORDINATE_PERMISSION.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, subordinateEntityRolesQueryRequest, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_SUBORDINATE_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SubordinateEntityRolesQueryResponse)this.objectMapper.readValue(response.body(), SubordinateEntityRolesQueryResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryEntityAuthorizationPermissionsResponse searchEntityAuthorizationGrants(EntityAuthorizationPermissionsQueryRequest entityAuthorizationPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_AUTHORIZATIONS_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, entityAuthorizationPermissionsQueryRequest, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_AUTHORIZATIONS_GRANT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryEntityAuthorizationPermissionsResponse)this.objectMapper.readValue(response.body(), QueryEntityAuthorizationPermissionsResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryEuEntityPermissionsResponse searchGrantedEuEntityPermissions(EuEntityPermissionsQueryRequest euEntityPermissionsQueryRequest, int pageOffset, int pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_SEARCH_EU_ENTITY_GRANT.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, euEntityPermissionsQueryRequest, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_SEARCH_EU_ENTITY_GRANT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryEuEntityPermissionsResponse)this.objectMapper.readValue(response.body(), QueryEuEntityPermissionsResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse grantsPermissionEUEntity(EuEntityPermissionsGrantRequest euEntityPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_EU_ADMINISTRATOR_PERMISSION.getUrl(), euEntityPermissionsGrantRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_EU_ADMINISTRATOR_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse grantsPermissionEUEntityRepresentative(GrantEUEntityRepresentativePermissionsRequest grantEUEntityRepresentativePermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_EU_REPRESENTATIVE.getUrl(), grantEUEntityRepresentativePermissionsRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_EU_REPRESENTATIVE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public byte[] getInvoice(String ksefReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_DOWNLOAD_BY_KSEF.getUrl(), new HashMap<String, String>()).replace("{ksefReferenceNumber}", ksefReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_DOWNLOAD_BY_KSEF.getOperationId(), response);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public byte[] getInvoice(DownloadInvoiceRequest downloadInvoiceRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.INVOICE_DOWNLOAD.getUrl(), downloadInvoiceRequest, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_DOWNLOAD.getOperationId(), response);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public QueryInvoiceMetadataResponse queryInvoiceMetadata(Integer pageOffset, Integer pageSize, InvoiceQueryFilters invoiceQueryFilters, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_QUERY_METADATA.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(uri, invoiceQueryFilters, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_QUERY_METADATA.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryInvoiceMetadataResponse)this.objectMapper.readValue(response.body(), QueryInvoiceMetadataResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public InitAsyncInvoicesQueryResponse initAsyncQueryInvoice(InvoiceExportRequest invoiceExportRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.INVOICE_EXPORT_INIT.getUrl(), invoiceExportRequest, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_EXPORT_INIT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (InitAsyncInvoicesQueryResponse)this.objectMapper.readValue(response.body(), InitAsyncInvoicesQueryResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public InvoiceExportStatus checkStatusAsyncQueryInvoice(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'operationReferenceNumber' when calling checkStatusAsyncQueryInvoice");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_EXPORT_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_EXPORT_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (InvoiceExportStatus)this.objectMapper.readValue(response.body(), InvoiceExportStatus.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Deprecated
    public InvoiceExportStatus checkStatusAsyncQueryInvoiceWithMetadata(String referenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'operationReferenceNumber' when calling checkStatusAsyncQueryInvoice");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.INVOICE_EXPORT_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        headers.put("X-KSeF-Feature", "include-metadata");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.INVOICE_EXPORT_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (InvoiceExportStatus)this.objectMapper.readValue(response.body(), InvoiceExportStatus.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse grantsPermissionEntity(GrantEntityPermissionsRequest grantEntityPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_INVOICE_SUBJECT_PERMISSION.getUrl(), grantEntityPermissionsRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_INVOICE_SUBJECT_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SessionStatusResponse getSessionStatus(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_STATUS.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SessionStatusResponse)this.objectMapper.readValue(response.body(), SessionStatusResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SessionInvoiceStatusResponse getSessionInvoiceStatus(String referenceNumber, String invoiceReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_GET_BY_REFERENCE_NUMBER.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{invoiceReferenceNumber}", invoiceReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE_GET_BY_REFERENCE_NUMBER.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SessionInvoiceStatusResponse)this.objectMapper.readValue(response.body(), SessionInvoiceStatusResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public byte[] getSessionInvoiceUpoByReferenceNumber(String referenceNumber, String invoiceReferenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_UPO_BY_INVOICE_REFERENCE.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{invoiceReferenceNumber}", invoiceReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE_UPO_BY_INVOICE_REFERENCE.getOperationId(), response);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public byte[] getSessionInvoiceUpoByKsefNumber(String referenceNumber, String ksefNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_UPO_BY_KSEF.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{ksefNumber}", ksefNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE_UPO_BY_KSEF.getOperationId(), response);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public byte[] getSessionUpo(String referenceNumber, String upoReferenceNumber, String accessToken) throws ApiException {
        if (referenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'referenceNumber' when calling getSessionUpo");
        }
        if (upoReferenceNumber == null) {
            throw new ApiException(HttpStatus.BAD_REQUEST.getCode(), "Missing the required parameter 'upoReferenceNumber' when calling getSessionUpo");
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_UPO.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber).replace("{upoReferenceNumber}", upoReferenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_UPO.getOperationId(), response);
        return new ApiResponse<byte[]>(response.statusCode(), response.headers(), response.body()).getData();
    }

    @Override
    public SessionInvoicesResponse getSessionInvoices(String referenceNumber, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE.getUrl(), params).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SessionInvoicesResponse)this.objectMapper.readValue(response.body(), SessionInvoicesResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SessionInvoicesResponse getSessionFailedInvoices(String referenceNumber, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_INVOICE_FAILED.getUrl(), params).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_INVOICE_FAILED.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SessionInvoicesResponse)this.objectMapper.readValue(response.body(), SessionInvoicesResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public SessionsQueryResponse getSessions(SessionsQueryRequest request, Integer pageSize, String continuationToken, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        if (Objects.nonNull((Object)request.getSessionType())) {
            params.put("sessionType", request.getSessionType().getValue());
        }
        if (Objects.nonNull(request.getReferenceNumber())) {
            params.put("referenceNumber", request.getReferenceNumber());
        }
        if (Objects.nonNull(request.getDateCreatedFrom())) {
            params.put("dateCreatedFrom", request.getDateCreatedFrom().toString());
        }
        if (Objects.nonNull(request.getDateCreatedTo())) {
            params.put("dateCreatedTo", request.getDateCreatedTo().toString());
        }
        if (Objects.nonNull(request.getDateClosedFrom())) {
            params.put("dateClosedFrom", request.getDateClosedFrom().toString());
        }
        if (Objects.nonNull(request.getDateClosedTo())) {
            params.put("dateClosedTo", request.getDateClosedTo().toString());
        }
        if (Objects.nonNull(request.getDateModifiedFrom())) {
            params.put("dateModifiedFrom", request.getDateModifiedFrom().toString());
        }
        if (Objects.nonNull(request.getDateModifiedFrom())) {
            params.put("dateModifiedTo", request.getDateModifiedTo().toString());
        }
        if (Objects.nonNull(request.getStatuses())) {
            List stringList = request.getStatuses().stream().map(CommonSessionStatus::getValue).collect(Collectors.toList());
            params.put("statuses", String.join((CharSequence)", ", stringList));
        }
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_LIST.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_LIST.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (SessionsQueryResponse)this.objectMapper.readValue(response.body(), SessionsQueryResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthenticationListResponse getActiveSessions(Integer pageSize, String continuationToken, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_ACTIVE_SESSIONS.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_ACTIVE_SESSIONS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthenticationListResponse)this.objectMapper.readValue(response.body(), AuthenticationListResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void revokeCurrentSession(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(Url.SESSION_REVOKE_CURRENT_SESSION.getUrl(), headers);
        HttpUtils.validateResponseStatus(Url.SESSION_REVOKE_CURRENT_SESSION.getOperationId(), response);
    }

    @Override
    public void revokeSession(String referenceNumber, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.SESSION_REVOKE_SESSION.getUrl(), new HashMap<String, String>()).replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.SESSION_REVOKE_SESSION.getOperationId(), response);
    }

    @Override
    public PeppolProvidersListResponse getPeppolProvidersList(int pageOffset, int pageSize) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageSize", String.valueOf(pageSize));
        params.put("pageOffset", String.valueOf(pageOffset));
        String uri = HttpUtils.buildUrlWithParams(Url.PEPPOL_QUERY.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.PEPPOL_QUERY.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (PeppolProvidersListResponse)this.objectMapper.readValue(response.body(), PeppolProvidersListResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public GetContextLimitResponse getContextSessionLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_CONTEXT.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_CONTEXT.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (GetContextLimitResponse)this.objectMapper.readValue(response.body(), GetContextLimitResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public GetSubjectLimitResponse getSubjectCertificateLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_SUBJECT_CERTIFICATE.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_SUBJECT_CERTIFICATE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (GetSubjectLimitResponse)this.objectMapper.readValue(response.body(), GetSubjectLimitResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void changeContextLimitTest(ChangeContextLimitRequest changeContextLimitRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        String url = Url.LIMIT_CONTEXT_CHANGE_TEST.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, changeContextLimitRequest, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_CONTEXT_CHANGE_TEST.getOperationId(), response);
    }

    @Override
    public void changeSubjectLimitTest(ChangeSubjectCertificateLimitRequest changeSubjectCertificateLimitRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        String url = Url.LIMIT_SUBJECT_CERTIFICATE_CHANGE_TEST.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, changeSubjectCertificateLimitRequest, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_SUBJECT_CERTIFICATE_CHANGE_TEST.getOperationId(), response);
    }

    @Override
    public void resetContextLimitTest(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_SUBJECT_CERTIFICATE_RESET_TEST.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_SUBJECT_CERTIFICATE_RESET_TEST.getOperationId(), response);
    }

    @Override
    public void resetSubjectCertificateLimit(String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.LIMIT_CONTEXT_RESET_TEST.getUrl(), new HashMap<String, String>());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.LIMIT_CONTEXT_RESET_TEST.getOperationId(), response);
    }

    @Override
    public void createTestSubject(TestDataSubjectCreateRequest testDataSubjectCreateRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_SUBJECT_CREATE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataSubjectCreateRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_SUBJECT_CREATE.getOperationId(), response);
    }

    @Override
    public void removeTestSubject(TestDataSubjectRemoveRequest testDataSubjectRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_SUBJECT_DELETE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataSubjectRemoveRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_SUBJECT_DELETE.getOperationId(), response);
    }

    @Override
    public void createTestPerson(TestDataPersonCreateRequest testDataPersonCreateRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERSON_CREATE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPersonCreateRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_PERSON_CREATE.getOperationId(), response);
    }

    @Override
    public void removeTestPerson(TestDataPersonRemoveRequest testDataPersonRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERSON_DELETE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPersonRemoveRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_PERSON_DELETE.getOperationId(), response);
    }

    @Override
    public void addTestPermission(TestDataPermissionRequest testDataPermissionRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERMISSION.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPermissionRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_PERMISSION.getOperationId(), response);
    }

    @Override
    public void removeTestPermission(TestDataPermissionRemoveRequest testDataPermissionRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_PERMISSION_REVOKE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataPermissionRemoveRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_PERMISSION_REVOKE.getOperationId(), response);
    }

    @Override
    public void addAttachmentPermissionTest(TestDataAttachmentRequest testDataAttachmentRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_ATTACHMENT.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataAttachmentRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_ATTACHMENT.getOperationId(), response);
    }

    @Override
    public void removeAttachmentPermissionTest(TestDataAttachmentRemoveRequest testDataAttachmentRemoveRequest) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = Url.TEST_ATTACHMENT_REVOKE.getUrl();
        SimpleHttpClient.SimpleHttpResponse response = this.post(url, testDataAttachmentRemoveRequest, headers);
        HttpUtils.validateResponseStatus(Url.TEST_ATTACHMENT_REVOKE.getOperationId(), response);
    }

    @Override
    public OperationResponse grantsPermissionPerson(GrantPersonPermissionsRequest grantPersonPermissionsRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_PERSON_PERMISSION.getUrl(), grantPersonPermissionsRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_PERSON_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse grantsPermissionSubUnit(SubunitPermissionsGrantRequest subunitPermissionsGrantRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.GRANT_SUBUNIT_PERMISSION.getUrl(), subunitPermissionsGrantRequest, headers);
        HttpUtils.validateResponseStatus(Url.GRANT_SUBUNIT_PERMISSION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse revokeCommonPermission(String permissionId, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_REVOKE_COMMON.getUrl(), new HashMap<String, String>()).replace("{permissionId}", permissionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_REVOKE_COMMON.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public OperationResponse revokeAuthorizationsPermission(String permissionId, String accessToken) throws ApiException {
        String uri = HttpUtils.buildUrlWithParams(Url.PERMISSION_REVOKE_AUTHORIZATION.getUrl(), new HashMap<String, String>()).replace("{permissionId}", permissionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_REVOKE_AUTHORIZATION.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (OperationResponse)this.objectMapper.readValue(response.body(), OperationResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public PermissionAttachmentStatusResponse checkPermissionAttachmentInvoiceStatus(String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.delete(Url.PERMISSION_ATTACHMENT_STATUS.getUrl(), headers);
        HttpUtils.validateResponseStatus(Url.PERMISSION_ATTACHMENT_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (PermissionAttachmentStatusResponse)this.objectMapper.readValue(response.body(), PermissionAttachmentStatusResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public GenerateTokenResponse generateKsefToken(KsefTokenRequest ksefTokenRequest, String accessToken) throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.post(Url.TOKEN_GENERATE.getUrl(), ksefTokenRequest, headers);
        HttpUtils.validateResponseStatus(Url.TOKEN_GENERATE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (GenerateTokenResponse)this.objectMapper.readValue(response.body(), GenerateTokenResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public QueryTokensResponse queryKsefTokens(List<AuthenticationTokenStatus> statuses, String description, String authorIdentifier, AuthorTokenIdentifier.IdentifierType authorIdentifierType, String continuationToken, Integer pageSize, String accessToken) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        statuses.forEach(stat -> params.put("status", stat.toString()));
        if (pageSize != null) {
            params.put("pageSize", String.valueOf(pageSize));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            params.put("description", description);
        }
        if (StringUtils.isNotBlank((CharSequence)authorIdentifier)) {
            params.put("authorIdentifier", authorIdentifier);
        }
        if (Objects.nonNull((Object)authorIdentifierType)) {
            params.put("authorIdentifierType", authorIdentifierType.getValue());
        }
        String uri = HttpUtils.buildUrlWithParams(Url.TOKEN_LIST.getUrl(), params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        if (continuationToken != null) {
            headers.put("x-continuation-token", continuationToken);
        }
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.TOKEN_LIST.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (QueryTokensResponse)this.objectMapper.readValue(response.body(), QueryTokensResponse.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public AuthenticationToken getKsefToken(String referenceNumber, String accessToken) throws ApiException {
        String uri = Url.TOKEN_STATUS.getUrl().replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(uri, headers);
        HttpUtils.validateResponseStatus(Url.TOKEN_STATUS.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (AuthenticationToken)this.objectMapper.readValue(response.body(), AuthenticationToken.class))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void revokeKsefToken(String referenceNumber, String accessToken) throws ApiException {
        String uri = Url.TOKEN_REVOKE.getUrl().replace("{referenceNumber}", referenceNumber);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient.SimpleHttpResponse response = this.delete(uri, headers);
        HttpUtils.validateResponseStatus(Url.TOKEN_REVOKE.getOperationId(), response);
    }

    @Override
    public List<PublicKeyCertificate> retrievePublicKeyCertificate() throws ApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        SimpleHttpClient.SimpleHttpResponse response = this.get(Url.SECURITY_PUBLIC_KEY_CERTIFICATE.getUrl(), headers);
        HttpUtils.validateResponseStatus(Url.SECURITY_PUBLIC_KEY_CERTIFICATE.getOperationId(), response);
        try {
            return new ApiResponse<Object>(response.statusCode(), response.headers(), (response.body() == null ? null : (List)this.objectMapper.readValue(response.body(), (TypeReference)new TypeReference<List<PublicKeyCertificate>>(){}))).getData();
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse get(String uri, Map<String, String> headers) {
        try {
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            return SimpleHttpClient.sendRequest(this.baseURl + uri, GET, null, allHeaders);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse post(String uri, Object body, Map<String, String> headers) throws SystemKSeFSDKException {
        try {
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            byte[] bodyBytes = null;
            if (body != null) {
                bodyBytes = body instanceof byte[] ? (byte[])body : (body instanceof String ? ((String)body).getBytes(StandardCharsets.UTF_8) : this.objectMapper.writeValueAsBytes(body));
            }
            return SimpleHttpClient.sendRequest(this.baseURl + uri, POST, bodyBytes, allHeaders);
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    private SimpleHttpClient.SimpleHttpResponse delete(String uri, Map<String, String> headers) throws SystemKSeFSDKException {
        try {
            HashMap<String, String> allHeaders = new HashMap<String, String>(this.defaultHeaders);
            if (headers != null) {
                allHeaders.putAll(headers);
            }
            return SimpleHttpClient.sendRequest(this.baseURl + uri, DELETE, null, allHeaders);
        }
        catch (IOException e) {
            throw new SystemKSeFSDKException(e.getMessage(), e);
        }
    }

    @Override
    public void singleBatchPartSendingProcess(BatchPartSendingInfo batchPartSendingInfo, PackagePartSignatureInitResponseType responsePart, List<String> errors) {
    }

    @Override
    public void singleBatchPartSendingProcessByStream(BatchPartStreamSendingInfo batchPartStreamSendingInfo, PackagePartSignatureInitResponseType responsePart, List<String> errors) {
    }
}

