/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.service;

import com.suncode.plugin.plusksef.document.service.KSeFQrURLGenerator;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.plugin.plusksef.invoice.enums.KsefCustomKeysV3;
import com.suncode.plugin.plusksef.invoice.model.InternalInvoiceModel;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.FakturaV1;
import com.suncode.plugin.plusksef.invoice.model.ksefV2.FakturaV2;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3;
import com.suncode.plugin.plusksef.invoice.service.InvoiceDataService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceDataServiceImpl
implements InvoiceDataService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceDataServiceImpl.class);
    @Autowired
    private KsefDocumentService ksefDocumentService;
    @Autowired
    private KSeFQrURLGenerator kSeFQrURLGenerator;

    @Override
    public Map<String, Object> getInvoiceDataWithCustomKeys(byte[] xmlDocumentBytes, long fileId) throws Exception {
        Map<String, Object> invoiceData = this.getInvoiceData(xmlDocumentBytes);
        invoiceData.putAll(this.getInvoiceCustomKeys(xmlDocumentBytes, fileId));
        return invoiceData;
    }

    @Override
    public Map<String, Object> getInvoiceData(byte[] xmlDocumentBytes) throws Exception {
        short schemaVersion = this.ksefDocumentService.getSchemaVersion(xmlDocumentBytes);
        if (schemaVersion == 1) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV1.class});
            FakturaV1 faktura = (FakturaV1)jc.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
            InternalInvoiceModel internalInvoiceModel = new InternalInvoiceModel(faktura);
            return internalInvoiceModel.getData();
        }
        if (schemaVersion == 2) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV2.class});
            FakturaV2 faktura = (FakturaV2)jc.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
            InternalInvoiceModel internalInvoiceModel = new InternalInvoiceModel(faktura);
            return internalInvoiceModel.getData();
        }
        if (schemaVersion == 3) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV3.class});
            FakturaV3 faktura = (FakturaV3)jc.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
            InternalInvoiceModel internalInvoiceModel = new InternalInvoiceModel(faktura);
            return internalInvoiceModel.getData();
        }
        throw new IllegalArgumentException("KSeF invoice type undefined");
    }

    @NonNull
    private Map<String, Object> getInvoiceCustomKeys(byte[] xmlDocumentBytes, long fileId) throws Exception {
        short schemaVersion = this.ksefDocumentService.getSchemaVersion(xmlDocumentBytes);
        if (schemaVersion == 3) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV3.class});
            FakturaV3 faktura = (FakturaV3)jc.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
            return KsefCustomKeysV3.stream().map(ksefCustomKey -> {
                try {
                    return new AbstractMap.SimpleEntry<String, Object>(ksefCustomKey.getKey(), ksefCustomKey.getValue(faktura, fileId, this.kSeFQrURLGenerator));
                }
                catch (Exception e) {
                    log.warn("Custom key reading problem:" + ksefCustomKey.getKey() + ". Error msg:" + e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return Collections.emptyMap();
    }
}

