/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.service;

import com.suncode.plugin.core.lib.service.NodeService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KsefPdfGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(KsefPdfGeneratorService.class);
    public static final String NODE_SCRIPT_HOME_DESTINATION_DIR = "files/ksef/scripts/generate-pdf.js";
    public static final String JS_LIB_HOME_DESTINATION_DIR = "files/ksef/scripts/lib/ksef-pdf-generator.es.js";
    private static final int TIMEOUT_SECONDS = 60;
    private static final String PLUSWORKFLOW_HOME = "plusworkflow.home";
    @Autowired
    NodeService nodeService;

    public ByteArrayOutputStream generatePdfFromXml(byte[] xmlDocumentBytes) throws IOException, InterruptedException {
        return this.generatePdfFromXml(xmlDocumentBytes, "", "", "");
    }

    public ByteArrayOutputStream generatePdfFromXml(byte[] xmlDocumentBytes, String nrKSeF, String qrCode, String qrCode2) throws IOException, InterruptedException {
        Path scriptPath = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), NODE_SCRIPT_HOME_DESTINATION_DIR);
        Path nodeExecutablePath = this.resolveNodeExecutable();
        ProcessBuilder processBuilder = new ProcessBuilder(nodeExecutablePath.toString(), scriptPath.toString(), nrKSeF != null ? nrKSeF : "", qrCode != null ? qrCode : "", qrCode2 != null ? qrCode2 : "");
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        try (OutputStream processStdin = process.getOutputStream();){
            processStdin.write(xmlDocumentBytes);
            processStdin.flush();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream processStdout = process.getInputStream();){
            IOUtils.copy((InputStream)processStdout, (OutputStream)outputStream);
        }
        boolean finished = process.waitFor(60L, TimeUnit.SECONDS);
        if (!finished) {
            process.destroyForcibly();
            throw new IOException("PDF generation timeout after 60 seconds");
        }
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            String errorOutput = outputStream.toString("UTF-8");
            log.error("PDF generation failed with exit code {}: {}", (Object)exitCode, (Object)errorOutput);
            throw new IOException("PDF generation failed with exit code " + exitCode + ": " + errorOutput);
        }
        if (outputStream.size() == 0) {
            throw new IOException("PDF was not generated");
        }
        return outputStream;
    }

    private Path resolveNodeExecutable() throws IOException {
        if (KsefPdfGeneratorService.isWindows()) {
            Path windowsNode = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), this.nodeService.getWindowsHomeDestinationPath());
            return this.ensureExecutableExists(windowsNode);
        }
        Path unixNode = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), this.nodeService.getLinuxHomeDestinationPath());
        return this.ensureExecutableExists(unixNode);
    }

    private Path ensureExecutableExists(Path executablePath) throws IOException {
        if (Files.exists(executablePath, new LinkOption[0]) && Files.isRegularFile(executablePath, new LinkOption[0]) && Files.isExecutable(executablePath)) {
            return executablePath;
        }
        throw new IOException("Node executable not found at " + executablePath);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).contains("win");
    }
}

