/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.hook;

import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.hook.annotation.Hook;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ViewFileHookAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Hook
public class KSeFInvoiceHook
extends ViewFileHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(KSeFInvoiceHook.class);
    @Autowired
    private KsefDocumentService ksefDocumentService;

    public OpenedFileContext execute(OpenedFileContext openedFileContext) {
        block7: {
            byte[] xmlDocumentBytes = new byte[]{};
            try {
                boolean isUpo;
                if (!openedFileContext.getExtension().equalsIgnoreCase("xml")) {
                    return openedFileContext;
                }
                xmlDocumentBytes = IOUtils.toByteArray((InputStream)openedFileContext.getInputStream());
                boolean isInvoice = this.ksefDocumentService.isKsefInvoiceDocument(xmlDocumentBytes);
                boolean bl = isUpo = !isInvoice && this.ksefDocumentService.isKsefUpoDocument(xmlDocumentBytes);
                if (isInvoice) {
                    ByteArrayOutputStream pdfOutputStream = this.ksefDocumentService.generatePdfFromKsefInvoiceXml(xmlDocumentBytes, openedFileContext.getWfFile(), true);
                    this.updateOpenedFileWithPdf(openedFileContext, pdfOutputStream);
                } else if (isUpo) {
                    ByteArrayOutputStream pdfOutputStream = this.ksefDocumentService.generatePdfFromKsefUPOXml(xmlDocumentBytes);
                    this.updateOpenedFileWithPdf(openedFileContext, pdfOutputStream);
                } else {
                    openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (xmlDocumentBytes.length <= 0) break block7;
                openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(xmlDocumentBytes));
            }
        }
        return openedFileContext;
    }

    private void updateOpenedFileWithPdf(OpenedFileContext openedFileContext, ByteArrayOutputStream pdfOutputStream) {
        byte[] pdfBytes = pdfOutputStream.toByteArray();
        openedFileContext.setExtension("pdf");
        openedFileContext.setMimeType("application/pdf");
        openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(pdfBytes));
    }
}

