/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.controller;

import com.suncode.plugin.plusksef.document.dto.DocClassInfo;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Transactional
@Controller
@RequestMapping(value={"/documents"})
public class DocumentController {
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    KsefDocumentService converterService;
    @Autowired
    DocumentService documentService;
    private static final String APPLICATION_PDF_VALUE = "application/pdf";

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocClassInfo> getDocumentClassList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List documentClassList = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((String)documentClass.getName(), (String)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        result.setTotal((long)documentClassList.size());
        if (documentClassList.size() >= start) {
            List docClassInfoList = documentClassList.stream().map(DocClassInfo::new).collect(Collectors.toList());
            result.setData(docClassInfoList.subList(start, Integer.min(start + limit, documentClassList.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        return result;
    }
}

