/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.invoice.SendInvoiceResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.api.v2.services.dto.SendInvoiceResponseV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/SendInvoiceToKSeF/pwe_dynamic_form.js")
public class SendInvoiceToKSeF {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceToKSeF.class);
    private static final String ID = "plusksef.autotask.SendInvoiceToKSeF";
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private FileService fileService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.UP)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("referenceNumber").name(ID.concat(".param.referenceNumber.name")).description(ID.concat(".param.referenceNumber.desc")).type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String configId, @Param Integer fileId, @Param(value="referenceNumber") Variable elementReferenceNumber, ApplicationContext applicationContext) throws AcceptanceException, IOException {
        KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
        if (ksefImportConfig.getApiVersion() == KsefApiVersion.V2) {
            this.executeKSeFv2(ksefImportConfig, fileId, elementReferenceNumber, applicationContext);
        } else {
            this.executeKSeFv1(ksefImportConfig, fileId, elementReferenceNumber, applicationContext);
        }
    }

    private void executeKSeFv1(KsefImportConfig ksefImportConfig, Integer fileId, Variable elementReferenceNumber, ApplicationContext applicationContext) throws AcceptanceException {
        try {
            log.info("Send invoice to KSeF API v1");
            SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(ksefImportConfig);
            String invoicePath = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]).getFullPath();
            log.info("Document fileId: {}, Path: {}", (Object)fileId, (Object)invoicePath);
            SendInvoiceResponse sendInvoiceResponse = this.kSeFServiceApiV1.sendInvoice(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), Files.readAllBytes(Paths.get(invoicePath, new String[0])));
            elementReferenceNumber.setValue((Object)sendInvoiceResponse.getElementReferenceNumber());
            try {
                this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber(), applicationContext.getActivityId(), sessionInfo.getSessionToken());
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.addCommentToActivity(applicationContext.getActivityId(), applicationContext.getProcessId(), "There was a problem saving data in ExportedDocumentTable. " + e.getMessage());
            }
            log.info(String.format("DOCUMENT EXPORTED. Invoice reference number: %s. KSeF element reference number: %S", sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeKSeFv2(KsefImportConfig ksefImportConfig, Integer fileId, Variable elementReferenceNumber, ApplicationContext applicationContext) throws AcceptanceException {
        try {
            log.info("Send invoice to KSeF API v2");
            String invoicePath = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]).getFullPath();
            log.info("Document fileId: {}, Path: {}", (Object)fileId, (Object)invoicePath);
            SendInvoiceResponseV2 sendInvoiceResponse = this.kSeFServiceApiV2.sendInvoice(ksefImportConfig, Files.readAllBytes(Paths.get(invoicePath, new String[0])));
            elementReferenceNumber.setValue((Object)sendInvoiceResponse.getExportReferenceNumber());
            try {
                this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), sendInvoiceResponse.getExportReferenceNumber(), sendInvoiceResponse.getSessionInfo().getSessionReferenceNumber(), applicationContext.getActivityId(), sendInvoiceResponse.getSessionInfo().getAccessToken());
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.addCommentToActivity(applicationContext.getActivityId(), applicationContext.getProcessId(), "There was a problem saving data in ExportedDocumentTable. " + e.getMessage());
            }
            log.info(String.format("DOCUMENT EXPORTED. Invoice reference number: %s. Session reference number: %S", sendInvoiceResponse.getExportReferenceNumber(), sendInvoiceResponse.getSessionInfo().getSessionReferenceNumber()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void addCommentToActivity(String activityId, String processId, String commentValue) {
        String username = UserContext.isActive() ? UserContext.current().getUser().getUserName() : SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME");
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setUserId(username);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment(commentValue);
        this.commentService.createComment(comment);
    }
}

