/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.v2.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class XAdESSignatureService {
    public static String sign(byte[] xml, X509Certificate signatureCertificate, PrivateKey privateKey) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xml));
            Element rootElement = document.getDocumentElement();
            if (!rootElement.hasAttribute("xmlns")) {
                rootElement.setAttribute("xmlns", "http://ksef.mf.gov.pl/auth/token/2.0");
            }
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            String signatureId = "Signature";
            Element qualifyingProperties = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:QualifyingProperties");
            qualifyingProperties.setAttribute("Target", "#" + signatureId);
            qualifyingProperties.setAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
            qualifyingProperties.setAttribute("xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
            Element signedProperties = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:SignedProperties");
            signedProperties.setAttribute("Id", "SignedProperties");
            Element signedSignatureProperties = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:SignedSignatureProperties");
            Element signingTime = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:SigningTime");
            String signingTimeValue = Instant.now().toString();
            signingTime.setTextContent(signingTimeValue);
            signedSignatureProperties.appendChild(signingTime);
            Element signingCertificate = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:SigningCertificate");
            Element cert = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:Cert");
            Element certDigest = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:CertDigest");
            Element digestMethod = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
            digestMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
            Element digestValue = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] certBytes = signatureCertificate.getEncoded();
                byte[] certDigestBytes = digest.digest(certBytes);
                String digestValueStr = Base64.getEncoder().encodeToString(certDigestBytes);
                digestValue.setTextContent(digestValueStr);
            }
            catch (Exception e) {
                digestValue.setTextContent("");
            }
            certDigest.appendChild(digestMethod);
            certDigest.appendChild(digestValue);
            cert.appendChild(certDigest);
            Element issuerSerial = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", "xades:IssuerSerial");
            Element issuerName = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
            Element serialNumber = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
            String issuerNameValue = signatureCertificate.getIssuerX500Principal().getName();
            String serialNumberValue = signatureCertificate.getSerialNumber().toString();
            issuerName.setTextContent(issuerNameValue);
            serialNumber.setTextContent(serialNumberValue);
            issuerSerial.appendChild(issuerName);
            issuerSerial.appendChild(serialNumber);
            cert.appendChild(issuerSerial);
            signingCertificate.appendChild(cert);
            signedSignatureProperties.appendChild(signingCertificate);
            signedProperties.appendChild(signedSignatureProperties);
            qualifyingProperties.appendChild(signedProperties);
            XMLObject xadesObject = xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(qualifyingProperties)), null, null, null);
            List<Transform> docTransforms = Arrays.asList(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null), xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null));
            Reference docRef = xmlSignatureFactory.newReference("", xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), docTransforms, null, null);
            Reference signedPropsRef = xmlSignatureFactory.newReference("#SignedProperties", xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), Collections.singletonList(xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null)), "http://uri.etsi.org/01903#SignedProperties", null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Arrays.asList(docRef, signedPropsRef));
            KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
            X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList(signatureCertificate));
            KeyInfo ki = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
            XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, ki, Collections.singletonList(xadesObject), signatureId, null);
            DOMSignContext domSignContext = new DOMSignContext(privateKey, (Node)document.getDocumentElement());
            try {
                domSignContext.setIdAttributeNS(signedProperties, null, "Id");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            signature.sign(domSignContext);
            return XAdESSignatureService.documentToString(document);
        }
        catch (Exception e) {
            throw new IOException("Failed to sign XML document", e);
        }
    }

    private static String documentToString(Document document) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
    }
}

