/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.system;

import java.nio.charset.StandardCharsets;

public class KSeFNumberValidator {
    private static final byte POLYNOMIAL = 7;
    private static final byte INIT_VALUE = 0;
    private static final int EXPECTED_LENGTH = 35;
    private static final int DATA_LENGTH = 32;
    private static final int CHECKSUM_LENGTH = 2;

    public static ValidationResult isValid(String ksefNumber) {
        boolean isValid;
        if (ksefNumber == null || ksefNumber.trim().isEmpty()) {
            return new ValidationResult(false, "Numer KSeF jest pusty.");
        }
        if (ksefNumber.length() != 35) {
            String errorMessage = String.format("Numer KSeF ma nieprawid\u0142ow\u0105 d\u0142ugo\u015b\u0107: %d. Oczekiwana d\u0142ugo\u015b\u0107 to %d.", ksefNumber.length(), 35);
            return new ValidationResult(false, errorMessage);
        }
        String data = ksefNumber.substring(0, 32);
        String checksum = ksefNumber.substring(ksefNumber.length() - 2);
        String calculated = KSeFNumberValidator.computeChecksum(data.getBytes(StandardCharsets.UTF_8));
        return new ValidationResult(isValid, (isValid = calculated.equals(checksum)) ? "" : "Nieprawid\u0142owa suma kontrolna.");
    }

    private static String computeChecksum(byte[] data) {
        byte crc = 0;
        for (byte b : data) {
            crc = (byte)(crc ^ b);
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 0x80) != 0 ? (byte)(crc << 1 ^ 7) : (byte)(crc << 1);
            }
        }
        return String.format("%02X", crc);
    }

    public static class ValidationResult {
        private final boolean isValid;
        private final String errorMessage;

        public ValidationResult(boolean isValid, String errorMessage) {
            this.isValid = isValid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

