/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class SimpleHttpClient {
    public static SimpleHttpResponse sendRequest(String url, String method, byte[] body, Map<String, String> headers) throws IOException {
        byte[] responseBody;
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setRequestMethod(method);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(60000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (body != null && (method.equals("POST") || method.equals("PUT"))) {
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                os.write(body);
            }
        }
        int statusCode = connection.getResponseCode();
        try (InputStream is = connection.getInputStream();){
            responseBody = SimpleHttpClient.readAllBytes(is);
        }
        catch (IOException e) {
            try (InputStream errorIs = connection.getErrorStream();){
                responseBody = errorIs != null ? SimpleHttpClient.readAllBytes(errorIs) : new byte[]{};
            }
        }
        return new SimpleHttpResponse(statusCode, responseBody, null);
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static class SimpleHttpResponse {
        private final int statusCode;
        private final byte[] body;
        private final Map<String, String> headers;

        public SimpleHttpResponse(int statusCode, byte[] body, Map<String, String> headers) {
            this.statusCode = statusCode;
            this.body = body;
            this.headers = headers;
        }

        public int statusCode() {
            return this.statusCode;
        }

        public byte[] body() {
            return this.body;
        }

        public Map<String, String> headers() {
            return this.headers;
        }
    }
}

