/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeys;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV2;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.plugin.plusksef.invoice.model.InternalInvoiceModel;
import com.suncode.plugin.plusksef.invoice.service.InvoiceService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/LoadInvoiceInfoFromXml/pwe_dynamic_form.js")
public class LoadInvoiceInfoFromXml {
    private static final Logger log = LoggerFactory.getLogger(LoadInvoiceInfoFromXml.class);
    private static final String ID = "plusksef.autotask.LoadInvoiceInfoFromXml";
    @Autowired
    private FileService fileService;
    @Autowired
    private InvoiceService invoiceService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.DOCUMENT2)).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("schematVersion").name(ID.concat(".param.schematVersion.name")).description(ID.concat(".param.schematVersion.desc")).type((Type)Types.STRING).defaultValue((Object)"2").create()).parameter().id("variable").name(ID.concat(".param.variable.name")).description(ID.concat(".param.variable.desc")).type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("ksefKey").name(ID.concat(".param.ksefKey.name")).description(ID.concat(".param.ksefKey.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("variableForFunction").name(ID.concat(".param.variableForFunction.name")).description(ID.concat(".param.variableForFunction.desc")).type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("ksefKeyFn").name(ID.concat(".param.ksefKeyFn.name")).description(ID.concat(".param.ksefKeyFn.desc")).type((Type)Types.FUNCTION_ARRAY).optional().create();
        this.addContext(builder);
    }

    private void addContext(ApplicationDefinitionBuilder builder) {
        Set<KsefKeysV2> v2Keys = KsefKeysV2.stream().collect(Collectors.toSet());
        Set v2KeySet = v2Keys.stream().map(KsefKeysV2::getKey).collect(Collectors.toSet());
        List<KsefKeysV3> v3ExcessKeys = KsefKeysV3.stream().filter(v3Key -> !v2KeySet.contains(v3Key.getKey())).collect(Collectors.toList());
        v2Keys.forEach(ksefKey -> builder.contextVariable().id(ksefKey.getKey()).name(ksefKey.getKey()).description(ksefKey.getDesc()).type(ksefKey.getType()).create());
        v3ExcessKeys.forEach(ksefKey -> builder.contextVariable().id(ksefKey.getKey()).name(ksefKey.getKey()).description(ksefKey.getDesc()).type(ksefKey.getType()).create());
    }

    public void execute(@Param Integer fileId, @Param String schematVersion, @Param Variable[] variable, @Param String[] ksefKey, @Param Variable[] variableForFunction, @Param FunctionCall[] ksefKeyFn, ContextVariables contextVariables) throws AcceptanceException {
        try {
            InternalInvoiceModel internalInvoiceModel = this.invoiceService.createInternalInvoiceModel(this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]), Short.parseShort(schematVersion));
            IntStream.range(0, variable.length).forEach(i -> {
                variable[i].setValue(internalInvoiceModel.getData().get(ksefKey[i]));
                log.debug("Set variable " + variable[i].getId() + ": " + variable[i].getValueAsBasicType());
            });
            this.completeContextVariables(contextVariables, internalInvoiceModel, Short.parseShort(schematVersion));
            IntStream.range(0, variableForFunction.length).forEach(i -> {
                variableForFunction[i].setValue(ksefKeyFn[i].call());
                log.debug("Set variable " + variableForFunction[i].getId() + ": " + variableForFunction[i].getValueAsBasicType());
            });
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void completeContextVariables(ContextVariables contextVariables, InternalInvoiceModel internalInvoiceModel, short schemaVersion) {
        switch (schemaVersion) {
            case 1: {
                log.debug("Schema v1 is no longer supported\n");
                break;
            }
            case 2: {
                this.processKsefKeys(contextVariables, internalInvoiceModel, KsefKeysV2.stream());
                break;
            }
            case 3: {
                this.processKsefKeys(contextVariables, internalInvoiceModel, KsefKeysV3.stream());
                break;
            }
            default: {
                log.error("Unsupported schema version: " + schemaVersion);
            }
        }
    }

    private void processKsefKeys(ContextVariables contextVariables, InternalInvoiceModel internalInvoiceModel, Stream<? extends KsefKeys> ksefKeysStream) {
        ksefKeysStream.forEach(ksefKey -> {
            try {
                Object value = internalInvoiceModel.getData().get(ksefKey.getKey());
                contextVariables.set(ksefKey.getKey(), value == null ? ksefKey.getType().defaultValue() : value);
            }
            catch (Exception e) {
                log.error("completeContextVariables error: " + ksefKey.getKey() + ", value: " + internalInvoiceModel.getData().get(ksefKey.getKey()));
                log.error(e.getMessage());
            }
        });
    }
}

