/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.db.servicie;

import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.db.dao.ExportedDocumentTableDao;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ExportedDocumentTableServiceImpl
extends EditableServiceImpl<ExportedDocumentTableEntity, Long, ExportedDocumentTableDao>
implements ExportedDocumentTableService {
    private static final Logger log = LoggerFactory.getLogger(ExportedDocumentTableServiceImpl.class);

    @Autowired
    public void setDao(ExportedDocumentTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void addInfo(KsefImportConfig ksefImportConfig, long fileId, String referenceNumber, String elementReferenceNumber, String activityId, String sessionToken) {
        ((ExportedDocumentTableDao)this.dao).save(this.createEntity(fileId, ksefImportConfig.getNip(), ksefImportConfig.getConfigId(), ksefImportConfig.getKsefSystemType(), referenceNumber, elementReferenceNumber, activityId, sessionToken));
    }

    private ExportedDocumentTableEntity createEntity(long fileId, String nip, String configId, String ksefSystemType, String referenceNumber, String elementReferenceNumber, String activityId, String sessionToken) {
        return ExportedDocumentTableEntity.builder().exportTime(Timestamp.from(Instant.now())).fileId(fileId).nip(nip).configId(configId).systemType(ksefSystemType).referenceNumber(referenceNumber).elementReferenceNumber(elementReferenceNumber).status("Exported. Waiting for KSeF status.").activityId(activityId).sessionToken(sessionToken).build();
    }

    @Override
    public ExportedDocumentTableEntity getRowByElementReferenceNumber(String elementReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"elementReferenceNumber", (Object)elementReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect elementReferenceNumber. Record not found in DB: " + elementReferenceNumber);
    }

    @Override
    public ExportedDocumentTableEntity getRowByKsefReferenceNumber(String ksefReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"ksefReferenceNumber", (Object)ksefReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect ksefReferenceNumber. Record not found in DB: " + ksefReferenceNumber);
    }

    @Override
    public void updateRecord(String elementReferenceNumber, String status, String ksefReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"elementReferenceNumber", (Object)elementReferenceNumber));
        ExportedDocumentTableEntity firstRowByCriteria = this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect elementReferenceNumber. Not found in DB: " + elementReferenceNumber);
        firstRowByCriteria.setStatus(status);
        if (!StringUtils.isBlank((CharSequence)ksefReferenceNumber)) {
            firstRowByCriteria.setKsefReferenceNumber(ksefReferenceNumber);
        }
    }

    @Override
    public Optional<ExportedDocumentTableEntity> getEntity(Long fileId) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"fileId", (Object)fileId));
        return ((ExportedDocumentTableDao)this.dao).findByCriteria(exportedDocument).stream().findFirst();
    }

    private ExportedDocumentTableEntity getFirstRowByCriteria(HibernateCriteria<ExportedDocumentTableEntity> detachedCriteria, String exceptionMessage) {
        List byCriteria = ((ExportedDocumentTableDao)this.dao).findByCriteria(detachedCriteria);
        return (ExportedDocumentTableEntity)byCriteria.stream().findFirst().orElseThrow(() -> new IllegalArgumentException(exceptionMessage));
    }
}

