/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.service;

import com.suncode.plugin.plusksef.api.model.payment.GetPaymentIdentifierReferenceNumbersResponse;
import com.suncode.plugin.plusksef.api.model.payment.GetPaymentIdentifiersByKSeFNumberResponse;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierRequest;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierResponse;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierStatusResponse;
import com.suncode.plugin.plusksef.api.service.ApiException;
import com.suncode.plugin.plusksef.api.service.BaseKsefService;
import com.suncode.plugin.plusksef.api.service.PaymentService;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
extends BaseKsefService
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);

    @Override
    public RequestPaymentIdentifierResponse requestPaymentIdentifier(String ksefApiUrl, String token, RequestPaymentIdentifierRequest request) throws IOException, ApiException {
        log.info("Requesting payment identifier for {} invoices", (Object)request.getKsefReferenceNumberList().size());
        String url = ksefApiUrl + "/online/Payment/Identifier/Request";
        String json = this.gson.toJson((Object)request);
        RequestBody requestBody = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
        Request httpRequest = new Request.Builder().url(url).method("POST", requestBody).addHeader("SessionToken", token).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
        return this.executeRequest(httpRequest, RequestPaymentIdentifierResponse.class);
    }

    @Override
    public RequestPaymentIdentifierStatusResponse getPaymentIdentifierStatus(String ksefApiUrl, String token, String paymentElementReferenceNumber) throws ApiException {
        try {
            log.info("Checking payment identifier status for element: {}", (Object)paymentElementReferenceNumber);
            String url = ksefApiUrl + "/online/Payment/Identifier/Status/" + paymentElementReferenceNumber;
            Request httpRequest = new Request.Builder().url(url).method("GET", null).addHeader("SessionToken", token).build();
            return this.executeRequest(httpRequest, RequestPaymentIdentifierStatusResponse.class);
        }
        catch (Exception e) {
            log.error("Error getting payment identifier status", (Throwable)e);
            throw new ApiException("Failed to get payment identifier status: " + e.getMessage());
        }
    }

    @Override
    public GetPaymentIdentifiersByKSeFNumberResponse getPaymentIdentifiersForInvoice(String ksefApiUrl, String token, String ksefReferenceNumber, int pageSize, int pageOffset) throws ApiException {
        try {
            log.info("Getting payment identifiers for invoice: {}, pageSize: {}, pageOffset: {}", new Object[]{ksefReferenceNumber, pageSize, pageOffset});
            String url = String.format("%s/online/Payment/Identifier/GetPaymentIdentifiers/%s?PageSize=%d&PageOffset=%d", ksefApiUrl, ksefReferenceNumber, pageSize, pageOffset);
            Request httpRequest = new Request.Builder().url(url).method("GET", null).addHeader("SessionToken", token).build();
            return this.executeRequest(httpRequest, GetPaymentIdentifiersByKSeFNumberResponse.class);
        }
        catch (Exception e) {
            log.error("Error getting payment identifiers for invoice", (Throwable)e);
            throw new ApiException("Failed to get payment identifiers for invoice: " + e.getMessage());
        }
    }

    @Override
    public GetPaymentIdentifierReferenceNumbersResponse getInvoicesForPaymentIdentifier(String ksefApiUrl, String token, String paymentIdentifier, int pageSize, int pageOffset) throws ApiException {
        try {
            log.info("Getting invoices for payment identifier: {}, pageSize: {}, pageOffset: {}", new Object[]{paymentIdentifier, pageSize, pageOffset});
            String url = String.format("%s/online/Payment/Identifier/GetReferenceNumbers/%s?PageSize=%d&PageOffset=%d", ksefApiUrl, paymentIdentifier, pageSize, pageOffset);
            Request httpRequest = new Request.Builder().url(url).method("GET", null).addHeader("SessionToken", token).build();
            return this.executeRequest(httpRequest, GetPaymentIdentifierReferenceNumbersResponse.class);
        }
        catch (Exception e) {
            log.error("Error getting invoices for payment identifier", (Throwable)e);
            throw new ApiException("Failed to get invoices for payment identifier: " + e.getMessage());
        }
    }
}

