/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.service;

import com.suncode.plugin.plusksef.invoice.model.InternalInvoiceModel;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.FakturaV1;
import com.suncode.plugin.plusksef.invoice.model.ksefV2.FakturaV2;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3;
import com.suncode.plugin.plusksef.invoice.service.InvoiceService;
import com.suncode.pwfl.archive.WfFile;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServiceImpl.class);
    private static final String KSEF_SCHEMAT_V1_TAG = "<WariantFormularza>1</WariantFormularza>";
    private static final String KSEF_SCHEMAT_V2_TAG = "<WariantFormularza>2</WariantFormularza>";
    private static final String KSEF_SCHEMAT_V3_TAG = "<WariantFormularza>3</WariantFormularza>";

    @Override
    public boolean isKsefSchematV1(String xmlDocumentString) {
        return xmlDocumentString.contains(KSEF_SCHEMAT_V1_TAG);
    }

    @Override
    public boolean isKsefSchematV2(String xmlDocumentString) {
        return xmlDocumentString.contains(KSEF_SCHEMAT_V2_TAG);
    }

    @Override
    public boolean isKsefSchematV3(String xmlDocumentString) {
        return xmlDocumentString.contains(KSEF_SCHEMAT_V3_TAG);
    }

    @Override
    public InternalInvoiceModel createInternalInvoiceModel(WfFile xmlFile, short expectedSchemaVersion) throws JAXBException, IOException {
        String documentString = new String(Files.readAllBytes(Paths.get(xmlFile.getFullPath(), new String[0])));
        URL xml = Paths.get(xmlFile.getFullPath(), new String[0]).toUri().toURL();
        if (this.isKsefSchematV1(documentString)) {
            if (expectedSchemaVersion != 1) {
                log.warn(String.format("Incompatible version type. Expected schema version: %s. KSeF invoice schema version: 1", expectedSchemaVersion));
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV1.class});
            return new InternalInvoiceModel((FakturaV1)jc.createUnmarshaller().unmarshal(xml));
        }
        if (this.isKsefSchematV2(documentString)) {
            if (expectedSchemaVersion != 2) {
                log.warn(String.format("Incompatible version type. Expected schema version: %s. KSeF invoice schema version: 2", expectedSchemaVersion));
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV2.class});
            return new InternalInvoiceModel((FakturaV2)jc.createUnmarshaller().unmarshal(xml));
        }
        if (this.isKsefSchematV3(documentString)) {
            if (expectedSchemaVersion != 3) {
                log.warn(String.format("Incompatible version type. Expected schema version: %s. KSeF invoice schema version: 3", expectedSchemaVersion));
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FakturaV3.class});
            return new InternalInvoiceModel((FakturaV3)jc.createUnmarshaller().unmarshal(xml));
        }
        throw new IllegalArgumentException("KSeF invoice type undefined");
    }
}

