/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.configuration.service;

import com.google.gson.Gson;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusksef.api.enums.KsefSystemType;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Gson gson = new Gson();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KsefImportConfig readConfigurationFromPCM(String configId) throws IOException {
        Assert.isTrue((boolean)this.configExist(configId), (String)String.format("Config \"%s\" does not exist", configId));
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);){
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            KsefImportConfig ksefImportConfig = (KsefImportConfig)this.gson.fromJson(content, KsefImportConfig.class);
            ksefImportConfig.setConfigId(configId);
            ksefImportConfig.setKsefUrl(KsefSystemType.valueOf(ksefImportConfig.getKsefSystemType()).getUrl());
            KsefImportConfig ksefImportConfig2 = ksefImportConfig;
            return ksefImportConfig2;
        }
    }

    private boolean configExist(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

