/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.service;

import com.google.gson.Gson;
import com.suncode.plugin.plusksef.api.model.ExceptionResponse;
import com.suncode.plugin.plusksef.api.service.ApiException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseKsefService {
    private static final Logger log = LoggerFactory.getLogger(BaseKsefService.class);
    public static final String UNSUCCESSFUL_RESPONSE_MSG = "Unsuccessful response from KSeF";
    public static final String TOKEN_HEADER_NAME = "SessionToken";
    public static final String APPLICATION_JSON = "application/json";
    protected static final OkHttpClient client;
    protected static final MediaType JSON;
    protected static final String POST = "POST";
    protected static final String GET = "GET";
    protected static final String PUT = "PUT";
    protected static final String ACCEPT = "accept";
    protected final Gson gson = new Gson();

    protected <T> T executeRequest(Request request, Class<T> classOfResponse) throws ApiException, IOException {
        log.debug("Executing request: {}", (Object)request.url());
        try (Response response = client.newCall(request).execute();){
            String responseStr;
            String string = responseStr = response.body() != null ? response.body().string() : "";
            if (!response.isSuccessful()) {
                log.warn(responseStr);
                ExceptionResponse exceptionResponse = (ExceptionResponse)this.gson.fromJson(responseStr, ExceptionResponse.class);
                throw new ApiException(UNSUCCESSFUL_RESPONSE_MSG, exceptionResponse.getException().getExceptionDetailList().get(0).getExceptionCode(), exceptionResponse.getException().getExceptionDetailList().get(0).getExceptionDescription());
            }
            log.debug("Response: {}", (Object)responseStr);
            Object object = this.gson.fromJson(responseStr, classOfResponse);
            return (T)object;
        }
    }

    protected <T> RequestBody jsonRequestBody(T body) {
        return RequestBody.create((String)this.gson.toJson(body), (MediaType)MediaType.parse((String)APPLICATION_JSON));
    }

    static {
        JSON = MediaType.get((String)"application/json; charset=utf-8");
        client = new OkHttpClient.Builder().connectTimeout(40L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
    }
}

