/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.model.query.InvoiceQueryResponse;
import com.suncode.plugin.plusksef.api.service.KSeFService;
import com.suncode.plugin.plusksef.api.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesEnum;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.servicie.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.db.servicie.LastInvoiceQueryTimeService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.ImportDocumentsFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@ScheduledTask
public class ImportDocumentsFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportDocumentsFromKSeF.class);
    private static final int QUERY_INVOICE_PAGE_SIZE = 50;
    private static final String LAST_CALL_DATE = "LAST_CALL_DATE";
    private static final String ID = "plusksef.scheduledTask.ImportDocumentsFromKSeF";
    private static final String CONFIG_ID_SEPARATOR = ",";
    private static final String XML_EXTENSION = ".xml";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    @Autowired
    private KSeFService kSeFService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private LastInvoiceQueryTimeService lastInvoiceQueryTimeService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).parameter().id("configIds").name(ID.concat(".param.configIds.name")).description(ID.concat(".param.configIds.desc")).type((Type)Types.STRING).create()).parameter().id("readFromDate").name(ID.concat(".param.readFromDate.name")).description(ID.concat(".param.readFromDate.desc")).type((Type)Types.STRING).create();
    }

    public String execute(@Param String configIds, @Param String readFromDate) {
        ImportDocumentsFromKSeFSummary importDocumentsFromKSeFSummaryInfo = new ImportDocumentsFromKSeFSummary();
        Arrays.stream(configIds.split(CONFIG_ID_SEPARATOR)).filter(config -> !config.isEmpty()).distinct().forEach(configId -> this.processTask((String)configId, readFromDate, importDocumentsFromKSeFSummaryInfo));
        return importDocumentsFromKSeFSummaryInfo.buildSummary();
    }

    public void processTask(String configId, String readInvoiceFromStringParam, ImportDocumentsFromKSeFSummary summary) {
        Timestamp invoiceQueryTime;
        InvoiceQueryResponse invoiceQueryResponse;
        taskLog.debug((Object)("Processing config: " + configId));
        KsefImportConfig config = this.configService.readConfigurationFromPCM(configId);
        SessionInfo sessionInfo = this.kSeFService.getSession(config);
        Date readInvoiceFrom = this.getReadingDateFrom(readInvoiceFromStringParam, config);
        Date readInvoiceTo = this.getReadingDateTo();
        taskLog.debug((Object)String.format("Read invoice from %s to %s", this.dateFormat.format(readInvoiceFrom), this.dateFormat.format(readInvoiceTo)));
        Assert.isTrue((!readInvoiceFrom.after(readInvoiceTo) ? 1 : 0) != 0, (String)"Incorrect date. Date from occurs after Date to");
        int offset = 0;
        do {
            invoiceQueryTime = Timestamp.from(Instant.now());
            invoiceQueryResponse = this.kSeFService.invoiceQuery(config.getKsefUrl(), sessionInfo.getSessionToken(), readInvoiceFrom, readInvoiceTo, 50, offset);
            taskLog.debug((Object)("Found " + invoiceQueryResponse.getInvoiceHeaderList().size() + " documents"));
            summary.increaseProcessedDocuments(invoiceQueryResponse.getInvoiceHeaderList().size());
            for (InvoiceQueryResponse.InvoiceHeader invoiceHeader : invoiceQueryResponse.getInvoiceHeaderList()) {
                this.loadDocument(invoiceHeader, sessionInfo.getSessionToken(), config, summary);
            }
            offset += 50;
        } while (invoiceQueryResponse.getInvoiceHeaderList().size() >= 50);
        this.lastInvoiceQueryTimeService.addInfo(config.getNip(), config.getKsefSystemType(), invoiceQueryTime);
    }

    private Date getReadingDateFrom(String readInvoiceFromStringParam, KsefImportConfig config) throws ParseException {
        Date readInvoiceFrom;
        Date date = readInvoiceFrom = readInvoiceFromStringParam.equals(LAST_CALL_DATE) ? this.lastInvoiceQueryTimeService.getTimeOfLastCall(config.getNip(), config.getKsefSystemType()) : this.dateFormat.parse(readInvoiceFromStringParam);
        if (readInvoiceFrom == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            readInvoiceFrom = cal.getTime();
        }
        return readInvoiceFrom;
    }

    private Date getReadingDateTo() {
        return this.addHoursToDate(new Date(), 1);
    }

    private Date addHoursToDate(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    private void loadDocument(InvoiceQueryResponse.InvoiceHeader invoiceHeader, String sessionToken, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        if (this.importedDocumentTableService.isLoaded(invoiceHeader.getKsefReferenceNumber())) {
            taskLog.debug((Object)("SKIP document: " + invoiceHeader.getKsefReferenceNumber()));
            summary.increaseSkippedDocuments();
            return;
        }
        byte[] invoice = this.kSeFService.getInvoice(config.getKsefUrl(), invoiceHeader.getKsefReferenceNumber(), sessionToken);
        taskLog.debug((Object)("Load document: " + invoiceHeader.getKsefReferenceNumber()));
        Map<Long, Object> indexes = this.createIndexesMap(invoiceHeader, config);
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(config.getDocumentClassId(), invoiceHeader.getKsefReferenceNumber() + XML_EXTENSION, invoice, indexes, true);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        this.importedDocumentTableService.addInfo(config.getNip(), config.getConfigId(), config.getKsefSystemType(), invoiceHeader.getKsefReferenceNumber(), wfDocument.getFile().getId());
        summary.increaseLoadDocuments();
    }

    private Map<Long, Object> createIndexesMap(InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        config.getMappings().stream().forEach(mapping -> indexes.put(mapping.getDocClassIndex(), this.getIndexValue(mapping.getKsefParam(), invoiceHeader, config)));
        indexes.values().removeIf(Objects::isNull);
        return indexes;
    }

    private Object getIndexValue(String key, InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        switch (MappingsForIndexesEnum.enumByKey(key)) {
            case SUBJECT_BY_NAME: {
                return invoiceHeader.getSubjectBy().getIssuedByName() != null ? invoiceHeader.getSubjectBy().getIssuedByName().getFullName() : null;
            }
            case SUBJECT_BY_NIP: {
                return invoiceHeader.getSubjectBy().getIssuedByIdentifier() != null ? invoiceHeader.getSubjectBy().getIssuedByIdentifier().getIdentifier() : null;
            }
            case SUBJECT_TO_NAME: {
                return invoiceHeader.getSubjectTo().getIssuedToName() != null ? invoiceHeader.getSubjectTo().getIssuedToName().getFullName() : null;
            }
            case SUBJECT_TO_NIP: {
                return invoiceHeader.getSubjectTo().getIssuedToIdentifier() != null ? invoiceHeader.getSubjectTo().getIssuedToIdentifier().getIdentifier() : null;
            }
            case CONFIG_ID: {
                return config.getConfigId();
            }
            case CONFIG_NIP: {
                return config.getNip();
            }
            case CONFIG_SYSTEM_TYPE: {
                return config.getKsefSystemType();
            }
        }
        return ((Map)new ObjectMapper().convertValue((Object)invoiceHeader, Map.class)).get(key);
    }
}

