/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.model;

import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV1;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV2;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.FakturaV1;
import com.suncode.plugin.plusksef.invoice.model.ksefV2.FakturaV2;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalInvoiceModel {
    private static final Logger log = LoggerFactory.getLogger(InternalInvoiceModel.class);
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();

    public InternalInvoiceModel(FakturaV1 faktura) {
        KsefKeysV1.stream().forEach(ksefKey -> {
            try {
                this.data.put(ksefKey.getKey(), ksefKey.getValue(faktura));
            }
            catch (Exception e) {
                log.warn("Key reading problem:" + ksefKey.getKey() + ". Error msg:" + e.getMessage());
            }
        });
    }

    public InternalInvoiceModel(FakturaV2 faktura) {
        KsefKeysV2.stream().forEach(ksefKey -> {
            try {
                this.data.put(ksefKey.getKey(), ksefKey.getValue(faktura));
            }
            catch (Exception e) {
                log.warn("Key reading problem:" + ksefKey.getKey() + ". Error msg:" + e.getMessage());
            }
        });
    }

    public InternalInvoiceModel(FakturaV3 faktura) {
        KsefKeysV3.stream().forEach(ksefKey -> {
            try {
                this.data.put(ksefKey.getKey(), ksefKey.getValue(faktura));
            }
            catch (Exception e) {
                log.warn("Key reading problem:" + ksefKey.getKey() + ". Error msg:" + e.getMessage());
            }
        });
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

