/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.variable.Variable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GenerateKsefDocumentPreview/pwe_dynamic_form.js")
public class GenerateKsefDocumentPreview {
    private static final String ID = "plusksef.autotask.GenerateKsefDocumentPreview";
    @Autowired
    private FileService fileService;
    @Autowired
    KsefDocumentService ksefDocumentService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.SETTINGS)).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("targetFormat").name(ID.concat(".param.targetFormat.name")).description(ID.concat(".param.targetFormat.desc")).type((Type)Types.STRING).create()).parameter().id("addQrCode").name(ID.concat(".param.addQrCode.name")).description(ID.concat(".param.addQrCode.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("addDocumentToProcess").name(ID.concat(".param.addDocumentToProcess.name")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("saveAsNewVersion").name(ID.concat(".param.saveAsNewVersion.name")).description(ID.concat(".param.saveAsNewVersion.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("executeDocumentAction").name(ID.concat(".param.executeDocumentAction.name")).description(ID.concat(".param.executeDocumentAction.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("variableToSaveFileId").name(ID.concat(".param.variableToSaveFileId.name")).description(ID.concat(".param.variableToSaveFileId.desc")).type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param Integer fileId, @Param String documentClassName, @Param String targetFormat, @Param Boolean addQrCode, @Param Boolean addDocumentToProcess, @Param Boolean saveAsNewVersion, @Param Variable variableToSaveFileId, @Param Boolean executeDocumentAction, WorkflowContext context) throws Exception {
        Assert.isTrue((targetFormat.equals("PDF") || targetFormat.equals("HTML") ? 1 : 0) != 0, (String)"Incorrect destination format. Possible values are: PDF, HTML.");
        WfFile wfFile = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]);
        this.ksefDocumentService.validateKsefFile(wfFile);
        String htmlDocument = this.ksefDocumentService.generateHtmlDocumentFromKsefXml(wfFile, false, addQrCode);
        byte[] documentBytes = targetFormat.equals("PDF") ? this.ksefDocumentService.generatePdfDocumentFromHtml(htmlDocument).toByteArray() : htmlDocument.getBytes(StandardCharsets.UTF_8);
        String newFileName = FilenameUtils.removeExtension((String)wfFile.getFileName()) + '.' + targetFormat.toLowerCase();
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, newFileName, documentBytes, null, (boolean)saveAsNewVersion, (boolean)addDocumentToProcess, context.getActivityId(), context.getProcessId(), null);
        if (Boolean.TRUE.equals(executeDocumentAction)) {
            this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        }
        if (variableToSaveFileId != null) {
            variableToSaveFileId.setValue((Object)wfDocument.getFile().getId());
        }
    }
}

