﻿window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.url.name",
            help: "plusksef.pcm.schema.params.url.desc",
            model: "ksefSystemType",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-ksef/config/systemTypes', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                        },
                        async: false
                    }
                );
                return data
            }
        },
        {
            type: "input",
            inputType: "text",
            label: "plusksef.pcm.schema.params.nip.name",
            help: "plusksef.pcm.schema.params.nip.desc",
            model: "nip",
            required: true,
            min: 10,
            validator: "string"
        },
        {
            type: "input",
            inputType: "password",
            label: "plusksef.pcm.schema.params.token.name",
            help: "plusksef.pcm.schema.params.token.desc",
            model: "tokenAuth",
            required: true,
            validator: "string"
        },
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.documentClassName.name",
            model: "documentClassId",
            required: "true",
            values: function (model) {
                let data;
                window.vfgFileSchemaHeaderModel = model;
                jQuery.ajax({
                    url: 'api/documents/classes', success: function (result) {
                        data = result.map(row => ({id: row.id, name: row.name}))
                            .sort((a, b) => a.name.localeCompare(b.name));
                    },
                    async: false
                });
                return data
            },
            validator: "integer",
            placeholder: "plusksef.pcm.schema.params.documentClassName.placeholder"
        },
        {
            type: "field-array",
            model: "mappings",
            schema: {
                fields: [
                    {
                        type: "select",
                        inputType: "text",
                        label: "plusksef.pcm.schema.params.ksefParam.name",
                        model: "ksefParam",
                        values: function () {
                            let data;
                            jQuery.ajax({
                                    url: 'plugin/com.suncode.plugin-plus-ksef/config/mappingParams', success: function (result) {
                                        data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                                            .sort((a, b) => a.name.localeCompare(b.name));
                                    },
                                    async: false
                                }
                            );
                            return data
                        },
                    },
                    {
                        type: "select",
                        inputType: "text",
                        label: "plusksef.pcm.schema.params.docClassIndex.name",
                        model: "docClassIndex",
                        required: "true",
                        values: function () {
                            let data;
                            jQuery.ajax({
                                    url: 'api/documents/indexes/' + window.vfgFileSchemaHeaderModel.documentClassId,
                                    success: function (result) {
                                        data = result.map(row => ({id: row.id, name: row.name}))
                                            .sort((a, b) => a.name.localeCompare(b.name));
                                    },
                                    async: false
                                }
                            );
                            return data
                        },
                        validator: "integer"
                    }
                ]
            }
        }
    ]
}