/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.model.invoice.InvoiceStatusResponse;
import com.suncode.plugin.plusksef.api.service.KSeFService;
import com.suncode.plugin.plusksef.api.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.scheduledtask.LoadInvoiceStatusFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class LoadInvoiceStatusFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(LoadInvoiceStatusFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.LoadInvoiceStatusFromKSeF";
    @Autowired
    private KSeFService ksEFService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("referenceNumberVariableId").name(ID.concat(".param.referenceNumberVariableId.name")).description(ID.concat(".param.referenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).create()).parameter().id("invoiceStatusVariableId").name(ID.concat(".param.invoiceStatusVariable.name")).description(ID.concat(".param.invoiceStatusVariable.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumberVariableId").name(ID.concat(".param.ksefReferenceNumberVariableId.name")).description(ID.concat(".param.ksefReferenceNumberVariableId.desc")).type((Type)Types.STRING).create();
    }

    public String execute(@Param String configId, @Param String processDefId, @Param String activityDefId, @Param(value="referenceNumberVariableId") String elementReferenceNumberVariableId, @Param String actionId, @Param String invoiceStatusVariableId, @Param String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary = new LoadInvoiceStatusFromKSeFSummary();
            loadInvoiceStatusFromKSeFSummary.setNumberOfDocumentsFound(activities.size());
            SessionInfo sessionInfo = this.ksEFService.getSession(ksefImportConfig);
            for (Activity activity : activities) {
                this.updateActivity(elementReferenceNumberVariableId, actionId, invoiceStatusVariableId, ksefReferenceNumberVariableId, logger, ksefImportConfig, loadInvoiceStatusFromKSeFSummary, sessionInfo.getSessionToken(), activity);
            }
            return loadInvoiceStatusFromKSeFSummary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void updateActivity(String elementReferenceNumberVariableId, String actionId, String invoiceStatusVariableId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger, KsefImportConfig ksefImportConfig, LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary, String sessionToken, Activity activity) {
        try {
            logger.debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
            loadInvoiceStatusFromKSeFSummary.increaseProcessedDocuments();
            Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String elementReferenceNumber = activityContext.get(elementReferenceNumberVariableId).toString();
            String sessionReferenceNumber = this.exportedDocumentTableService.getRowByElementReferenceNumber(elementReferenceNumber).getReferenceNumber();
            logger.debug((Object)String.format("Session reference number: %s. Element reference number: %s.", sessionReferenceNumber, elementReferenceNumber));
            InvoiceStatusResponse invoiceStatusResponse = this.ksEFService.loadInvoiceStatus(ksefImportConfig.getKsefUrl(), sessionToken, elementReferenceNumber);
            logger.debug((Object)String.format("Processing code: %s. Processing description: %s", invoiceStatusResponse.getProcessingCode(), invoiceStatusResponse.getProcessingDescription()));
            if (invoiceStatusResponse.getProcessingCode() == 200) {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription(), invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
                activityContext.put(invoiceStatusVariableId, "OK");
                activityContext.put(ksefReferenceNumberVariableId, invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
            } else {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription(), null);
                activityContext.put(invoiceStatusVariableId, invoiceStatusResponse.getProcessingDescription());
            }
            this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
            loadInvoiceStatusFromKSeFSummary.increaseAcceptInvoiceProcess();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            loadInvoiceStatusFromKSeFSummary.increaseErrors();
        }
    }
}

