/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.hook;

import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.plugin.plusksef.invoice.service.InvoiceService;
import com.suncode.pwfl.hook.annotation.Hook;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileHookAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Hook
public class KSeFInvoiceHook
extends ReadFileHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(KSeFInvoiceHook.class);
    @Autowired
    InvoiceService invoiceService;
    @Autowired
    KsefDocumentService ksefDocumentService;

    public OpenedFileContext execute(OpenedFileContext openedFileContext) {
        block5: {
            byte[] documentBytes = new byte[]{};
            try {
                if (!openedFileContext.getExtension().equalsIgnoreCase("xml")) {
                    return openedFileContext;
                }
                documentBytes = IOUtils.toByteArray((InputStream)openedFileContext.getInputStream());
                if (this.ksefDocumentService.isKsefXmlDocument(documentBytes)) {
                    String xmlString = new String(documentBytes, StandardCharsets.UTF_8);
                    String htmlString = this.ksefDocumentService.generateHtmlDocumentFromKsefXml(xmlString, true, true, openedFileContext.getWfFile().getId());
                    openedFileContext.setExtension("html");
                    openedFileContext.setMimeType("text/html; charset=UTF-8");
                    openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(htmlString.getBytes(StandardCharsets.UTF_8)));
                } else {
                    openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(documentBytes));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (documentBytes.length <= 0) break block5;
                openedFileContext.setInputStream((InputStream)new ByteArrayInputStream(documentBytes));
            }
        }
        return openedFileContext;
    }
}

