/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.model.payment.GetPaymentIdentifiersByKSeFNumberResponse;
import com.suncode.plugin.plusksef.api.model.payment.PaymentIdentifierType;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierRequest;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierResponse;
import com.suncode.plugin.plusksef.api.model.payment.RequestPaymentIdentifierStatusResponse;
import com.suncode.plugin.plusksef.api.service.KSeFService;
import com.suncode.plugin.plusksef.api.service.PaymentService;
import com.suncode.plugin.plusksef.api.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/RequestPaymentIdentifier/pwe_dynamic_form.js")
public class RequestPaymentIdentifier {
    private static final Logger log = LoggerFactory.getLogger(RequestPaymentIdentifier.class);
    private static final String ID = "plusksef.autotask.RequestPaymentIdentifier";
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KSeFService ksEFService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.MONEY)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("invoiceNumbers").name(ID.concat(".param.invoiceNumbers.name")).description(ID.concat(".param.invoiceNumbers.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("paymentIdentifier").name(ID.concat(".param.paymentIdentifier.name")).description(ID.concat(".param.paymentIdentifier.desc")).type((Type)Types.VARIABLE).create()).parameter().id("paymentIdentifierCreateAt").name(ID.concat(".param.paymentIdentifierCreateAt.name")).description(ID.concat(".param.paymentIdentifierCreateAt.desc")).type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param String configId, @Param String[] invoiceNumbers, @Param Variable paymentIdentifier, @Param Variable paymentIdentifierCreateAt) throws AcceptanceException {
        try {
            log.info("Requesting payment identifier for invoices from config: {}", (Object)configId);
            Assert.isTrue((configId != null || !configId.trim().isEmpty() ? 1 : 0) != 0, (String)"Configuration ID is required");
            Assert.isTrue((invoiceNumbers != null ? 1 : 0) != 0, (String)"Invoice numbers list is required");
            Assert.isTrue((invoiceNumbers.length >= 2 ? 1 : 0) != 0, (String)"Invoice numbers must contain at least 2 invoice numbers");
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            SessionInfo sessionInfo = this.ksEFService.getSession(ksefImportConfig);
            List<String> invoiceNumbersList = Arrays.asList(invoiceNumbers);
            Assert.isTrue((!invoiceNumbersList.isEmpty() ? 1 : 0) != 0, (String)"No valid invoice numbers found in the input");
            log.info("Processing {} invoice numbers: {}", (Object)invoiceNumbersList.size(), invoiceNumbersList);
            RequestPaymentIdentifierRequest paymentIdentifierRequest = new RequestPaymentIdentifierRequest(invoiceNumbersList);
            RequestPaymentIdentifierResponse paymentIdentifierResponse = this.paymentService.requestPaymentIdentifier(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), paymentIdentifierRequest);
            String paymentElementReferenceNumber = paymentIdentifierResponse.getElementReferenceNumber();
            log.info("Waiting for payment element reference number: {}", (Object)paymentElementReferenceNumber);
            this.waitForPaymentNumberGenerationToFinish(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), paymentElementReferenceNumber);
            GetPaymentIdentifiersByKSeFNumberResponse paymentIdentifiersForInvoice = this.paymentService.getPaymentIdentifiersForInvoice(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), invoiceNumbersList.get(0), 100, 0);
            List<PaymentIdentifierType> paymentIdentifiersList = paymentIdentifiersForInvoice.getPaymentIdentifiersList();
            Collections.sort(paymentIdentifiersList, (o1, o2) -> o2.getCreatedAt().compareTo(o1.getCreatedAt()));
            String paymentIdentifierString = paymentIdentifiersList.get(0).getPaymentIdentifier();
            String createdAt = paymentIdentifiersList.get(0).getCreatedAt();
            LocalDateTime createdAtLocalDateTime = new LocalDateTime((Object)Instant.parse((String)createdAt), DateTimeZone.getDefault());
            log.info("Generated payment identifier: {} with creation date: {}", (Object)paymentIdentifierString, (Object)createdAtLocalDateTime);
            paymentIdentifier.setValue((Object)paymentIdentifierString);
            paymentIdentifierCreateAt.setValue((Object)createdAtLocalDateTime);
        }
        catch (IOException e) {
            log.error("Network error while requesting payment identifier", (Throwable)e);
            throw new AcceptanceException("Network error occurred: " + e.getMessage());
        }
        catch (Exception e) {
            log.error("Error requesting payment identifier for config: {}", (Object)configId, (Object)e);
            throw new AcceptanceException(e.getMessage());
        }
    }

    private void waitForPaymentNumberGenerationToFinish(String ksefUrl, String sessionToken, String paymentElementReferenceNumber) throws IOException {
        int maxRetries = 10;
        int retryInterval = 10000;
        for (int i = 0; i < maxRetries; ++i) {
            try {
                Thread.sleep(retryInterval);
                RequestPaymentIdentifierStatusResponse statusResponse = this.paymentService.getPaymentIdentifierStatus(ksefUrl, sessionToken, paymentElementReferenceNumber);
                if (statusResponse.getProcessingCode() == 200) {
                    log.info("Payment element reference number {} status is now 200 (Process completed).", (Object)paymentElementReferenceNumber);
                    return;
                }
                log.info("Payment element reference number {} status is {} ({}). Attempt {}/{}", new Object[]{paymentElementReferenceNumber, statusResponse.getProcessingCode(), statusResponse.getProcessingDescription(), i + 1, maxRetries});
                continue;
            }
            catch (Exception e) {
                log.warn("Error checking payment identifier status on attempt {}/{}. Error: {}", new Object[]{i + 1, maxRetries, e.getMessage()});
            }
        }
        throw new IOException("Payment element reference number " + paymentElementReferenceNumber + " did not reach status 200 (Process registered) within " + maxRetries + " retries.");
    }
}

