/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.model.invoice;

import java.beans.ConstructorProperties;

public class SendInvoiceRequest {
    private InvoiceHash invoiceHash;
    private InvoicePayload invoicePayload;

    public static SendInvoiceRequestBuilder builder() {
        return new SendInvoiceRequestBuilder();
    }

    public InvoiceHash getInvoiceHash() {
        return this.invoiceHash;
    }

    public InvoicePayload getInvoicePayload() {
        return this.invoicePayload;
    }

    public void setInvoiceHash(InvoiceHash invoiceHash) {
        this.invoiceHash = invoiceHash;
    }

    public void setInvoicePayload(InvoicePayload invoicePayload) {
        this.invoicePayload = invoicePayload;
    }

    @ConstructorProperties(value={"invoiceHash", "invoicePayload"})
    public SendInvoiceRequest(InvoiceHash invoiceHash, InvoicePayload invoicePayload) {
        this.invoiceHash = invoiceHash;
        this.invoicePayload = invoicePayload;
    }

    public SendInvoiceRequest() {
    }

    public static class SendInvoiceRequestBuilder {
        private InvoiceHash invoiceHash;
        private InvoicePayload invoicePayload;

        SendInvoiceRequestBuilder() {
        }

        public SendInvoiceRequestBuilder invoiceHash(InvoiceHash invoiceHash) {
            this.invoiceHash = invoiceHash;
            return this;
        }

        public SendInvoiceRequestBuilder invoicePayload(InvoicePayload invoicePayload) {
            this.invoicePayload = invoicePayload;
            return this;
        }

        public SendInvoiceRequest build() {
            return new SendInvoiceRequest(this.invoiceHash, this.invoicePayload);
        }

        public String toString() {
            return "SendInvoiceRequest.SendInvoiceRequestBuilder(invoiceHash=" + this.invoiceHash + ", invoicePayload=" + this.invoicePayload + ")";
        }
    }

    public static class InvoiceHash {
        private HashSHA hashSHA;
        private int fileSize;

        public static InvoiceHashBuilder builder() {
            return new InvoiceHashBuilder();
        }

        public HashSHA getHashSHA() {
            return this.hashSHA;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public void setHashSHA(HashSHA hashSHA) {
            this.hashSHA = hashSHA;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        @ConstructorProperties(value={"hashSHA", "fileSize"})
        public InvoiceHash(HashSHA hashSHA, int fileSize) {
            this.hashSHA = hashSHA;
            this.fileSize = fileSize;
        }

        public InvoiceHash() {
        }

        public static class InvoiceHashBuilder {
            private HashSHA hashSHA;
            private int fileSize;

            InvoiceHashBuilder() {
            }

            public InvoiceHashBuilder hashSHA(HashSHA hashSHA) {
                this.hashSHA = hashSHA;
                return this;
            }

            public InvoiceHashBuilder fileSize(int fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public InvoiceHash build() {
                return new InvoiceHash(this.hashSHA, this.fileSize);
            }

            public String toString() {
                return "SendInvoiceRequest.InvoiceHash.InvoiceHashBuilder(hashSHA=" + this.hashSHA + ", fileSize=" + this.fileSize + ")";
            }
        }

        public static class HashSHA {
            private String algorithm;
            private String encoding;
            private String value;

            public static HashSHABuilder builder() {
                return new HashSHABuilder();
            }

            public String getAlgorithm() {
                return this.algorithm;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public String getValue() {
                return this.value;
            }

            public void setAlgorithm(String algorithm) {
                this.algorithm = algorithm;
            }

            public void setEncoding(String encoding) {
                this.encoding = encoding;
            }

            public void setValue(String value) {
                this.value = value;
            }

            @ConstructorProperties(value={"algorithm", "encoding", "value"})
            public HashSHA(String algorithm, String encoding, String value) {
                this.algorithm = algorithm;
                this.encoding = encoding;
                this.value = value;
            }

            public HashSHA() {
            }

            public static class HashSHABuilder {
                private String algorithm;
                private String encoding;
                private String value;

                HashSHABuilder() {
                }

                public HashSHABuilder algorithm(String algorithm) {
                    this.algorithm = algorithm;
                    return this;
                }

                public HashSHABuilder encoding(String encoding) {
                    this.encoding = encoding;
                    return this;
                }

                public HashSHABuilder value(String value) {
                    this.value = value;
                    return this;
                }

                public HashSHA build() {
                    return new HashSHA(this.algorithm, this.encoding, this.value);
                }

                public String toString() {
                    return "SendInvoiceRequest.InvoiceHash.HashSHA.HashSHABuilder(algorithm=" + this.algorithm + ", encoding=" + this.encoding + ", value=" + this.value + ")";
                }
            }
        }
    }

    public static class InvoicePayload {
        private String type;
        private String invoiceBody;

        public static InvoicePayloadBuilder builder() {
            return new InvoicePayloadBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getInvoiceBody() {
            return this.invoiceBody;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setInvoiceBody(String invoiceBody) {
            this.invoiceBody = invoiceBody;
        }

        @ConstructorProperties(value={"type", "invoiceBody"})
        public InvoicePayload(String type, String invoiceBody) {
            this.type = type;
            this.invoiceBody = invoiceBody;
        }

        public InvoicePayload() {
        }

        public static class InvoicePayloadBuilder {
            private String type;
            private String invoiceBody;

            InvoicePayloadBuilder() {
            }

            public InvoicePayloadBuilder type(String type) {
                this.type = type;
                return this;
            }

            public InvoicePayloadBuilder invoiceBody(String invoiceBody) {
                this.invoiceBody = invoiceBody;
                return this;
            }

            public InvoicePayload build() {
                return new InvoicePayload(this.type, this.invoiceBody);
            }

            public String toString() {
                return "SendInvoiceRequest.InvoicePayload.InvoicePayloadBuilder(type=" + this.type + ", invoiceBody=" + this.invoiceBody + ")";
            }
        }
    }
}

