/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.plusksef.api.enums.KsefSystemType;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.entity.ImportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.db.servicie.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.SystemContext;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

@Service
public class KsefDocumentServiceImpl
implements KsefDocumentService {
    private static final Logger log = LoggerFactory.getLogger(KsefDocumentServiceImpl.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;
    private static final ClassLoader CLASS_LOADER = KsefDocumentServiceImpl.class.getClassLoader();
    private static final String ARIAL_FONT_URL = "fonts/Arial.ttf";
    private static final String HOME_DIRECTORY = "plusworkflow.home";
    private static final String DEFAULT_SCHEMA_DIRECTORY_TEMPLATE = "files/ksef/v%d/";
    private static final String CUSTOM_SCHEMA_DIRECTORY_TEMPLATE = "files/ksef_custom/v%d/";
    private static final String SCHEMA_FILE_NAME = "styl.xsl";
    private static final String KSEF_DOCUMENT_MARKER = "<KodFormularza kodSystemowy=\"FA";
    private static final String XML_HEADER = "<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->";
    private static final String DOCTYPE_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";

    @Override
    public String generateHtmlDocumentFromKsefXml(String xmlDocumentString, boolean addDownloadButtons, boolean addQRCode, long fileId) throws Exception {
        org.w3c.dom.Document xmlDocument = this.secureParseXml(xmlDocumentString);
        int formVariant = this.extractFormVariant(xmlDocument);
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        compiler.setSchemaAware(false);
        XsltExecutable stylesheet = compiler.compile((Source)new StreamSource(this.getStylePath(formVariant).toString()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Xslt30Transformer transformer = stylesheet.load30();
        this.addKsefSchemaResolver(transformer);
        byte[] xmlBytes = xmlDocumentString.getBytes(StandardCharsets.UTF_8);
        DOMSource xmlStream = new DOMSource(xmlDocument);
        Serializer serializer = processor.newSerializer((OutputStream)byteArrayOutputStream);
        serializer.setOutputProperty(Serializer.Property.ENCODING, "UTF-8");
        transformer.transform((Source)xmlStream, (Destination)serializer);
        String result = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        String htmlString = KsefDocumentServiceImpl.removeEmptyColumns(result).toString(StandardCharsets.UTF_8.name());
        htmlString = KsefDocumentServiceImpl.addHtmlHeaders(htmlString);
        if (addDownloadButtons) {
            htmlString = this.addDownloadButtonsToHtmlDocument(htmlString, fileId);
        }
        if (addQRCode) {
            htmlString = this.addQrCodeToHtml(htmlString, xmlBytes, fileId);
        }
        return htmlString;
    }

    private void addKsefSchemaResolver(Xslt30Transformer transformer) {
        transformer.setURIResolver((href, base) -> {
            if ("true".equals(href)) {
                StringReader emptyXml = new StringReader("<root/>");
                return new StreamSource(emptyXml);
            }
            return null;
        });
    }

    private org.w3c.dom.Document secureParseXml(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        xml = xml.trim();
        xml = this.removeBom(xml);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(new StringReader(xml)));
    }

    public String removeBom(String text) {
        if (text != null && text.startsWith("\ufeff")) {
            return text.substring(1);
        }
        return text;
    }

    @Override
    public String generateHtmlDocumentFromKsefXml(WfFile ksefXmlFile, boolean addDownloadButtons, boolean addQRCode) throws Exception {
        byte[] xmlBytes = Files.readAllBytes(Paths.get(ksefXmlFile.getFullPath(), new String[0]));
        return this.generateHtmlDocumentFromKsefXml(new String(xmlBytes, StandardCharsets.UTF_8), addDownloadButtons, addQRCode, ksefXmlFile.getId());
    }

    @Override
    public ByteArrayOutputStream generatePdfDocumentFromHtml(String inputHTML) throws IOException {
        Document document = Jsoup.parse((String)inputHTML, (String)StandardCharsets.UTF_8.name());
        document.outputSettings().syntax(Document.OutputSettings.Syntax.html);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PdfRendererBuilder pdfRendererBuilder = new PdfRendererBuilder();
        pdfRendererBuilder.useFont(() -> CLASS_LOADER.getResourceAsStream(ARIAL_FONT_URL), "Arial");
        pdfRendererBuilder.toStream((OutputStream)byteArrayOutputStream);
        pdfRendererBuilder.withW3cDocument(new W3CDom().fromJsoup(document), "/");
        pdfRendererBuilder.useDefaultPageSize(297.0f, 420.0f, BaseRendererBuilder.PageSizeUnits.MM);
        pdfRendererBuilder.usePdfAConformance(PdfRendererBuilder.PdfAConformance.PDFA_3_A);
        pdfRendererBuilder.run();
        return byteArrayOutputStream;
    }

    @Override
    public boolean isKsefXmlDocument(byte[] documentBytes) {
        String documentString = new String(documentBytes, StandardCharsets.UTF_8);
        return documentString.contains(KSEF_DOCUMENT_MARKER);
    }

    @Override
    public void validateKsefFile(WfFile file) throws IllegalArgumentException, IOException {
        String inputFileExtension = FilenameUtils.getExtension((String)file.getFileName());
        Assert.isTrue((boolean)inputFileExtension.equalsIgnoreCase("xml"), (String)"Incorrect file extension. Required file in xml format.");
        byte[] xmlBytes = Files.readAllBytes(Paths.get(file.getFullPath(), new String[0]));
        Assert.isTrue((boolean)this.isKsefXmlDocument(xmlBytes), (String)"The indicated xml file is not a ksef invoice.");
    }

    private String addQrCodeToHtml(String htmlString, byte[] xmlDocumentBytes, Long fileId) throws NoSuchAlgorithmException, IOException, WriterException {
        Optional<ImportedDocumentTableEntity> importedDocumentInfo = this.importedDocumentTableService.getEntity(fileId);
        if (importedDocumentInfo.isPresent()) {
            htmlString = this.addQrCodeToKsefHtml(xmlDocumentBytes, htmlString, importedDocumentInfo.get().getKsefReferenceNumber(), KsefSystemType.valueOf(importedDocumentInfo.get().getSystemType()));
        } else {
            Optional<ExportedDocumentTableEntity> exportedDocumentInfo = this.exportedDocumentTableService.getEntity(fileId);
            if (exportedDocumentInfo.isPresent()) {
                htmlString = this.addQrCodeToKsefHtml(xmlDocumentBytes, htmlString, exportedDocumentInfo.get().getKsefReferenceNumber(), KsefSystemType.valueOf(exportedDocumentInfo.get().getSystemType()));
            }
        }
        return htmlString;
    }

    public String addDownloadButtonsToHtmlDocument(String ksefHtmlDocument, long fileId) {
        String htmlString = StringEscapeUtils.unescapeHtml4((String)ksefHtmlDocument);
        Document document = Jsoup.parse((String)htmlString);
        String buttonsCss = "<style>.suncode-download-button {  background-color: #FFAE50;  margin: 2px;  color: white;  padding: 5px 10px;  text-align: center;  text-decoration: none;  display: inline-block;  font-size: 16px;}</style>";
        String buttonsDiv = "<div id='buttons'><a href = \"<systemPath>/plugin/<pluginId>/documents/get/xml/<ksefFileId>\" Download class=\"suncode-download-button\">XML</a><a href = \"<systemPath>/plugin/<pluginId>/documents/get/html/<ksefFileId>\" Download class=\"suncode-download-button\">HTML</a><a href = \"<systemPath>/plugin/<pluginId>/documents/get/pdf/<ksefFileId>\" Download class=\"suncode-download-button\">PDF</a></div>";
        buttonsDiv = buttonsDiv.replace("<ksefFileId>", String.valueOf(fileId)).replace("<systemPath>", this.removeLastSlash(SystemContext.get().getAbsolutePath(""))).replace("<pluginId>", this.plugin.getKey());
        document.head().append(buttonsCss);
        document.body().firstElementSibling().before(buttonsDiv);
        return document.toString();
    }

    private String removeLastSlash(String str) {
        return StringUtils.trimTrailingCharacter((String)str, (char)'/');
    }

    private Path getStylePath(int wariantFormularza) {
        String defaultSchemaDirectory = String.format(DEFAULT_SCHEMA_DIRECTORY_TEMPLATE, wariantFormularza);
        String customSchemaDirectory = String.format(CUSTOM_SCHEMA_DIRECTORY_TEMPLATE, wariantFormularza);
        return Paths.get(System.getProperty(HOME_DIRECTORY), this.customStyleExist(wariantFormularza) ? customSchemaDirectory : defaultSchemaDirectory, SCHEMA_FILE_NAME);
    }

    private int extractFormVariant(org.w3c.dom.Document document) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression expression = xpath.compile("//WariantFormularza/text()");
        String wariantStr = (String)expression.evaluate(document, XPathConstants.STRING);
        if (wariantStr != null && !wariantStr.trim().isEmpty()) {
            try {
                return Integer.parseInt(wariantStr.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public String addQrCodeToKsefHtml(byte[] xmlDocumentBytes, String html, String ksefDocumentNumber, KsefSystemType ksefSystemType) throws NoSuchAlgorithmException, IOException, WriterException {
        String hash = this.generateHashFromXml(xmlDocumentBytes);
        String link = ksefSystemType.getUrl().replace("/api", "/web/verify/") + ksefDocumentNumber + "/" + hash;
        Translator translator = Translators.get((String)this.plugin.getKey());
        Document document = KsefDocumentServiceImpl.getDocument(html);
        BufferedImage testImg = this.generateQRCodeImage(link);
        String bottomInfoPanel = "<span><h2 style='text-align:left' class='naglowek'>" + translator.getMessage("document.hook.QrCodeDesc1") + "</h2></span>";
        bottomInfoPanel = bottomInfoPanel + "<div style=\"float: left; width: 40%;\">";
        bottomInfoPanel = bottomInfoPanel + "<img src='data:image/png;base64," + this.imgToBase64String(testImg, "png") + "' style='height:207px; top:10px'/>";
        bottomInfoPanel = bottomInfoPanel + "<h4 style='text-align:left'><b>" + ksefDocumentNumber + "</b></h4>";
        bottomInfoPanel = bottomInfoPanel + "</div>";
        bottomInfoPanel = bottomInfoPanel + "<div style=\"float: left; width: 60%; margin-top: 70px;\">";
        bottomInfoPanel = bottomInfoPanel + "<span class=\"label-data-info--name\">" + translator.getMessage("document.hook.QrCodeDesc2") + "<br> </span>";
        bottomInfoPanel = bottomInfoPanel + "<a style=\"text-decoration: none;\" target=\"_blank\" href=\"" + link + "\">" + link + "</a>";
        bottomInfoPanel = bottomInfoPanel + "</div></div>";
        document.body().lastElementSibling().after(bottomInfoPanel);
        return KsefDocumentServiceImpl.documentToByteArrayOutputStream(document).toString(StandardCharsets.UTF_8.name());
    }

    private String generateHashFromXml(byte[] xmlDocumentBytes) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(xmlDocumentBytes);
        String hash = Base64.getEncoder().encodeToString(digest);
        hash = URLEncoder.encode(hash, StandardCharsets.UTF_8.toString());
        return hash;
    }

    private BufferedImage generateQRCodeImage(String barcodeText) throws WriterException {
        BitMatrix bitMatrix = new QRCodeWriter().encode(barcodeText, BarcodeFormat.QR_CODE, 260, 260);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    private String imgToBase64String(RenderedImage img, String formatName) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write(img, formatName, os);
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    private boolean customStyleExist(int wariantFormularza) {
        String customSchemaDirectory = String.format(CUSTOM_SCHEMA_DIRECTORY_TEMPLATE, wariantFormularza);
        return Files.exists(Paths.get(System.getProperty(HOME_DIRECTORY), customSchemaDirectory, SCHEMA_FILE_NAME), new LinkOption[0]);
    }

    private static ByteArrayOutputStream removeEmptyColumns(String html) throws IOException {
        Document document = KsefDocumentServiceImpl.getDocument(html);
        Elements tables = document.select("table:has(tr:gt(0)):has(td.niewypelniane:not([colspan]))");
        tables.stream().forEach(table -> KsefDocumentServiceImpl.removeEmptyColumnsFromTable(table));
        return KsefDocumentServiceImpl.documentToByteArrayOutputStream(document);
    }

    private static void removeEmptyColumnsFromTable(Element table) {
        Elements columns = table.selectFirst("tr").select("td.niewypelniane");
        Elements rowsWithoutHeader = table.select("tr:not(:first-child)");
        ArrayList<Integer> columnsToRemove = new ArrayList<Integer>();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            boolean columnIsEmpty = true;
            for (Element row : rowsWithoutHeader) {
                Elements cells = row.select("td");
                if (cells.isEmpty() || cells.size() > columnIndex && ((Element)cells.get(columnIndex)).text().trim().isEmpty()) continue;
                columnIsEmpty = false;
                break;
            }
            if (!columnIsEmpty) continue;
            columnsToRemove.add(columnIndex);
        }
        Collections.reverse(columnsToRemove);
        Elements allRows = table.select("tr");
        for (Element row : allRows) {
            Elements cells = row.select("td");
            columnsToRemove.forEach(columnNumber -> {
                if (cells.size() > columnNumber) {
                    ((Element)cells.get(columnNumber.intValue())).remove();
                }
            });
        }
    }

    private static Document getDocument(String inputHTML) {
        return Jsoup.parse((String)StringEscapeUtils.unescapeHtml4((String)inputHTML), (String)StandardCharsets.UTF_8.name());
    }

    private static String addHtmlHeaders(String html) {
        StringBuilder builder = new StringBuilder();
        builder.append(XML_HEADER).append('\n').append(DOCTYPE_HEADER).append('\n').append(html);
        return builder.toString();
    }

    @NotNull
    private static ByteArrayOutputStream documentToByteArrayOutputStream(Document document) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
            writer.write(document.toString());
        }
        return outputStream;
    }
}

