/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.model.invoice.SendInvoiceResponse;
import com.suncode.plugin.plusksef.api.service.KSeFService;
import com.suncode.plugin.plusksef.api.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/SendInvoiceToKSeF/pwe_dynamic_form.js")
public class SendInvoiceToKSeF {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceToKSeF.class);
    private static final String ID = "plusksef.autotask.SendInvoiceToKSeF";
    @Autowired
    private KSeFService ksEFService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private FileService fileService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.UP)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("referenceNumber").name(ID.concat(".param.referenceNumber.name")).description(ID.concat(".param.referenceNumber.desc")).type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String configId, @Param Integer fileId, @Param(value="referenceNumber") Variable elementReferenceNumber, ApplicationContext applicationContext) throws AcceptanceException {
        try {
            log.info("Send invoice to KSeF");
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            SessionInfo sessionInfo = this.ksEFService.getSession(ksefImportConfig);
            String invoicePath = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]).getFullPath();
            log.info("Document fileId: {}, Path: {}", (Object)fileId, (Object)invoicePath);
            SendInvoiceResponse sendInvoiceResponse = this.ksEFService.sendInvoice(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), Files.readAllBytes(Paths.get(invoicePath, new String[0])));
            elementReferenceNumber.setValue((Object)sendInvoiceResponse.getElementReferenceNumber());
            this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber(), applicationContext.getActivityId(), sessionInfo.getSessionToken());
            log.info(String.format("DOCUMENT EXPORTED. KSeF reference number: %s. KSeF element reference number: %S", sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

