/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.elixir.util;

import com.suncode.plugin.plusingintegrator.elixir.dto.multicashint.MultiCashIntDto;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashpla.MultiCashPlaDto;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class Formatter {
    private static final String END_LINE = "\r\n";

    private String splitByNewLine(String text, int chunkSize) {
        StringBuilder sb = new StringBuilder();
        return this.splitString(sb, text, END_LINE, chunkSize, () -> sb.toString().trim());
    }

    private String splitString(StringBuilder sb, String text, String splitChar, int chunkSize, Callable<String> lastCharProcessor) {
        if (text.length() <= chunkSize) {
            return text;
        }
        for (int start = 0; start < text.length(); start += chunkSize) {
            int end = Math.min(start + chunkSize, text.length());
            sb.append(text, start, end).append(splitChar);
        }
        return lastCharProcessor.call();
    }

    public String multiCashIntTransferHeader(MultiCashIntDto.MultiCashIntHeaderDto header) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(END_LINE).append(":01:").append(header.getReference()).append(END_LINE).append(":02:").append(header.getTotalAmount()).append(END_LINE).append(":03:").append(header.getTransferCount()).append(END_LINE).append(":04:").append(header.getPrincipalBankNumber()).append(END_LINE).append(":05:").append(this.splitByNewLine(header.getPrincipalName() + " " + header.getPrincipalAddress(), 35)).append(END_LINE).append(":06:").append(header.getBpdFileNumber()).append(END_LINE).append(":07:").append(header.getFilename());
        return stringBuilder.toString();
    }

    public String multiCashIntTransfer(MultiCashIntDto.MultiCashIntTransferDto transfer) {
        String beneficiaryBankData = StringUtils.isNotBlank((CharSequence)transfer.getBeneficiaryBankSwiftCode()) ? ":57A:" + transfer.getBeneficiaryBankSwiftCode() : ":57D:" + this.splitByNewLine(transfer.getBeneficiaryBankName() + " " + transfer.getBeneficiaryBankAddress(), 35) + END_LINE + transfer.getBeneficiaryBankCountryCode();
        String intermediaryBankData = StringUtils.isNotBlank((CharSequence)transfer.getIntermediaryBankSwiftCode()) ? transfer.getIntermediaryBankSwiftCode() : "";
        String feesData = "";
        boolean isFeesPaymentModeBen = StringUtils.equals((CharSequence)transfer.getFeesPaymentMode(), (CharSequence)"BEN");
        if (!isFeesPaymentModeBen) {
            feesData = StringUtils.isBlank((CharSequence)transfer.getFeesExchangeRate()) && StringUtils.isBlank((CharSequence)transfer.getFeesExchangeCurrency()) && StringUtils.isBlank((CharSequence)transfer.getFeesExchangeMode()) ? transfer.getFeesAccountNumber() + END_LINE + "TKDW" + transfer.getFeesExchangeDate().toString("ddMMyy") : transfer.getFeesAccountNumber() + END_LINE + transfer.getFeesExchangeMode() + transfer.getFeesExchangeCurrency() + transfer.getFeesExchangeRate() + END_LINE + "TKDW" + transfer.getFeesExchangeDate().toString("ddMMyy");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(END_LINE).append(":20:").append(transfer.getCustomerReferenceNumber()).append(END_LINE).append(":32A:").append(transfer.getTransferDate().toString("yyMMdd")).append(transfer.getCurrency()).append(transfer.getAmount()).append(END_LINE).append(":50:").append(this.splitByNewLine(transfer.getPrincipalName() + " " + transfer.getPrincipalAddress(), 35)).append(END_LINE).append(":52A:").append("/").append(transfer.getTransferTypePrefix()).append("/").append(transfer.getPrincipalAccountNumber()).append(END_LINE).append(transfer.getPrincipalBankNumber()).append(END_LINE).append(":53A:").append(intermediaryBankData).append(END_LINE).append(beneficiaryBankData).append(END_LINE).append(":59:").append("/").append(transfer.getBeneficiaryAccountNumber()).append(END_LINE).append(this.splitByNewLine(transfer.getBeneficiaryName() + " " + transfer.getBeneficiaryAddress(), 35)).append(END_LINE).append(transfer.getBeneficiaryCountryCode()).append(END_LINE).append(":70:").append(this.splitByNewLine(transfer.getPaymentDetails(), 35)).append(END_LINE).append(":71A:").append(transfer.getFeesPaymentMode());
        if (!isFeesPaymentModeBen) {
            stringBuilder.append(END_LINE).append(":72:").append(feesData);
        }
        return stringBuilder.toString();
    }

    public String multiCashPlaTransferHeader(MultiCashPlaDto.MultiCashPlaHeaderDto header) {
        return "\r\n:01:" + header.getReference() + END_LINE + ":02:" + header.getTotalAmount() + END_LINE + ":03:" + header.getTransferCount() + END_LINE + ":04:" + header.getPrincipalBankSwiftCode() + END_LINE + ":05:" + this.splitByNewLine(header.getPrincipalName() + " " + header.getPrincipalAddress(), 35) + END_LINE + ":07:" + header.getFilename();
    }

    public String multiCashPlaTransfer(MultiCashPlaDto.MultiCashPlaTransferDto transfer) {
        String beneficiaryBankData = StringUtils.isNotBlank((CharSequence)transfer.getBeneficiaryBankSwiftCode()) ? "\r\n:57A:" + transfer.getBeneficiaryBankSwiftCode() : "\r\n:57D:" + this.splitByNewLine(transfer.getBeneficiaryBankName() + " " + transfer.getBeneficiaryBankAddress(), 35);
        String feesData = "00 00 00 00";
        if (StringUtils.isNotBlank((CharSequence)transfer.getExtraData())) {
            feesData = feesData + END_LINE + transfer.getExtraData();
        }
        if (StringUtils.isNotBlank((CharSequence)transfer.getExtraDeadline())) {
            feesData = feesData + "\r\n/" + transfer.getExtraDeadline() + "/";
        }
        return "\r\n{:F01" + String.format("%1$-12s", transfer.getPrincipalBankNumber()).replace(' ', 'X') + transfer.getShipmentNumber() + transfer.getTransferNumber() + "}{2:I100" + String.format("%1$-12s", transfer.getBeneficiaryBankSwiftCode()).replace(' ', 'X') + transfer.getTransferType() + "1}{4:" + END_LINE + ":20:" + transfer.getCustomerReferenceNumber() + END_LINE + ":32A:" + transfer.getTransferDate().toString("yyMMdd") + transfer.getCurrency() + transfer.getAmount() + END_LINE + ":50:" + this.splitByNewLine(transfer.getPrincipalName() + " " + transfer.getPrincipalAddress(), 35) + END_LINE + ":52D:" + transfer.getPrincipalAccountNumber() + END_LINE + transfer.getFeesAccountNumber() + END_LINE + END_LINE + String.join((CharSequence)"", Collections.nCopies(15, " ")) + transfer.getBeneficiaryCountryCode() + " " + transfer.getBeneficiaryBankCountryCode() + END_LINE + beneficiaryBankData + END_LINE + ":59:/" + transfer.getBeneficiaryAccountNumber() + END_LINE + this.splitByNewLine(transfer.getBeneficiaryName() + " " + transfer.getBeneficiaryAddress(), 35) + END_LINE + ":70:" + this.splitByNewLine(transfer.getPaymentDetails(), 35) + END_LINE + ":71A:" + transfer.getFeesPaymentMode() + END_LINE + ":72:" + feesData + END_LINE + "-}";
    }
}

