/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.elixir.service;

import com.suncode.plugin.plusingintegrator.elixir.dto.multicashint.MultiCashIntDto;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashpla.MultiCashPlaDto;
import com.suncode.plugin.plusingintegrator.elixir.service.ElixirService;
import com.suncode.plugin.plusingintegrator.elixir.util.Formatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ElixirServiceImpl
implements ElixirService {
    private static final Formatter FORMATTER = new Formatter();

    @Override
    public void createMultiCashIntTransferFile(MultiCashIntDto dto, File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(FORMATTER.multiCashIntTransferHeader(dto.getHeader()));
        dto.getTransfers().stream().map(FORMATTER::multiCashIntTransfer).forEach(lines::add);
        this.writeLines(lines, file);
    }

    @Override
    public void createMultiCashPlaTransferFile(MultiCashPlaDto dto, File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(FORMATTER.multiCashPlaTransferHeader(dto.getHeader()));
        dto.getTransfers().stream().map(FORMATTER::multiCashPlaTransfer).forEach(lines::add);
        this.writeLines(lines, file);
    }

    private void writeLines(List<String> lines, File file) throws IOException {
        try (OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
            for (String line : lines) {
                outputStream.write(line);
            }
        }
    }
}

