/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.assertion;

import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.apache.commons.lang3.StringUtils;

public class ElixirAssertions {
    private static final Translator T = Translators.get((String)"com.suncode.plugin-plus-ing-integrator");
    private static final String ALPHANUMERIC = "[a-zA-Z0-9/\\-?:().,'+]";
    private static final String NUMERIC = "[0-9]";

    public static void assertNumeric(String value, String key, int length, boolean optional, boolean fixedLength) {
        ElixirAssertions.checkOptional(value, key, optional);
        ElixirAssertions.checkFixedLength(value, key, length, fixedLength);
        if (!value.matches("^[0-9]{0," + length + "}$")) {
            throw new IllegalArgumentException("\"" + T.getMessage(key) + "\" must have " + length + " numeric characters at most: " + value);
        }
    }

    public static void assertAlphanumeric(String value, String key, int length, boolean optional, boolean fixedLength) {
        ElixirAssertions.checkOptional(value, key, optional);
        ElixirAssertions.checkFixedLength(value, key, length, fixedLength);
        if (!value.matches("^[a-zA-Z0-9/\\-?:().,'+]{0," + length + "}$")) {
            throw new IllegalArgumentException("\"" + T.getMessage(key) + "\" must have " + length + " alphanumeric characters at most: " + value);
        }
    }

    public static void assertNonNull(Object value, String key) {
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException("\"" + T.getMessage(key) + "\" is mandatory");
        }
    }

    private static void checkOptional(String value, String key, boolean optional) {
        if (!optional && StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\"" + T.getMessage(key) + "\" is mandatory");
        }
    }

    private static void checkFixedLength(String value, String key, int length, boolean fixedLength) {
        if (fixedLength && StringUtils.trimToEmpty((String)value).length() != length) {
            throw new IllegalArgumentException("\"" + T.getMessage(key) + "\" must be exactly " + length + " characters");
        }
    }

    private ElixirAssertions() {
    }
}

