/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.archive.service;

import com.suncode.plugin.plusingintegrator.archive.service.ArchiveDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.workflow.WorkflowContext;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ArchiveDocumentServiceImpl
implements ArchiveDocumentService {
    private static final String USER_LOGIN = "admin";
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;

    @Override
    public void addNewDocumentToArchive(String documentClassName, String documentName, String documentDescription, InputStream inputStream, WorkflowContext workflowContext) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[0]);
        Assert.notNull((Object)documentClass, (String)("Document class: '" + documentClassName + "' does not exist"));
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(documentClass.getId());
        if (StringUtils.isNotBlank((CharSequence)documentDescription)) {
            documentDefinition.setDescription(documentDescription);
        }
        documentDefinition.setProcessId(workflowContext.getProcessId());
        documentDefinition.setActivityId(workflowContext.getActivityId());
        documentDefinition.setInputStream(inputStream);
        documentDefinition.setUserName(USER_LOGIN);
        documentDefinition.setFileName(documentName);
        this.documentService.addDocument(documentDefinition);
    }

    @Override
    public List<DocumentClass> getDocumentClasses(String query) {
        return this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
    }
}

