/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.archive.controller;

import com.suncode.plugin.plusingintegrator.archive.dto.DocumentClassDto;
import com.suncode.plugin.plusingintegrator.archive.service.ArchiveDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.search.CountedResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class ArchiveDocumentController {
    @Autowired
    private ArchiveDocumentService archiveDocumentService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/documentClasses"})
    public CountedResult<DocumentClassDto> getDocumentClasses(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        CountedResult result = new CountedResult();
        List<DocumentClass> documentClasses = this.archiveDocumentService.getDocumentClasses(query);
        if (documentClasses.size() >= start) {
            result.setData(documentClasses.subList(start, Integer.min(start + limit, documentClasses.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClasses.size());
        return this.convertDocClassToDto((CountedResult<DocumentClass>)result);
    }

    private CountedResult<DocumentClassDto> convertDocClassToDto(CountedResult<DocumentClass> documentClasses) {
        List data = documentClasses.getData().stream().map(DocumentClassDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(documentClasses.getTotal(), data);
    }
}

