/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.application;

import com.suncode.plugin.plusingintegrator.Categories;
import com.suncode.plugin.plusingintegrator.archive.service.ArchiveDocumentService;
import com.suncode.plugin.plusingintegrator.assertion.ElixirAssertions;
import com.suncode.plugin.plusingintegrator.assertion.ParameterAssertions;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashpla.MultiCashPlaDto;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashpla.MultiCashPlaParametersDto;
import com.suncode.plugin.plusingintegrator.elixir.service.ElixirService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="/dist/application/MultiCashPlaTransferForm.js")
public class MultiCashPlaTransfer {
    private static final Logger log = LoggerFactory.getLogger(MultiCashPlaTransfer.class);
    public static final String APP_ID = "plusingintegrator.application.MultiCashPlaTransfer";
    private static final String[] stringArrayParams = new String[]{"beneficiaryBankSwiftCode", "transferType", "customerReferenceNumber", "currency", "beneficiaryCountryCode", "beneficiaryBankCountryCode", "beneficiaryBankName", "beneficiaryBankAddress", "beneficiaryAccountNumber", "beneficiaryName", "beneficiaryAddress", "paymentDetails", "feesPaymentMode", "extraData", "extraDeadline", "transferNumber", "shipmentNumber"};
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ElixirService elixirService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(APP_ID)).name("plusingintegrator.application.MultiCashPlaTransfer.name")).description("plusingintegrator.application.MultiCashPlaTransfer.desc")).icon((Icon)DivanteIcon.MONEY)).category(new Category[]{Categories.PLUS_ING_INTEGRATOR})).parameter().id("documentClassName").name("plusingintegrator.application.MultiCashPlaTransfer.param.documentClassName.name").description("plusingintegrator.application.MultiCashPlaTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("plusingintegrator.application.MultiCashPlaTransfer.param.documentName.name").description("plusingintegrator.application.MultiCashPlaTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("documentDescription").name("plusingintegrator.application.MultiCashPlaTransfer.param.documentDescription.name").description("plusingintegrator.application.MultiCashPlaTransfer.param.documentDescription.desc").type((Type)Types.STRING).optional().create()).parameter().id("reference").name("plusingintegrator.application.MultiCashPlaTransfer.param.reference.name").type((Type)Types.STRING).create()).parameter().id("principalBankSwiftCode").name("plusingintegrator.application.MultiCashPlaTransfer.param.principalBankSwiftCode.name").type((Type)Types.STRING).create()).parameter().id("principalName").name("plusingintegrator.application.MultiCashPlaTransfer.param.principalName.name").type((Type)Types.STRING).create()).parameter().id("principalAddress").name("plusingintegrator.application.MultiCashPlaTransfer.param.principalAddress.name").type((Type)Types.STRING).create()).parameter().id("principalBankNumber").name("plusingintegrator.application.MultiCashPlaTransfer.param.principalBankNumber.name").type((Type)Types.STRING).create()).parameter().id("principalAccountNumber").name("plusingintegrator.application.MultiCashPlaTransfer.param.principalAccountNumber.name").type((Type)Types.STRING).create()).parameter().id("feesAccountNumber").name("plusingintegrator.application.MultiCashPlaTransfer.param.feesAccountNumber.name").type((Type)Types.STRING).create()).parameter().id("filename").name("plusingintegrator.application.MultiCashPlaTransfer.param.filename.name").type((Type)Types.STRING).create()).parameter().id("transferDate").name("plusingintegrator.application.MultiCashPlaTransfer.param.transferDate.name").type((Type)Types.DATE_ARRAY).create()).parameter().id("amount").name("plusingintegrator.application.MultiCashPlaTransfer.param.amount.name").type((Type)Types.FLOAT_ARRAY).create();
        Arrays.stream(stringArrayParams).forEach(key -> {
            ApplicationDefinitionBuilder cfr_ignored_0 = (ApplicationDefinitionBuilder)builder.parameter().id(key).name("plusingintegrator.application.MultiCashPlaTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext) throws AcceptanceException {
        String documentName = (String)parameters.get("documentName", String.class);
        String documentDescription = (String)parameters.get("documentDescription", String.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        MultiCashPlaParametersDto.MultiCashPlaHeader headerParameters = MultiCashPlaParametersDto.MultiCashPlaHeader.builder().reference((String)parameters.get("reference", String.class)).principalBankSwiftCode((String)parameters.get("principalBankSwiftCode", String.class)).principalName((String)parameters.get("principalName", String.class)).principalAddress((String)parameters.get("principalAddress", String.class)).principalBankNumber((String)parameters.get("principalBankNumber", String.class)).principalAccountNumber((String)parameters.get("principalAccountNumber", String.class)).feesAccountNumber((String)parameters.get("feesAccountNumber", String.class)).filename((String)parameters.get("filename", String.class)).build();
        MultiCashPlaParametersDto.MultiCashPlaTransfers transferParameters = MultiCashPlaParametersDto.MultiCashPlaTransfers.builder().shipmentNumber((String[])parameters.get("shipmentNumber", String[].class)).transferNumber((String[])parameters.get("transferNumber", String[].class)).beneficiaryBankSwiftCode((String[])parameters.get("beneficiaryBankSwiftCode", String[].class)).transferType((String[])parameters.get("transferType", String[].class)).customerReferenceNumber((String[])parameters.get("customerReferenceNumber", String[].class)).transferDate((LocalDate[])parameters.get("transferDate", LocalDate[].class)).currency((String[])parameters.get("currency", String[].class)).amount((Double[])parameters.get("amount", Double[].class)).beneficiaryCountryCode((String[])parameters.get("beneficiaryCountryCode", String[].class)).beneficiaryBankCountryCode((String[])parameters.get("beneficiaryBankCountryCode", String[].class)).beneficiaryBankName((String[])parameters.get("beneficiaryBankName", String[].class)).beneficiaryBankAddress((String[])parameters.get("beneficiaryBankAddress", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).beneficiaryName((String[])parameters.get("beneficiaryName", String[].class)).beneficiaryAddress((String[])parameters.get("beneficiaryAddress", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).feesPaymentMode((String[])parameters.get("feesPaymentMode", String[].class)).extraData((String[])parameters.get("extraData", String[].class)).extraDeadline((String[])parameters.get("extraDeadline", String[].class)).build();
        ParameterAssertions.assertEqualArrayLength(transferParameters.getShipmentNumber(), transferParameters.getTransferNumber(), transferParameters.getBeneficiaryBankSwiftCode(), transferParameters.getTransferType(), transferParameters.getCustomerReferenceNumber(), transferParameters.getTransferDate(), transferParameters.getCurrency(), transferParameters.getAmount(), transferParameters.getBeneficiaryCountryCode(), transferParameters.getBeneficiaryBankSwiftCode(), transferParameters.getBeneficiaryBankName(), transferParameters.getBeneficiaryBankAddress(), transferParameters.getBeneficiaryAccountNumber(), transferParameters.getBeneficiaryName(), transferParameters.getBeneficiaryAddress(), transferParameters.getPaymentDetails(), transferParameters.getFeesPaymentMode(), transferParameters.getExtraData(), transferParameters.getExtraDeadline());
        this.assertHeaderValues(headerParameters);
        this.assertTransferValues(transferParameters);
        MultiCashPlaDto.MultiCashPlaHeaderDto multiCashPlaHeaderDto = this.buildHeaderDto(headerParameters);
        List<MultiCashPlaDto.MultiCashPlaTransferDto> multiCashPlaTransferDto = this.buildTransferDto(headerParameters, transferParameters);
        multiCashPlaHeaderDto.setTotalAmount(Arrays.stream(transferParameters.getAmount()).mapToDouble(Double::doubleValue).sum());
        multiCashPlaHeaderDto.setTransferCount(transferParameters.getAmount().length);
        MultiCashPlaDto multiCashPlaDto = MultiCashPlaDto.builder().header(multiCashPlaHeaderDto).transfers(multiCashPlaTransferDto).build();
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            this.elixirService.createMultiCashPlaTransferFile(multiCashPlaDto, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, documentDescription, inputStream, workflowContext);
        }
        catch (IOException e) {
            throw new AcceptanceException("IOException occurred!");
        }
        finally {
            tempFile.delete();
        }
    }

    private List<MultiCashPlaDto.MultiCashPlaTransferDto> buildTransferDto(MultiCashPlaParametersDto.MultiCashPlaHeader header, MultiCashPlaParametersDto.MultiCashPlaTransfers transfers) {
        ArrayList<MultiCashPlaDto.MultiCashPlaTransferDto> list = new ArrayList<MultiCashPlaDto.MultiCashPlaTransferDto>();
        IntStream.range(0, transfers.getAmount().length).forEach(index -> list.add(MultiCashPlaDto.MultiCashPlaTransferDto.builder().principalBankNumber(header.getPrincipalBankNumber()).shipmentNumber(transfers.getShipmentNumber()[index]).transferNumber(transfers.getTransferNumber()[index]).beneficiaryBankSwiftCode(transfers.getBeneficiaryBankSwiftCode()[index]).transferType(transfers.getTransferType()[index]).customerReferenceNumber(transfers.getCustomerReferenceNumber()[index]).transferDate(transfers.getTransferDate()[index]).currency(transfers.getCurrency()[index]).amount(transfers.getAmount()[index]).principalName(header.getPrincipalName()).principalAddress(header.getPrincipalAddress()).principalAccountNumber(header.getPrincipalAccountNumber()).feesAccountNumber(header.getFeesAccountNumber()).beneficiaryCountryCode(transfers.getBeneficiaryCountryCode()[index]).beneficiaryBankCountryCode(transfers.getBeneficiaryBankCountryCode()[index]).beneficiaryBankName(transfers.getBeneficiaryBankName()[index]).beneficiaryBankAddress(transfers.getBeneficiaryBankAddress()[index]).beneficiaryAccountNumber(transfers.getBeneficiaryAccountNumber()[index]).beneficiaryName(transfers.getBeneficiaryName()[index]).beneficiaryAddress(transfers.getBeneficiaryAddress()[index]).paymentDetails(transfers.getPaymentDetails()[index]).feesPaymentMode(transfers.getFeesPaymentMode()[index]).extraData(transfers.getExtraData()[index]).extraDeadline(transfers.getExtraDeadline()[index]).build()));
        return list;
    }

    private MultiCashPlaDto.MultiCashPlaHeaderDto buildHeaderDto(MultiCashPlaParametersDto.MultiCashPlaHeader parameters) {
        return MultiCashPlaDto.MultiCashPlaHeaderDto.builder().reference(parameters.getReference()).principalBankSwiftCode(parameters.getPrincipalBankSwiftCode()).principalName(parameters.getPrincipalName()).principalAddress(parameters.getPrincipalAddress()).principalAccountNumber(parameters.getPrincipalAccountNumber()).filename(parameters.getFilename()).build();
    }

    private void assertHeaderValues(MultiCashPlaParametersDto.MultiCashPlaHeader dto) {
        ElixirAssertions.assertAlphanumeric(dto.getReference(), "plusingintegrator.application.MultiCashPlaTransfer.param.reference.name", 16, true, false);
        ElixirAssertions.assertAlphanumeric(dto.getPrincipalBankSwiftCode(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalBankSwiftCode.name", 11, false, false);
        ElixirAssertions.assertNonNull(dto.getPrincipalName(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalName.name");
        ElixirAssertions.assertNonNull(dto.getPrincipalAddress(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalAddress.name");
        ElixirAssertions.assertAlphanumeric(dto.getPrincipalName() + dto.getPrincipalAddress(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalNameAndAddress.name", 139, false, false);
        ElixirAssertions.assertNumeric(dto.getPrincipalBankNumber(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalBankNumber.name", 11, false, false);
        ElixirAssertions.assertNumeric(dto.getPrincipalAccountNumber(), "plusingintegrator.application.MultiCashPlaTransfer.param.principalAccountNumber.name", 26, false, true);
        ElixirAssertions.assertNumeric(dto.getFeesAccountNumber(), "plusingintegrator.application.MultiCashPlaTransfer.param.feesAccountNumber.name", 26, false, true);
        ElixirAssertions.assertAlphanumeric(dto.getFilename(), "plusingintegrator.application.MultiCashPlaTransfer.param.filename.name", 12, true, false);
    }

    private void assertTransferValues(MultiCashPlaParametersDto.MultiCashPlaTransfers dto) {
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertNumeric(dto.getShipmentNumber()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.shipmentNumber.name", 4, false, true);
            ElixirAssertions.assertNumeric(dto.getTransferNumber()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.transferNumber.name", 6, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankSwiftCode()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankSwiftCode.name", 11, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getTransferType()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.transferType.name", 1, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getCustomerReferenceNumber()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.customerReferenceNumber.name", 16, false, false);
            ElixirAssertions.assertNonNull(dto.getTransferDate()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.transferDate.name");
            ElixirAssertions.assertAlphanumeric(dto.getCurrency()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.currency.name", 3, false, true);
            ElixirAssertions.assertNonNull(dto.getAmount()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.amount.name");
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryCountryCode()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryCountryCode.name", 2, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankCountryCode()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankCountryCode.name", 2, false, true);
            if (StringUtils.isNotBlank((CharSequence)dto.getBeneficiaryBankSwiftCode()[index])) {
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankSwiftCode()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankSwiftCode.name", 11, false, false);
            } else {
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankName()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankName.name");
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankAddress()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankAddress.name");
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankName()[index] + dto.getBeneficiaryBankAddress()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryBankNameAndAddress.name", 139, false, false);
            }
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryAccountNumber()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryAccountNumber.name", 34, false, false);
            ElixirAssertions.assertNonNull(dto.getBeneficiaryName()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryName.name");
            ElixirAssertions.assertNonNull(dto.getBeneficiaryAddress()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryAddress.name");
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryName()[index] + dto.getBeneficiaryAddress()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.beneficiaryNameAndAddress.name", 139, false, false);
            ElixirAssertions.assertAlphanumeric(dto.getPaymentDetails()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.paymentDetails.name", 140, false, false);
            ElixirAssertions.assertAlphanumeric(dto.getFeesPaymentMode()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.feesPaymentMode.name", 3, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getExtraData()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.extraData.name", 35, true, false);
            ElixirAssertions.assertAlphanumeric(dto.getExtraDeadline()[index], "plusingintegrator.application.MultiCashPlaTransfer.param.extraDeadline.name", 3, true, true);
        });
    }
}

