/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusingintegrator.application;

import com.suncode.plugin.plusingintegrator.Categories;
import com.suncode.plugin.plusingintegrator.archive.service.ArchiveDocumentService;
import com.suncode.plugin.plusingintegrator.assertion.ElixirAssertions;
import com.suncode.plugin.plusingintegrator.assertion.ParameterAssertions;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashint.MultiCashIntDto;
import com.suncode.plugin.plusingintegrator.elixir.dto.multicashint.MultiCashIntParametersDto;
import com.suncode.plugin.plusingintegrator.elixir.service.ElixirService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/application/MultiCashIntTransferForm.js")
public class MultiCashIntTransfer {
    private static final Logger log = LoggerFactory.getLogger(MultiCashIntTransfer.class);
    public static final String APP_ID = "plusingintegrator.application.MultiCashIntTransfer";
    private static final String[] stringArrayParams = new String[]{"customerReferenceNumber", "currency", "transferType", "intermediaryBankSwiftCode", "beneficiaryBankSwiftCode", "beneficiaryBankName", "beneficiaryBankAddress", "beneficiaryBankCountryCode", "beneficiaryAccountNumber", "beneficiaryName", "beneficiaryAddress", "beneficiaryCountryCode", "paymentDetails", "feesPaymentMode", "feesAccountNumber", "feesExchangeRate", "feesExchangeMode", "feesExchangeCurrency"};
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ElixirService elixirService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(APP_ID)).name("plusingintegrator.application.MultiCashIntTransfer.name")).description("plusingintegrator.application.MultiCashIntTransfer.desc")).category(new Category[]{Categories.PLUS_ING_INTEGRATOR})).icon((Icon)DivanteIcon.MONEY)).parameter().id("documentClassName").name("plusingintegrator.application.MultiCashIntTransfer.param.documentClassName.name").description("plusingintegrator.application.MultiCashIntTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("plusingintegrator.application.MultiCashIntTransfer.param.documentName.name").description("plusingintegrator.application.MultiCashIntTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("documentDescription").name("plusingintegrator.application.MultiCashIntTransfer.param.documentDescription.name").description("plusingintegrator.application.MultiCashIntTransfer.param.documentDescription.desc").type((Type)Types.STRING).optional().create()).parameter().id("reference").name("plusingintegrator.application.MultiCashIntTransfer.param.reference.name").type((Type)Types.STRING).create()).parameter().id("principalBankNumber").name("plusingintegrator.application.MultiCashIntTransfer.param.principalBankNumber.name").type((Type)Types.STRING).create()).parameter().id("principalName").name("plusingintegrator.application.MultiCashIntTransfer.param.principalName.name").type((Type)Types.STRING).create()).parameter().id("principalAddress").name("plusingintegrator.application.MultiCashIntTransfer.param.principalAddress.name").type((Type)Types.STRING).create()).parameter().id("principalAccountNumber").name("plusingintegrator.application.MultiCashIntTransfer.param.principalAccountNumber.name").type((Type)Types.STRING).create()).parameter().id("bpdFileNumber").name("plusingintegrator.application.MultiCashIntTransfer.param.bpdFileNumber.name").type((Type)Types.STRING).optional().create()).parameter().id("filename").name("plusingintegrator.application.MultiCashIntTransfer.param.filename.name").type((Type)Types.STRING).optional().create()).parameter().id("transferDate").name("plusingintegrator.application.MultiCashIntTransfer.param.transferDate.name").type((Type)Types.DATE_ARRAY).create()).parameter().id("amount").name("plusingintegrator.application.MultiCashIntTransfer.param.amount.name").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("feesExchangeDate").name("plusingintegrator.application.MultiCashIntTransfer.param.feesExchangeDate.name").type((Type)Types.DATE_ARRAY).create();
        Arrays.stream(stringArrayParams).forEach(key -> {
            ApplicationDefinitionBuilder cfr_ignored_0 = (ApplicationDefinitionBuilder)builder.parameter().id(key).name("plusingintegrator.application.MultiCashIntTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext) throws AcceptanceException {
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        String documentName = (String)parameters.get("documentName", String.class);
        String documentDescription = (String)parameters.get("documentDescription", String.class);
        MultiCashIntParametersDto.MultiCashIntHeader headerParameters = MultiCashIntParametersDto.MultiCashIntHeader.builder().reference((String)parameters.get("reference", String.class)).principalName((String)parameters.get("principalName", String.class)).principalAddress((String)parameters.get("principalAddress", String.class)).principalBankNumber((String)parameters.get("principalBankNumber", String.class)).principalAccountNumber((String)parameters.get("principalAccountNumber", String.class)).bpdFileNumber((String)parameters.get("bpdFileNumber", String.class)).filename((String)parameters.get("filename", String.class)).build();
        MultiCashIntParametersDto.MultiCashIntTransfers transferParameters = MultiCashIntParametersDto.MultiCashIntTransfers.builder().customerReferenceNumber((String[])parameters.get("customerReferenceNumber", String[].class)).transferDate((LocalDate[])parameters.get("transferDate", LocalDate[].class)).currency((String[])parameters.get("currency", String[].class)).amount((Double[])parameters.get("amount", Double[].class)).transferType((String[])parameters.get("transferType", String[].class)).intermediaryBankSwiftCode((String[])parameters.get("intermediaryBankSwiftCode", String[].class)).beneficiaryBankSwiftCode((String[])parameters.get("beneficiaryBankSwiftCode", String[].class)).beneficiaryBankName((String[])parameters.get("beneficiaryBankName", String[].class)).beneficiaryBankAddress((String[])parameters.get("beneficiaryBankAddress", String[].class)).beneficiaryBankCountryCode((String[])parameters.get("beneficiaryBankCountryCode", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).beneficiaryName((String[])parameters.get("beneficiaryName", String[].class)).beneficiaryAddress((String[])parameters.get("beneficiaryAddress", String[].class)).beneficiaryCountryCode((String[])parameters.get("beneficiaryCountryCode", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).feesPaymentMode((String[])parameters.get("feesPaymentMode", String[].class)).feesAccountNumber((String[])parameters.get("feesAccountNumber", String[].class)).feesExchangeRate((String[])parameters.get("feesExchangeRate", String[].class)).feesExchangeMode((String[])parameters.get("feesExchangeMode", String[].class)).feesExchangeDate((LocalDate[])parameters.get("feesExchangeDate", LocalDate[].class)).feesExchangeCurrency((String[])parameters.get("feesExchangeCurrency", String[].class)).build();
        ParameterAssertions.assertEqualArrayLength(transferParameters.getCustomerReferenceNumber(), transferParameters.getTransferDate(), transferParameters.getCurrency(), transferParameters.getAmount(), transferParameters.getTransferType(), transferParameters.getIntermediaryBankSwiftCode(), transferParameters.getBeneficiaryBankSwiftCode(), transferParameters.getBeneficiaryBankName(), transferParameters.getBeneficiaryBankAddress(), transferParameters.getBeneficiaryBankCountryCode(), transferParameters.getBeneficiaryAccountNumber(), transferParameters.getBeneficiaryName(), transferParameters.getBeneficiaryAddress(), transferParameters.getBeneficiaryCountryCode(), transferParameters.getPaymentDetails(), transferParameters.getFeesPaymentMode(), transferParameters.getFeesAccountNumber(), transferParameters.getFeesExchangeRate(), transferParameters.getFeesExchangeMode(), transferParameters.getFeesExchangeDate());
        this.assertHeaderValues(headerParameters);
        this.assertTransferValues(transferParameters);
        MultiCashIntDto.MultiCashIntHeaderDto multiCashIntHeaderDto = this.buildHeaderDto(headerParameters);
        List<MultiCashIntDto.MultiCashIntTransferDto> multiCashIntTransferDto = this.buildTransferDto(headerParameters, transferParameters);
        multiCashIntHeaderDto.setTotalAmount(Arrays.stream(transferParameters.getAmount()).mapToDouble(Double::doubleValue).sum());
        multiCashIntHeaderDto.setTransferCount(transferParameters.getAmount().length);
        MultiCashIntDto multiCashIntDto = MultiCashIntDto.builder().header(multiCashIntHeaderDto).transfers(multiCashIntTransferDto).build();
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            this.elixirService.createMultiCashIntTransferFile(multiCashIntDto, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, documentDescription, inputStream, workflowContext);
        }
        catch (IOException e) {
            throw new AcceptanceException("Error creating temporary file");
        }
        finally {
            tempFile.delete();
        }
    }

    private List<MultiCashIntDto.MultiCashIntTransferDto> buildTransferDto(MultiCashIntParametersDto.MultiCashIntHeader header, MultiCashIntParametersDto.MultiCashIntTransfers transfers) {
        ArrayList<MultiCashIntDto.MultiCashIntTransferDto> list = new ArrayList<MultiCashIntDto.MultiCashIntTransferDto>();
        IntStream.range(0, transfers.getAmount().length).forEach(index -> list.add(MultiCashIntDto.MultiCashIntTransferDto.builder().customerReferenceNumber(transfers.getCustomerReferenceNumber()[index]).transferDate(transfers.getTransferDate()[index]).currency(transfers.getCurrency()[index]).amount(transfers.getAmount()[index]).principalName(header.getPrincipalName()).principalAddress(header.getPrincipalAddress()).transferTypePrefix(transfers.getTransferType()[index]).principalAccountNumber(header.getPrincipalAccountNumber()).principalBankNumber(header.getPrincipalBankNumber()).intermediaryBankSwiftCode(transfers.getIntermediaryBankSwiftCode()[index]).beneficiaryBankSwiftCode(transfers.getBeneficiaryBankSwiftCode()[index]).beneficiaryBankName(transfers.getBeneficiaryBankName()[index]).beneficiaryBankAddress(transfers.getBeneficiaryBankAddress()[index]).beneficiaryBankCountryCode(transfers.getBeneficiaryBankCountryCode()[index]).beneficiaryAccountNumber(transfers.getBeneficiaryAccountNumber()[index]).beneficiaryName(transfers.getBeneficiaryName()[index]).beneficiaryAddress(transfers.getBeneficiaryAddress()[index]).beneficiaryCountryCode(transfers.getBeneficiaryCountryCode()[index]).paymentDetails(transfers.getPaymentDetails()[index]).feesPaymentMode(transfers.getFeesPaymentMode()[index]).feesAccountNumber(transfers.getFeesAccountNumber()[index]).feesExchangeMode(transfers.getFeesExchangeMode()[index]).feesExchangeDate(transfers.getFeesExchangeDate()[index]).feesExchangeCurrency(transfers.getFeesExchangeCurrency()[index]).feesExchangeRate(transfers.getFeesExchangeRate()[index]).build()));
        return list;
    }

    private MultiCashIntDto.MultiCashIntHeaderDto buildHeaderDto(MultiCashIntParametersDto.MultiCashIntHeader parameters) {
        return MultiCashIntDto.MultiCashIntHeaderDto.builder().reference(parameters.getReference()).principalBankNumber(parameters.getPrincipalBankNumber()).principalName(parameters.getPrincipalName()).principalAddress(parameters.getPrincipalAddress()).bpdFileNumber(parameters.getBpdFileNumber()).filename(parameters.getFilename()).build();
    }

    private void assertHeaderValues(MultiCashIntParametersDto.MultiCashIntHeader dto) {
        ElixirAssertions.assertAlphanumeric(dto.getReference(), "plusingintegrator.application.MultiCashIntTransfer.param.reference.name", 16, true, false);
        ElixirAssertions.assertNumeric(dto.getPrincipalBankNumber(), "plusingintegrator.application.MultiCashIntTransfer.param.principalBankNumber.name", 11, false, false);
        ElixirAssertions.assertAlphanumeric(dto.getPrincipalAccountNumber(), "plusingintegrator.application.MultiCashIntTransfer.param.principalAccountNumber.name", 34, false, false);
        ElixirAssertions.assertNonNull(dto.getPrincipalName(), "plusingintegrator.application.MultiCashIntTransfer.param.principalName.name");
        ElixirAssertions.assertNonNull(dto.getPrincipalAddress(), "plusingintegrator.application.MultiCashIntTransfer.param.principalAddress.name");
        ElixirAssertions.assertAlphanumeric(dto.getPrincipalName() + dto.getPrincipalAddress(), "plusingintegrator.application.MultiCashIntTransfer.param.principalNameAndAddress.name", 139, false, false);
        ElixirAssertions.assertAlphanumeric(dto.getBpdFileNumber(), "plusingintegrator.application.MultiCashIntTransfer.param.bpdFileNumber.name", 8, true, false);
        ElixirAssertions.assertAlphanumeric(dto.getFilename(), "plusingintegrator.application.MultiCashIntTransfer.param.filename.name", 12, true, false);
    }

    private void assertTransferValues(MultiCashIntParametersDto.MultiCashIntTransfers dto) {
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertAlphanumeric(dto.getCustomerReferenceNumber()[index], "plusingintegrator.application.MultiCashIntTransfer.param.customerReferenceNumber.name", 16, false, false);
            ElixirAssertions.assertNonNull(dto.getTransferDate()[index], "plusingintegrator.application.MultiCashIntTransfer.param.transferDate.name");
            ElixirAssertions.assertAlphanumeric(dto.getCurrency()[index], "plusingintegrator.application.MultiCashIntTransfer.param.currency.name", 3, false, true);
            ElixirAssertions.assertNonNull(dto.getAmount()[index], "plusingintegrator.application.MultiCashIntTransfer.param.amount.name");
            ElixirAssertions.assertAlphanumeric(dto.getTransferType()[index], "plusingintegrator.application.MultiCashIntTransfer.param.transferType.name", 1, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getIntermediaryBankSwiftCode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.intermediaryBankSwiftCode.name", 11, true, false);
            if (StringUtils.isNotBlank((CharSequence)dto.getBeneficiaryBankSwiftCode()[index])) {
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankSwiftCode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryBankSwiftCode.name", 11, false, false);
            } else {
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankName()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryBankName.name");
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankAddress()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryBankAddress.name");
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankCountryCode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryBankCountryCode.name", 2, false, true);
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankName()[index] + dto.getBeneficiaryBankAddress()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryBankNameAndAddress.name", 104, false, false);
            }
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryAccountNumber()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryAccountNumber.name", 34, false, false);
            ElixirAssertions.assertNonNull(dto.getBeneficiaryName()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryName.name");
            ElixirAssertions.assertNonNull(dto.getBeneficiaryAddress()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryAddress.name");
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryCountryCode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryCountryCode.name", 2, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryName()[index] + dto.getBeneficiaryAddress()[index], "plusingintegrator.application.MultiCashIntTransfer.param.beneficiaryNameAndAddress.name", 104, false, false);
            ElixirAssertions.assertAlphanumeric(dto.getPaymentDetails()[index], "plusingintegrator.application.MultiCashIntTransfer.param.paymentDetails.name", 140, false, false);
            ElixirAssertions.assertAlphanumeric(dto.getFeesPaymentMode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesPaymentMode.name", 3, false, true);
            if (!StringUtils.equals((CharSequence)dto.getFeesPaymentMode()[index], (CharSequence)"BEN")) {
                ElixirAssertions.assertAlphanumeric(dto.getFeesAccountNumber()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesAccountNumber.name", 105, false, false);
                if (StringUtils.isNotBlank((CharSequence)dto.getFeesExchangeRate()[index]) && StringUtils.isNotBlank((CharSequence)dto.getFeesExchangeCurrency()[index]) && StringUtils.isNotBlank((CharSequence)dto.getFeesExchangeMode()[index])) {
                    ElixirAssertions.assertAlphanumeric(dto.getFeesExchangeCurrency()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesExchangeCurrency.name", 3, false, true);
                    ElixirAssertions.assertAlphanumeric(dto.getFeesExchangeMode()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesExchangeMode.name", 3, false, true);
                    ElixirAssertions.assertAlphanumeric(dto.getFeesExchangeRate()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesExchangeRate.name", 5, false, true);
                }
                ElixirAssertions.assertNonNull(dto.getFeesExchangeDate()[index], "plusingintegrator.application.MultiCashIntTransfer.param.feesExchangeDate.name");
            }
        });
    }
}

