/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.controller;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.ftp.controller.tools.ControllerTools;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config"})
public class ConfigurationFileController {
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    @RequestMapping(value={"configurationFilesList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getConfigurationFilesList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        String[] configurationFiles = this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey());
        LinkedList<Map<String, String>> configurationFileInfoList = new LinkedList<Map<String, String>>();
        for (String configurationFile : configurationFiles) {
            if (!StringUtils.isBlank((CharSequence)query) && !configurationFile.toLowerCase().contains(query.toLowerCase())) continue;
            configurationFileInfoList.add(Collections.singletonMap("configurationFileName", configurationFile));
        }
        int totalResult = configurationFileInfoList.size();
        ControllerTools<Map<String, String>> controllerTools = new ControllerTools<Map<String, String>>();
        result.setData(controllerTools.getSubData(configurationFileInfoList, Integer.parseInt(start), Integer.parseInt(limit), totalResult));
        result.setTotal((long)totalResult);
        return result;
    }
}

