/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.db.service;

import com.suncode.plugin.ftp.db.entities.FTPFileTimeModifier;
import com.suncode.plugin.ftp.db.entities.FTPFileTimeModifierDAO;
import com.suncode.plugin.ftp.db.service.FTPFileTimeModifierService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.sql.Timestamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FTPFileTimeModifierServiceImpl
implements FTPFileTimeModifierService {
    @Autowired
    private FTPFileTimeModifierDAO ftpFileTimeModifierDao;

    @Override
    public void save(ScheduledTaskInstanceInfo scheduledTaskInfo, long timestamp, String configurationName) {
        FTPFileTimeModifier entity = new FTPFileTimeModifier();
        entity.setTaskId(scheduledTaskInfo.getId());
        entity.setTaskName(scheduledTaskInfo.getName());
        entity.setLastModificationTime(new Timestamp(timestamp));
        entity.setConfigId(configurationName);
        this.ftpFileTimeModifierDao.save(entity);
    }

    @Override
    public void update(ScheduledTaskInstanceInfo scheduledTaskInfo, long timestamp, String configId) {
        FTPFileTimeModifier entity = this.findOne(scheduledTaskInfo.getId(), configId);
        entity.setTaskName(scheduledTaskInfo.getName());
        entity.setLastModificationTime(new Timestamp(timestamp));
        entity.setConfigId(configId);
        this.ftpFileTimeModifierDao.update(entity);
    }

    @Override
    public FTPFileTimeModifier findOne(Long taskId, String configId) {
        HibernateCriteria ftpCriteria = HibernateCriteria.forClass(FTPFileTimeModifier.class);
        ftpCriteria.add(Restrictions.eq((String)"taskId", (Object)taskId));
        ftpCriteria.add(Restrictions.in((String)"configId", (Object[])new Object[]{configId, "", null}));
        return (FTPFileTimeModifier)this.ftpFileTimeModifierDao.findOne(ftpCriteria);
    }

    @Override
    public void saveOrUpdate(ScheduledTaskInstanceInfo scheduledTaskInfo, Long newestModificationTime, boolean isSave, String configurationName) {
        if (isSave) {
            this.save(scheduledTaskInfo, newestModificationTime, configurationName);
        } else {
            this.update(scheduledTaskInfo, newestModificationTime, configurationName);
        }
    }
}

