/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.task;

import com.suncode.plugin.ftp.category.Categories;
import com.suncode.plugin.ftp.configuration.dto.ConnectionConfigurationDto;
import com.suncode.plugin.ftp.configuration.service.FtpConfigurationService;
import com.suncode.plugin.ftp.connection.ClientConnection;
import com.suncode.plugin.ftp.connection.factory.ClientConnectionFactory;
import com.suncode.plugin.ftp.db.entities.FTPFileTimeModifier;
import com.suncode.plugin.ftp.db.service.FTPFileTimeModifierService;
import com.suncode.plugin.ftp.dto.DownloadedFileDto;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="scripts/dpwe/download-file-from-server-form.js")
public class DownloadFilesFromFTPTask {
    private static final Logger log = LoggerFactory.getLogger(DownloadFilesFromFTPTask.class);
    @Autowired
    private FtpConfigurationService ftpConfigurationService;
    @Autowired
    private FTPFileTimeModifierService ftpFileTimeModifierService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plus-ftp-client.download-file-from-server.scheduled-task")).name("plus-ftp-client.download-file-from-server.name")).description("plus-ftp-client.download-file-from-server.desc")).category(new Category[]{Categories.FTP})).parameter().id("configurationName").name("plus-ftp-client.download-file-from-server.configuration-name.name").description("plus-ftp-client.download-file-from-server.configuration-name.desc").type((Type)Types.STRING).create()).parameter().id("remoteDirPath").name("plus-ftp-client.download-file-from-server.remote-dir-path.name").description("plus-ftp-client.download-file-from-server.remote-dir-path.desc").type((Type)Types.STRING).create()).parameter().id("localDirPath").name("plus-ftp-client.download-file-from-server.local-dir-path.name").description("plus-ftp-client.download-file-from-server.local-dir-path.desc").type((Type)Types.STRING).create()).parameter().id("deleteRemoteFile").name("plus-ftp-client.download-file-from-server.delete-remote-file.name").description("plus-ftp-client.download-file-from-server.delete-remote-file.desc").type((Type)Types.BOOLEAN).create()).parameter().id("overwriteFiles").name("plus-ftp-client.download-file-from-server.overwrite-files.name").description("plus-ftp-client.download-file-from-server.overwrite-files.desc").type((Type)Types.BOOLEAN).create()).parameter().id("moveRemoteFiles").name("plus-ftp-client.download-file-from-server.move-remote-files.name").description("plus-ftp-client.download-file-from-server.move-remote-files.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)false).create()).parameter().id("moveRemoteDirPath").name("plus-ftp-client.download-file-from-server.move-remote-dir-path.name").description("plus-ftp-client.download-file-from-server.move-remote-dir-path.desc").type((Type)Types.STRING).optional().create()).parameter().id("overwriteMovedFiles").name("plus-ftp-client.download-file-from-server.overwrite-moved-files.name").description("plus-ftp-client.download-file-from-server.overwrite-moved-files.desc").type((Type)Types.BOOLEAN).optional().create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(@Param String configurationName, @Param String remoteDirPath, @Param String localDirPath, @Param Boolean deleteRemoteFile, @Param Boolean overwriteFiles, @Param Boolean moveRemoteFiles, @Param String moveRemoteDirPath, @Param Boolean overwriteMovedFiles, ScheduledTaskInstanceInfo scheduledTaskInfo, org.apache.log4j.Logger taskLog) {
        try {
            taskLog.debug((Object)("Start task\t" + scheduledTaskInfo.getName()));
            ConnectionConfigurationDto connectionConfiguration = this.ftpConfigurationService.getConfigurationFromPCM(configurationName);
            FTPFileTimeModifier ftpFileTimeModifier = this.ftpFileTimeModifierService.findOne(scheduledTaskInfo.getId(), configurationName);
            Timestamp latestModificationTime = ftpFileTimeModifier == null ? new Timestamp(0L) : ftpFileTimeModifier.getLastModificationTime();
            ClientConnection clientConnection = ClientConnectionFactory.getClientConnection(connectionConfiguration.getProtocol());
            List<DownloadedFileDto> downloadedFiles = clientConnection.downloadFilesFromServer(localDirPath, remoteDirPath, deleteRemoteFile, Boolean.TRUE.equals(moveRemoteFiles), moveRemoteDirPath, Boolean.TRUE.equals(overwriteMovedFiles), connectionConfiguration, Boolean.TRUE.equals(overwriteFiles), latestModificationTime);
            for (DownloadedFileDto file : downloadedFiles) {
                taskLog.debug((Object)("Downloaded: " + file.getName() + " from " + file.getRemoteDirPath() + "to " + file.getLocalDirPath() + ". Delete remote file: " + file.getDeletedRemoteFile()));
                if (file.getException() == null) continue;
                taskLog.error((Object)("\nERROR:\n" + file.getException()));
            }
            Optional<Long> newestModificationTime = downloadedFiles.stream().max(Comparator.comparing(DownloadedFileDto::getRemoteFileModificationTime)).map(DownloadedFileDto::getRemoteFileModificationTime);
            newestModificationTime.ifPresent(newModificationTime -> this.ftpFileTimeModifierService.saveOrUpdate(scheduledTaskInfo, (Long)newModificationTime, ftpFileTimeModifier == null, configurationName));
            Long countedDeletedFiles = downloadedFiles.stream().filter(DownloadedFileDto::getDeletedRemoteFile).count();
            Long countedMovedFiles = downloadedFiles.stream().filter(d -> Boolean.TRUE.equals(d.getMovedRemoteFile())).count();
            taskLog.debug((Object)this.summary(downloadedFiles.size(), latestModificationTime.getTime(), countedDeletedFiles.intValue(), countedMovedFiles.intValue()));
            String string = this.summary(downloadedFiles.size(), latestModificationTime.getTime(), countedDeletedFiles.intValue(), countedMovedFiles.intValue());
            return string;
        }
        catch (Exception e) {
            if (e.getMessage().contains("Remote directory doesn't exist")) {
                taskLog.debug((Object)"Remote directory doesn't exist");
                throw e;
            }
            taskLog.error((Object)"ERROR\n", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)("End task\t" + scheduledTaskInfo.getName()));
        }
    }

    private String summary(int size, long time, int countedDeletedFiles, int countedMovedFiles) {
        return "Download " + size + " files from FTP Server from " + new DateTime(time).toString("dd-MM-yyyy HH:mm:ss") + ".\t" + "Number of files deleted on the ftp server:\t" + countedDeletedFiles + "\t" + "Number of files moved on the ftp server:\t" + countedMovedFiles;
    }
}

