/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.application;

import com.suncode.plugin.ftp.category.Categories;
import com.suncode.plugin.ftp.configuration.dto.ConnectionConfigurationDto;
import com.suncode.plugin.ftp.configuration.service.FtpConfigurationService;
import com.suncode.plugin.ftp.connection.ClientConnection;
import com.suncode.plugin.ftp.connection.factory.ClientConnectionFactory;
import com.suncode.plugin.ftp.dto.FileToSendDto;
import com.suncode.plugin.ftp.exception.FTPClientConnectionException;
import com.suncode.plugin.ftp.exception.FTPClientSaveException;
import com.suncode.plugin.ftp.file.modifier.FileNameModifier;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dpwe/upload-documents-to-server-form.js")
public class UploadDocumentsToServer {
    private static final Logger log = LoggerFactory.getLogger(UploadDocumentsToServer.class);
    @Autowired
    private FtpConfigurationService ftpConfigurationService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("upload-documents-to-server")).name("dual.upload-documents-to-server.name")).description("dual.upload-documents-to-server.desc")).category(new Category[]{Categories.FTP})).icon((Icon)SilkIconPack.APPLICATION_ADD)).contextVariable().id("fileNameWithExtension").name("dual.upload-documents-to-server.file-name-with-extension.name").description("dual.upload-documents-to-server.file-name-with-extension.desc").type((Type)Types.STRING).create().contextVariable().id("fileNameWithoutExtension").name("dual.upload-documents-to-server.file-name-without-extension.name").description("dual.upload-documents-to-server.file-name-without-extension.desc").type((Type)Types.STRING).create().contextVariable().id("fileExtension").name("dual.upload-documents-to-server.file-extension.name").description("dual.upload-documents-to-server.file-extension.desc").type((Type)Types.STRING).create().parameter().id("configurationName").name("dual.upload-documents-to-server.configuration-name.name").description("dual.upload-documents-to-server.configuration-name.desc").type((Type)Types.STRING).create()).parameter().id("directory").name("dual.upload-documents-to-server.directory.name").description("dual.upload-documents-to-server.directory.desc").type((Type)Types.STRING).create()).parameter().id("documentClass").name("dual.upload-documents-to-server.document-class.name").description("dual.upload-documents-to-server.document-class.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("subdirectory").name("dual.upload-documents-to-server.subdirectory.name").description("dual.upload-documents-to-server.subdirectory.desc").type((Type)Types.FUNCTION_ARRAY).optional().create()).parameter().id("fileName").name("dual.upload-documents-to-server.file-name.name").description("dual.upload-documents-to-server.file-name.desc").type((Type)Types.FUNCTION_ARRAY).optional().create();
    }

    public void execute(ApplicationContext context, Translator translator, ContextVariables contextVariables, @Param String configurationName, @Param String directory, @PairedParam(key="documentClass", value="subdirectory") Map<String, FunctionCall> docClassesAndSubdirectories, @PairedParam(key="documentClass", value="fileName") Map<String, FunctionCall> docClassesAndFilesName) {
        this.run((WorkflowContext)context, translator, contextVariables, configurationName, directory, docClassesAndSubdirectories, docClassesAndFilesName);
    }

    public void set(AcceptanceContext context, Translator translator, ContextVariables contextVariables, @Param String configurationName, @Param String directory, @PairedParam(key="documentClass", value="subdirectory") Map<String, FunctionCall> docClassesAndSubdirectories, @PairedParam(key="documentClass", value="fileName") Map<String, FunctionCall> docClassesAndFilesName) {
        this.run((WorkflowContext)context, translator, contextVariables, configurationName, directory, docClassesAndSubdirectories, docClassesAndFilesName);
    }

    private void run(WorkflowContext context, Translator translator, ContextVariables contextVariables, String configurationName, String directory, Map<String, FunctionCall> docClassesAndSubdirectories, Map<String, FunctionCall> docClassesAndFilesName) {
        String message;
        ConnectionConfigurationDto connectionConfiguration = null;
        try {
            connectionConfiguration = this.ftpConfigurationService.getConfigurationFromPCM(configurationName);
        }
        catch (Exception e) {
            this.createErrorComment(context, translator.getMessage("configuration-exception.ftp-client.error-message"));
            throw e;
        }
        boolean isAnyDocumentPresent = false;
        HashMap<String, List<FileToSendDto>> allFilesToSend = new HashMap<String, List<FileToSendDto>>();
        for (Map.Entry<String, FunctionCall> docClassAndSubdirectory : docClassesAndSubdirectories.entrySet()) {
            List documentsFromProcess = this.documentFinder.getDocumentsFromProcessAndClass(context.getProcessId(), docClassAndSubdirectory.getKey(), new String[]{"documentClass"});
            if (!CollectionUtils.isNotEmpty((Collection)documentsFromProcess)) continue;
            isAnyDocumentPresent = true;
            for (WfDocument document : documentsFromProcess) {
                Long fileId = document.getFile().getId();
                String orginalFileName = document.getFile().getFileName();
                contextVariables.set("fileNameWithExtension", (Object)orginalFileName);
                contextVariables.set("fileNameWithoutExtension", (Object)this.getFileNameWithoutExtension(orginalFileName));
                contextVariables.set("fileExtension", (Object)this.getFileExtension(orginalFileName));
                String subdirectory = docClassAndSubdirectory.getValue() != null ? (String)docClassAndSubdirectory.getValue().call() : "";
                FunctionCall fileNameFunction = docClassesAndFilesName.get(docClassAndSubdirectory.getKey());
                String fileName = fileNameFunction != null ? (String)fileNameFunction.call() : orginalFileName;
                FileToSendDto fileToSend = this.createFileToSendDto(directory + "/" + subdirectory, fileName, orginalFileName, fileId);
                if (!allFilesToSend.containsKey(fileToSend.getFilePath())) {
                    allFilesToSend.put(fileToSend.getFilePath(), new ArrayList());
                }
                ((List)allFilesToSend.get(fileToSend.getFilePath())).add(fileToSend);
            }
        }
        if (!isAnyDocumentPresent) {
            log.debug("No documents were found attached to the process of the specified document classes. Therefore a connection to the server FTP will not be initialized");
            return;
        }
        this.changeFilesNameIfDuplicated(allFilesToSend);
        try {
            ClientConnection connection = ClientConnectionFactory.getClientConnection(connectionConfiguration.getProtocol());
            connection.sendFilesToServer(connectionConfiguration, allFilesToSend);
        }
        catch (FTPClientSaveException fcse) {
            message = translator.getMessage(fcse.getTranslatorKey(), new Object[]{fcse.getOrginalFileName(), fcse.getNumberOfCreatedFiles(), fcse.getNumberOfCreatedCategories()});
            this.createErrorComment(context, message);
            throw fcse;
        }
        catch (FTPClientConnectionException fcce) {
            message = translator.getMessage(fcce.getTranslatorKey());
            this.createErrorComment(context, message);
            throw fcce;
        }
    }

    private void changeFilesNameIfDuplicated(Map<String, List<FileToSendDto>> allFilesToSend) {
        for (String filePath : allFilesToSend.keySet()) {
            Map<String, Long> groupedByAndCountedNames = this.checkFilesNameUniqness(allFilesToSend.get(filePath));
            boolean isFileNameDuplicated = groupedByAndCountedNames.values().stream().anyMatch(value -> value > 1L);
            if (!isFileNameDuplicated) continue;
            allFilesToSend.put(filePath, this.changeFileName(allFilesToSend.get(filePath)));
        }
    }

    private FileToSendDto createFileToSendDto(String filePath, String fileName, String orginalFileName, Long fileId) {
        filePath = filePath.replaceAll("\\/\\/", "\\/");
        FileToSendDto file = new FileToSendDto();
        CharSequence[] path = filePath.split("/");
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setOriginalFileName(orginalFileName);
        file.setFilePath(String.join((CharSequence)"/", path) + "/");
        return file;
    }

    private Map<String, Long> checkFilesNameUniqness(List<FileToSendDto> filesToSend) {
        return filesToSend.stream().collect(Collectors.groupingBy(FileToSendDto::getFileName, Collectors.counting()));
    }

    private List<FileToSendDto> changeFileName(List<FileToSendDto> filesToSend) {
        FileNameModifier fileNameModifier = new FileNameModifier(new LinkedHashSet<String>());
        LinkedList<FileToSendDto> modifiedFilesToSend = new LinkedList<FileToSendDto>();
        for (FileToSendDto fileToSend : filesToSend) {
            fileToSend.setFileName(fileNameModifier.changeFileName(fileToSend.getFileName()));
            modifiedFilesToSend.add(fileToSend);
        }
        return modifiedFilesToSend;
    }

    private String getFileNameWithoutExtension(String fileName) {
        return FilenameUtils.removeExtension((String)fileName);
    }

    private String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    private void createErrorComment(WorkflowContext context, String message) {
        Comment comment = new Comment();
        comment.setComment(message);
        comment.setActivityId(context.getActivityId());
        comment.setProcessId(context.getProcessId());
        comment.setTimestamp(Long.valueOf(new DateTime().getMillis()));
        comment.setUserId("admin");
        this.commentService.createComment(comment);
    }
}

