PW.ScheduledTasks.register('plus-ftp-client.download-file-from-server.scheduled-task', {
    buildParams: function (form) {
        form.addCombobox({
            id: 'configurationName',
            remote: {
                url: "plugin/com.suncode.plugin-plus-ftp-client/config/configurationFilesList",
                fields: [
                    {
                        name: "configurationFileName",
                        type: "string"
                    }
                ]
            },
            valueField: "configurationFileName",
            displayField: "configurationFileName",
            sort: {
                field: "configurationFileName",
                direction: "ASC"
            },
        });
        form.addField('remoteDirPath');
        form.addField('localDirPath');

        form.addCheckbox({
            id: 'deleteRemoteFile',
            listeners: {
                check: function (field, newValue) {
                    toggleOnDeleteRemoteFileChange(form, newValue);
                }
            }
        });

        form.addCheckbox('overwriteFiles');

        form.addCheckbox({
            id: 'moveRemoteFiles',
            listeners: {
                check: function (field, newValue) {
                    toggleOnMoveRemoteFileChange(form, newValue);
                }
            }
        });

        form.addField('moveRemoteDirPath');
        form.addField('overwriteMovedFiles');

        toggleOnMoveRemoteFileChange(form, form.getValue('moveRemoteFiles'));
    }
});

function toggleOnDeleteRemoteFileChange(form, deleteRemoteFileValue) {
    if (deleteRemoteFileValue) {
        if (form.getValue('moveRemoteFiles') === true) {
            form.setValue('moveRemoteFiles', false);
        }
        toggleMoveFieldsVisibility(form, false);
    } else {
        toggleMoveFieldsVisibility(form, form.getValue('moveRemoteFiles') === true);
    }
}

function toggleOnMoveRemoteFileChange(form, moveRemoteFileValue) {
    if (moveRemoteFileValue) {
        if (form.getValue('deleteRemoteFile') === true) {
            form.setValue('deleteRemoteFile', false);
        }
        toggleMoveFieldsVisibility(form, true);
    } else {
        toggleMoveFieldsVisibility(form, false);
    }
}

function toggleMoveFieldsVisibility(form, show) {
    if (show) {
        form.show('moveRemoteDirPath');
        form.setRequired('moveRemoteDirPath', true);
        form.show('overwriteMovedFiles');
    } else {
        form.hide('moveRemoteDirPath');
        form.setRequired('moveRemoteDirPath', false);
        form.hide('overwriteMovedFiles');
    }
}