/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.controller;

import com.suncode.plugin.ftp.controller.tools.ControllerTools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class FTPClientDocumentController {
    @Autowired
    private DocumentClassService documentClassService;

    @RequestMapping(value={"documentClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        List documentClasses = this.documentClassService.getAll(new String[0]);
        LinkedList<Map<String, String>> documentClassInfoList = new LinkedList<Map<String, String>>();
        for (DocumentClass documentClass : documentClasses) {
            if (!StringUtils.isBlank((CharSequence)query) && !documentClass.getName().toLowerCase().contains(query.toLowerCase())) continue;
            documentClassInfoList.add(Collections.singletonMap("documentClassName", documentClass.getName()));
        }
        ControllerTools<Map<String, String>> controllerTools = new ControllerTools<Map<String, String>>();
        int totalResult = documentClassInfoList.size();
        result.setData(controllerTools.getSubData(documentClassInfoList, Integer.parseInt(start), Integer.parseInt(limit), totalResult));
        result.setTotal((long)totalResult);
        return result;
    }
}

